/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SmokeParticle
extends EntitySmokeFX {
    private static final double ON_HIT_MOTION_REDICTION = 0.7;
    private static final double ON_HIT_KICK_BACK = 0.1;

    public SmokeParticle(World world, Vect3d pos, float intencity, float scale, ColorARGB color) {
        super(world, pos.x, pos.y, pos.z, 0.0, (double)intencity / 10.0 * CommonMath.Random.getDouble(), 0.0, scale);
        this.func_70538_b(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        this.field_70121_D.func_72328_c(ForgeEntity.getBB((Entity)this));
        ForgeEntity.setCollidable((Entity)this, (boolean)true);
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public void func_70091_d(double dx, double dy, double dz) {
        Conductor conductor;
        BlockPos pos;
        MovingObjectPosition rayTrace;
        Vect3d curPos = ForgeEntity.getCurPosition((Entity)this);
        Vect3d nextPos = curPos.move(dx, dy, dz);
        World world = this.field_70170_p;
        if (!(!ForgeEntity.isCollidable((Entity)this) || (rayTrace = ForgeWorld.rayTraceBlocks((World)world, (Vect3d)curPos, (Vect3d)nextPos, (boolean)false)) == null || rayTrace.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || WorldData.isChimney(world, pos = BlockPos.from((int)rayTrace.field_72311_b, (int)rayTrace.field_72312_c, (int)rayTrace.field_72309_d)) || (conductor = WorldData.smokeConductors.find(world, pos)) != null && CommonMath.Random.result((float)conductor.getPatency()))) {
            CommonMath.Angle angle = CommonMath.Angle.random();
            double motion = this.field_70181_x * this.getOnHitMotionReduction();
            this.field_70159_w = angle.cos() * motion;
            this.field_70179_y = angle.sin() * motion;
            this.field_70122_E = true;
            this.field_70181_x = 0.0;
            nextPos = Vect3d.from((Vec3)rayTrace.field_72307_f).move(0.0, -this.getOnHitKickBack(), 0.0).add(ForgeEntity.getMotion((Entity)this));
        }
        ForgeEntity.setCurPosition((Entity)this, (Vect3d)nextPos);
    }

    protected double getOnHitMotionReduction() {
        return 0.7;
    }

    protected double getOnHitKickBack() {
        return 0.1;
    }
}

