/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod;

import com.endertech.common.Args;
import com.endertech.common.CommonArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ForgeClassTransformer
implements IClassTransformer {
    private void logInfo(String msg, Object ... params) {
        String loggerName = this.getClass().getSimpleName();
        LogManager.getLogger((String)loggerName).info(msg, params);
    }

    public ClassNode getClassNode(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    public byte[] getByteCode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    protected abstract Name getTargetClassName();

    protected abstract MethodSignature getTargetMethodSignature();

    protected abstract boolean isProperNode(MethodInsnNode var1);

    protected abstract void injectInstructions(MethodNode var1, MethodInsnNode var2);

    private byte[] transformClass(byte[] classByteCode) {
        this.logInfo("Transforming class: {}", this.getTargetClassName());
        ClassNode classNode = this.getClassNode(classByteCode);
        boolean classTransformed = false;
        for (MethodNode methodNode : classNode.methods) {
            boolean methodTransformed;
            if (!this.getTargetMethodSignature().complyWith(methodNode) || !(methodTransformed = this.transformMethod(methodNode))) continue;
            classTransformed = true;
        }
        this.logInfo("Class transformation result: {}", classTransformed);
        return classTransformed ? this.getByteCode(classNode) : classByteCode;
    }

    private boolean transformMethod(MethodNode methodNode) {
        this.logInfo("\ttransforming method: {}", this.getTargetMethodSignature());
        ListIterator iterator = methodNode.instructions.iterator();
        boolean methodTransformed = false;
        while (iterator.hasNext()) {
            MethodInsnNode instructNode;
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!(node instanceof MethodInsnNode) || !this.isProperNode(instructNode = (MethodInsnNode)node)) continue;
            this.logInfo("\t\tfound method instruction node: {}", instructNode.getClass().getSimpleName() + Args.group(Args.get("opcode", instructNode.getOpcode()), Args.get("owner", instructNode.owner), Args.get("name", instructNode.name), Args.get("descriptor", instructNode.desc)));
            this.injectInstructions(methodNode, instructNode);
            methodTransformed = true;
            break;
        }
        this.logInfo("\tmethod transformation result: {}", methodTransformed);
        return methodTransformed;
    }

    public byte[] transform(String name, String transformedName, byte[] classByteCode) {
        Name targetName = this.getTargetClassName();
        return targetName.complyWith(transformedName) || targetName.complyWith(name) ? this.transformClass(classByteCode) : classByteCode;
    }

    public static class MethodSignature {
        public final MethodName name;
        public final MethodDescriptor descriptor;

        public MethodSignature(MethodName name, MethodDescriptor descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean complyWith(MethodNode methodNode) {
            return this.name.complyWith(methodNode.name) && this.descriptor.complyWith(methodNode.desc);
        }

        public String toString() {
            return MethodSignature.class.getSimpleName() + Args.group(this.name, this.descriptor);
        }
    }

    public static class MethodDescriptor {
        private final List<Descriptor> parameters = new ArrayList<Descriptor>();
        private final Descriptor returnType;

        public MethodDescriptor(Descriptor returnType) {
            this.returnType = returnType;
        }

        public MethodDescriptor() {
            this.returnType = Types.VOID.descriptor;
        }

        public MethodDescriptor(Types returnType) {
            this.returnType = returnType.descriptor;
        }

        public MethodDescriptor add(Descriptor ... parameters) {
            this.parameters.addAll(Arrays.asList(parameters));
            return this;
        }

        public boolean complyWith(String string) {
            return this.toString(false).equals(string) || this.toString(true).equals(string);
        }

        public MethodDescriptor reverseParameters() {
            MethodDescriptor result = new MethodDescriptor(this.returnType);
            Descriptor[] params = this.parameters.toArray(new Descriptor[0]);
            CommonArray.reverse(params);
            result.add(params);
            return result;
        }

        public String toString(boolean obfuscated) {
            StringBuilder result = new StringBuilder("(");
            for (Name name : this.parameters) {
                result.append(name.toString(obfuscated));
            }
            result.append(")").append(this.returnType.toString(obfuscated));
            return result.toString();
        }

        public String toString() {
            return MethodDescriptor.class.getSimpleName() + Args.group(Args.get("normal", this.toString(false)), Args.get("obfuscated", this.toString(true)));
        }
    }

    public static class NodeDescriptor {
        private final MethodDescriptor descriptor;

        public NodeDescriptor(MethodDescriptor descriptor) {
            this.descriptor = descriptor.reverseParameters();
        }

        public String toString(boolean obfuscated) {
            return this.descriptor.toString(obfuscated);
        }

        public boolean complyWith(String string) {
            return this.descriptor.complyWith(string);
        }

        public String toString() {
            return this.descriptor.toString();
        }
    }

    public static class TypeDescriptor
    extends Descriptor {
        public TypeDescriptor(String name) {
            super("", new Name(name, name), "");
        }
    }

    public static class ClassDescriptor
    extends Descriptor {
        private static final String PREFIX = "L";
        private static final String SUFFIX = ";";

        public ClassDescriptor(String normal, String obfuscated) {
            this(new Name(normal, obfuscated));
        }

        public ClassDescriptor(Name name) {
            super(PREFIX, name, SUFFIX);
        }
    }

    public static class Descriptor
    extends Name {
        public final Name name;

        public Descriptor(String prefix, Name name, String suffix) {
            super(prefix + name.normal + suffix, prefix + name.obfuscated + suffix);
            this.name = name;
        }
    }

    public static class MethodName
    extends Name {
        public final String srg;

        public MethodName(String normal, String obfuscated, String srg) {
            super(normal, obfuscated);
            this.srg = srg;
        }

        @Override
        public boolean complyWith(String string) {
            return super.complyWith(string) || this.srg.equals(string);
        }

        @Override
        public String toString() {
            return MethodName.class.getSimpleName() + Args.group(Args.get("srg", this.srg)) + Args.extend(super.toString());
        }
    }

    public static class Name {
        public final String normal;
        public final String obfuscated;

        public Name(String normal, String obfuscated) {
            this.normal = normal;
            this.obfuscated = obfuscated;
        }

        public boolean complyWith(String string) {
            return this.normal.equals(string) || this.obfuscated.equals(string);
        }

        public String toString() {
            return Name.class.getSimpleName() + Args.group(Args.get("normal", this.normal), Args.get("obfuscated", this.obfuscated));
        }

        public String toString(boolean obfuscated) {
            return obfuscated ? this.obfuscated : this.normal;
        }
    }

    public static class Hook {
        public final String classInternalName;
        public final String methodName;

        public Hook(String classInternalName, String methodName) {
            this.classInternalName = classInternalName;
            this.methodName = methodName;
        }
    }

    public static enum Types {
        VOID("V"),
        BOOLEAN("Z"),
        INT("I"),
        FLOAT("F"),
        DOUBLE("D");

        public final TypeDescriptor descriptor;

        private Types(String name) {
            this.descriptor = new TypeDescriptor(name);
        }
    }

    public static enum Classes {
        ITEM_RENDERER("net.minecraft.client.renderer.ItemRenderer", "bly"),
        ITEM_STACK("net/minecraft/item/ItemStack", "add"),
        ENTITY_LIVING_BASE("net/minecraft/entity/EntityLivingBase", "sv");

        public final ClassDescriptor descriptor;

        private Classes(String normal, String obfuscated) {
            this.descriptor = new ClassDescriptor(normal, obfuscated);
        }
    }
}

