/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class ForgeEntity
extends Entity {
    public ForgeEntity(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public static Vect3d getBBCenter(AxisAlignedBB bb) {
        if (bb != null) {
            return Vect3d.from(CommonMath.getAverage(bb.field_72340_a, bb.field_72336_d), CommonMath.getAverage(bb.field_72338_b, bb.field_72337_e), CommonMath.getAverage(bb.field_72339_c, bb.field_72334_f));
        }
        return Vect3d.ZERO;
    }

    public Vect3d getBBCenter() {
        return ForgeEntity.getBBCenter(this.getBB());
    }

    public static Vect3d getCenterPosition(Entity entity) {
        return ForgeEntity.getBBCenter(ForgeEntity.getBB(entity));
    }

    public static Vect3d getCenterPosition(Entity entity, float tickProgress) {
        return ForgeEntity.getBBCenter(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity, tickProgress)));
    }

    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static void setCollisionReduction(Entity entity, float factor) {
        if (entity != null) {
            entity.field_70144_Y = factor;
        }
    }

    public static Vect3d getMotion(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y) : Vect3d.ZERO;
    }

    public Vect3d getMotion() {
        return ForgeEntity.getMotion(this);
    }

    public static void setMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            boolean motionChanged = ForgeEntity.getMotion(entity).notEqual(vec);
            entity.field_70159_w = vec.x;
            entity.field_70181_x = vec.y;
            entity.field_70179_y = vec.z;
            if (motionChanged) {
                entity.field_70133_I = true;
            }
        }
    }

    public void setMotion(Vect3d vec) {
        ForgeEntity.setMotion(this, vec);
    }

    public void move() {
        this.setPrevPosition(this.getCurPosition());
        this.setCurPosition(this.getCurPosition().add(this.getMotion()));
    }

    public static void addMotion(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            ForgeEntity.setMotion(entity, ForgeEntity.getMotion(entity).add(vec));
        }
    }

    public void addMotion(Vect3d vec) {
        ForgeEntity.addMotion(this, vec);
    }

    public static void copyAllPositionsWithOffset(Entity source, Entity target, Vect3d offset) {
        if (source != null && target != null) {
            ForgeEntity.setPrevPosition(target, ForgeEntity.getPrevPosition(source).add(offset));
            ForgeEntity.setLastTickPosition(target, ForgeEntity.getLastTickPosition(source).add(offset));
            ForgeEntity.setCurPosition(target, ForgeEntity.getCurPosition(source).add(offset));
        }
    }

    public static BlockPos getPosition(Entity entity) {
        return BlockPos.from(ForgeEntity.getCurPosition(entity));
    }

    public static Vect3d getCurPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) : Vect3d.ZERO;
    }

    public static Vect3d getCurPosition(Entity entity, float tickProgress) {
        return Vect3d.approx(tickProgress, ForgeEntity.getLastTickPosition(entity), ForgeEntity.getCurPosition(entity));
    }

    public Vect3d getCurPosition() {
        return ForgeEntity.getCurPosition(this);
    }

    public Vect3d getCurPosition(float tickProgress) {
        return ForgeEntity.getCurPosition(this, tickProgress);
    }

    public static Rotation getPrevRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70127_C, entity.field_70126_B) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70125_A, entity.field_70177_z) : Rotation.ZERO;
    }

    public static Rotation getRotation(Entity entity, float tickProgress) {
        return ForgeEntity.getPrevRotation(entity).approx(tickProgress, ForgeEntity.getRotation(entity));
    }

    public Rotation getRotation(float tickProgress) {
        return ForgeEntity.getRotation(this, tickProgress);
    }

    public Rotation getPrevRotation() {
        return ForgeEntity.getPrevRotation(this);
    }

    public Rotation getCurRotation() {
        return ForgeEntity.getRotation(this);
    }

    public static Vect3d getLastTickPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U) : Vect3d.ZERO;
    }

    public Vect3d getLastTickPosition() {
        return ForgeEntity.getLastTickPosition(this);
    }

    public static Vect3d getPrevPosition(Entity entity) {
        return entity != null ? Vect3d.from(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s) : Vect3d.ZERO;
    }

    public Vect3d getPrevPosition() {
        return ForgeEntity.getPrevPosition(this);
    }

    public static Vect3d getNextPosition(Entity entity) {
        return entity != null ? ForgeEntity.getCurPosition(entity).add(ForgeEntity.getMotion(entity)) : Vect3d.ZERO;
    }

    public Vect3d getNextPosition() {
        return ForgeEntity.getNextPosition(this);
    }

    public static void setCurPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.func_70107_b(vec.x, vec.y, vec.z);
        }
    }

    public static void setPosition_NoBB(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70165_t = vec.x;
            entity.field_70163_u = vec.y;
            entity.field_70161_v = vec.z;
        }
    }

    public static void setLastTickPosition(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70142_S = vec.x;
            entity.field_70137_T = vec.y;
            entity.field_70136_U = vec.z;
        }
    }

    public void setLastTickPosition(Vect3d vec) {
        ForgeEntity.setLastTickPosition(this, vec);
    }

    public static void setPrevPosition(Entity entity, Vect3d vec) {
        ForgeEntity.setLastTickPosition(entity, vec);
        if (entity != null && vec != null) {
            entity.field_70169_q = vec.x;
            entity.field_70167_r = vec.y;
            entity.field_70166_s = vec.z;
        }
    }

    public void setPrevPosition(Vect3d vec) {
        ForgeEntity.setPrevPosition(this, vec);
    }

    public void setCurPosition(Vect3d vec) {
        ForgeEntity.setCurPosition(this, vec);
    }

    public static void setPrevRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = rotation.pitch;
            entity.field_70126_B = rotation.yaw;
        }
    }

    public void setPrevRotation(Rotation rotation) {
        ForgeEntity.setPrevRotation(this, rotation);
    }

    public static void setRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70125_A = rotation.pitch;
            entity.field_70177_z = rotation.yaw;
        }
    }

    public void setCurRotation(Rotation rotation) {
        ForgeEntity.setRotation(this, rotation);
    }

    public static void setAllPositions(Entity entity, Vect3d vec) {
        if (entity != null && vec != null) {
            entity.field_70169_q = entity.field_70165_t = vec.x;
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70167_r = entity.field_70163_u = vec.y;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70166_s = entity.field_70161_v = vec.z;
            entity.field_70136_U = entity.field_70161_v;
            ForgeEntity.setCurPosition(entity, vec);
        }
    }

    public void setAllPositions(Vect3d vec) {
        ForgeEntity.setAllPositions(this, vec);
    }

    public static void setAllRotations(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = entity.field_70125_A = rotation.pitch;
            entity.field_70126_B = entity.field_70177_z = rotation.yaw;
        }
    }

    public void setAllRotations(Rotation rotation) {
        ForgeEntity.setAllRotations(this, rotation);
    }

    public static float getSize(Entity entity) {
        if (entity != null) {
            return entity.field_70130_N * entity.field_70131_O;
        }
        return 0.0f;
    }

    public static int getId(Entity entity) {
        return entity != null ? entity.func_145782_y() : -1;
    }

    public int getId() {
        return ForgeEntity.getId(this);
    }

    public float getSize() {
        return ForgeEntity.getSize(this);
    }

    public static void dismount(Entity entity) {
        if (entity != null && entity.field_70154_o != null) {
            entity.func_70078_a(null);
        }
    }

    public void mountOn(Entity entity) {
        if (entity != null) {
            this.func_70078_a(entity);
        }
    }

    public void dismount() {
        ForgeEntity.dismount(this);
    }

    public static float getWeight(Entity entity, boolean includePassenger, boolean includeRiding) {
        float weight = 0.0f;
        if (entity != null) {
            if (includePassenger && entity.field_70153_n != null) {
                weight += ForgeEntity.getWeight(entity.field_70153_n, includePassenger, false);
            }
            if (includeRiding && entity.field_70154_o != null) {
                weight += ForgeEntity.getWeight(entity.field_70154_o, false, includeRiding);
            }
            weight += ForgeEntity.getSize(entity);
        }
        return weight;
    }

    public static Entity getHighestPassenger(Entity entity) {
        if (entity != null && entity.field_70153_n != null) {
            return ForgeEntity.getHighestPassenger(entity.field_70153_n);
        }
        return entity;
    }

    public static List<Entity> getPassengers(Entity entity) {
        Entity passenger;
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        Entity ride = entity;
        while (ride != null && (passenger = ride.field_70153_n) != null) {
            passengers.add(passenger);
            ride = passenger;
        }
        return passengers;
    }

    public static boolean isRiding(Entity entity) {
        return entity != null && entity.field_70154_o != null;
    }

    public boolean func_70115_ae() {
        return ForgeEntity.isRiding(this);
    }

    public static Entity getLowestRiding(Entity rider) {
        if (rider != null && rider.field_70154_o != null) {
            return ForgeEntity.getLowestRiding(rider.field_70154_o);
        }
        return rider;
    }

    public static void setFallDistance(Entity entity, float distance, boolean includeRiding) {
        if (entity != null) {
            entity.field_70143_R = distance;
            if (includeRiding) {
                ForgeEntity.setFallDistance(entity.field_70154_o, distance, includeRiding);
            }
        }
    }

    public static void updateBB(Entity entity) {
        if (entity != null) {
            entity.field_70121_D.func_72328_c(ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity)));
        }
    }

    public static AxisAlignedBB getBB(Entity entity, Vect3d position) {
        if (entity != null && position != null) {
            double widthHalf = (double)entity.field_70130_N / 2.0;
            return AxisAlignedBB.func_72330_a((double)(position.x - widthHalf), (double)position.y, (double)(position.z - widthHalf), (double)(position.x + widthHalf), (double)(position.y + (double)entity.field_70131_O), (double)(position.z + widthHalf));
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public static AxisAlignedBB getBB(Entity entity) {
        return ForgeEntity.getBB(entity, ForgeEntity.getCurPosition(entity));
    }

    public AxisAlignedBB getBB(Vect3d position) {
        return ForgeEntity.getBB(this, position);
    }

    public AxisAlignedBB getBB() {
        return ForgeEntity.getBB(this, this.getCurPosition());
    }

    public void updateBB() {
        ForgeEntity.updateBB(this);
    }

    public static void stopMoving(Entity entity) {
        if (entity != null) {
            ForgeEntity.setMotion(entity, Vect3d.ZERO);
        }
    }

    public void stopMoving() {
        ForgeEntity.stopMoving(this);
    }

    public static boolean isServerSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isServerSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isServerSide() {
        return ForgeEntity.isServerSide(this);
    }

    public static boolean isClientSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isClientSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isClientSide() {
        return ForgeEntity.isClientSide(this);
    }

    public List<Entity> getEntitiesWithinAABB(AxisAlignedBB aaBB) {
        if (this.field_70170_p != null) {
            return this.field_70170_p.func_72839_b((Entity)this, aaBB);
        }
        return Collections.emptyList();
    }

    public static void setBB(Entity entity, Vect3d minPoint, Vect3d maxPoint) {
        if (entity != null && minPoint != null && maxPoint != null) {
            entity.field_70121_D.func_72328_c(AxisAlignedBB.func_72330_a((double)minPoint.x, (double)minPoint.y, (double)minPoint.z, (double)maxPoint.x, (double)maxPoint.y, (double)maxPoint.z));
        }
    }

    public void setBB(Vect3d minPoint, Vect3d maxPoint) {
        ForgeEntity.setBB(this, minPoint, maxPoint);
    }

    public static boolean hasSwingingPlayerPassenger(Entity entity) {
        if (entity != null) {
            for (Entity passenger : ForgeEntity.getPassengers(entity)) {
                if (!(passenger instanceof EntityPlayer) || !((EntityPlayer)passenger).field_82175_bq) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSwingingPlayerPassenger() {
        return ForgeEntity.hasSwingingPlayerPassenger(this);
    }

    public static boolean isCollidable(Entity entity) {
        return !entity.field_70145_X;
    }

    public boolean isCollidable() {
        return ForgeEntity.isCollidable(this);
    }

    public static void setCollidable(Entity entity, boolean value) {
        entity.field_70145_X = !value;
    }

    public void setCollidable(boolean value) {
        ForgeEntity.setCollidable(this, value);
    }

    public static void resetPositionToBB(Entity entity) {
        AxisAlignedBB aaBB = entity.func_70046_E();
        entity.field_70165_t = (aaBB.field_72340_a + aaBB.field_72336_d) / 2.0;
        entity.field_70163_u = aaBB.field_72338_b;
        entity.field_70161_v = (aaBB.field_72339_c + aaBB.field_72334_f) / 2.0;
    }

    protected void resetPositionToBB() {
        ForgeEntity.resetPositionToBB(this);
    }

    public static boolean hasStack(Entity entity, ItemStack stack) {
        EntityLiving living;
        if (stack == null) {
            return false;
        }
        if (entity instanceof EntityItem) {
            return ((EntityItem)entity).func_92059_d().equals(stack);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (ItemStack equipedStack : player.field_71071_by.field_70462_a) {
                if (!stack.equals(equipedStack)) continue;
                return true;
            }
        }
        return entity instanceof EntityLiving && stack.equals((living = (EntityLiving)entity).func_70694_bm());
    }
}

