/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class ForgeBlockContainer<T extends TileEntity>
extends ForgeBlock
implements ITileEntityProvider {
    private final Class<T> tileEntityClass;

    public ForgeBlockContainer(ForgeMod mod, UnitConfig config, Class<T> tileEntityClass, String name, Material material, CreativeTabs tab) {
        super(mod, config, name, material, tab);
        this.tileEntityClass = tileEntityClass;
        this.field_149758_A = true;
    }

    public void breakBlock(World world, BlockPos pos, Block block, int meta) {
        this.func_149749_a(world, pos.getX(), pos.getY(), pos.getZ(), block, meta);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int id, int param) {
        super.func_149696_a(world, x, y, z, id, param);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public UnitId getTileEntityId() {
        String unitName = UnitId.buildRegName(this.getId().getRegName(), "tile");
        return UnitId.from(this.getMod().getId(), unitName);
    }

    public Class<T> getTileEntityClass() {
        return this.tileEntityClass;
    }

    @Nullable
    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        try {
            return (TileEntity)this.getTileEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

