/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonArray;
import com.endertech.common.CommonPath;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.units.BlockState;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.ForgeStack;
import com.endertech.minecraft.forge.units.ItemState;
import cpw.mods.fml.common.registry.GameData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class UnitId {
    public static final UnitId EMPTY = UnitId.from("", "");
    public static final String FORMAT_FULL = "<modId:unitName:meta>";
    public static final String DESCRIPTION = "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n";
    public static final String DELIMITER = ":";
    public static final String MOD_ID_MINECRAFT = "minecraft";
    public static final String REG_NAME_WORDS_DELIMITER = "_";
    public static final String INCODE_DELIMITER = "$";
    public static final String META_ALL_CHAR = "*";
    public static final int META_ALL_INT = Short.MAX_VALUE;
    public static final int META_DEFAULT = 0;
    private final String modId;
    private final String regName;
    private final String dictName;
    private final int meta;
    private final Cache cache = new Cache();

    public UnitId(String modId, String regName, int meta) {
        this.modId = modId;
        this.regName = regName;
        this.dictName = UnitId.convertToDictName(regName);
        this.meta = meta;
    }

    public static String joinWords(String delimiter, String ... words) {
        ArrayList<String> wordsList = new ArrayList<String>();
        for (String word : words) {
            if ((word = word.trim()).isEmpty()) continue;
            wordsList.add(word);
        }
        return String.join((CharSequence)delimiter, wordsList);
    }

    public static String[] capitalizeWords(String ... words) {
        String[] capitalizedWords = new String[words.length];
        for (int i = 0; i < capitalizedWords.length; ++i) {
            capitalizedWords[i] = CommonString.capitalizeFirstChar(words[i]);
        }
        return capitalizedWords;
    }

    public static String buildRegName(String ... nameWords) {
        return UnitId.joinWords(REG_NAME_WORDS_DELIMITER, nameWords).toLowerCase(Locale.ROOT);
    }

    public static String[] splitRegName(String regName, boolean capitalizeWords, boolean invertOrder) {
        String[] nameWords = regName.split(REG_NAME_WORDS_DELIMITER);
        if (capitalizeWords) {
            nameWords = UnitId.capitalizeWords(nameWords);
        }
        if (invertOrder) {
            CommonArray.reverse(nameWords);
        }
        return nameWords;
    }

    public static String[] splitDictName(String dictName) {
        ArrayList<String> wordsList = new ArrayList<String>();
        int wordStartsAt = 0;
        for (int i = 0; i < dictName.length(); ++i) {
            char ch = dictName.charAt(i);
            if (Character.isUpperCase(ch) && i != 0) {
                String word = dictName.substring(wordStartsAt, i);
                wordsList.add(word);
                wordStartsAt = i;
            }
            if (i != dictName.length() - 1) continue;
            String lastWord = dictName.substring(wordStartsAt);
            wordsList.add(lastWord);
        }
        return wordsList.toArray(new String[0]);
    }

    public static String convertToDictName(String regName) {
        CharSequence[] nameWords = UnitId.splitRegName(regName, true, true);
        String dictName = String.join((CharSequence)"", nameWords);
        return CommonString.decapitalizeFirstChar(dictName);
    }

    protected static String getIdSegment(String id, Segments segment) {
        String[] parts = UnitId.ensureFullId(id).split(DELIMITER);
        return parts[segment.ordinal()].trim();
    }

    public static boolean isNullOrEmpty(UnitId unitId) {
        return unitId == null || unitId.isEmpty();
    }

    public boolean isEmpty() {
        return CommonString.isNullOrEmpty(this.getModId()) || CommonString.isNullOrEmpty(this.getRegName());
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public static UnitId from(String id) {
        return UnitId.from(UnitId.getModId(id), UnitId.getUnitName(id), UnitId.getMetaData(id));
    }

    public static UnitId from(Enum<?> e) {
        String stringId = String.valueOf(e).replace(INCODE_DELIMITER, DELIMITER);
        UnitId unitId = UnitId.from(stringId);
        return UnitId.hasMetaData(stringId) ? unitId : unitId.withMetaAll();
    }

    public static UnitId from(Path path) {
        String stringId = CommonPath.getFileNameOnly(path).replace(INCODE_DELIMITER, DELIMITER);
        return UnitId.from(stringId);
    }

    public static UnitId from(String modId, String ... nameWords) {
        return UnitId.from(modId, UnitId.buildRegName(nameWords));
    }

    public static UnitId from(String modId, String unitName) {
        return UnitId.from(modId, unitName, 0);
    }

    public static UnitId from(String modId, String unitName, int meta) {
        return new UnitId(modId, unitName, meta);
    }

    public static UnitId from(ResourceLocation location, int meta) {
        return UnitId.from(location.func_110624_b(), location.func_110623_a(), meta);
    }

    public static UnitId from(Item item, int meta) {
        String name = GameData.getItemRegistry().func_148750_c((Object)item);
        return name != null ? UnitId.from(name).withNewMeta(meta) : EMPTY;
    }

    public static UnitId from(Item item) {
        return UnitId.from(item, 0);
    }

    public static UnitId from(Block block, int meta) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        return name != null ? UnitId.from(name).withNewMeta(meta) : EMPTY;
    }

    public static UnitId from(Block block) {
        return UnitId.from(block, 0);
    }

    public static UnitId from(BlockState state) {
        return state.exists() ? UnitId.from(state.getBlock(), state.getMeta()) : EMPTY;
    }

    public static UnitId from(ItemState state) {
        return state.exists() ? UnitId.from(state.getItem(), state.getMeta()) : EMPTY;
    }

    protected static String ensureFullId(String id) {
        if (!UnitId.hasMetaData(id)) {
            id = String.join((CharSequence)DELIMITER, id, String.valueOf(0));
        }
        if (id.split(DELIMITER).length < Segments.values().length) {
            id = String.join((CharSequence)DELIMITER, MOD_ID_MINECRAFT, id);
        }
        return id;
    }

    protected static String getModId(String id) {
        return UnitId.getIdSegment(id, Segments.modId);
    }

    protected static String getUnitName(String id) {
        return UnitId.getIdSegment(id, Segments.unitName);
    }

    protected static int getMetaData(String id) {
        if (UnitId.hasMetaData(id)) {
            String metaData = UnitId.getIdSegment(id, Segments.meta);
            return metaData.equals(META_ALL_CHAR) ? Short.MAX_VALUE : Integer.parseInt(metaData);
        }
        return 0;
    }

    protected static boolean hasMetaData(String id) {
        String[] parts = id.split(DELIMITER);
        if (parts.length > 1) {
            String metaData = parts[parts.length - 1].trim();
            return metaData.contentEquals(META_ALL_CHAR) || CommonString.allCharsAreDigits(metaData);
        }
        return false;
    }

    public static boolean metasAreMatched(int meta1, int meta2) {
        return meta1 == meta2 || meta1 == Short.MAX_VALUE || meta2 == Short.MAX_VALUE;
    }

    public String getMetaData() {
        return this.getMeta() == Short.MAX_VALUE ? META_ALL_CHAR : String.valueOf(this.getMeta());
    }

    public boolean metaMatches(int meta) {
        return UnitId.metasAreMatched(this.getMeta(), meta);
    }

    protected Block getBlockOrNull() {
        return (Block)GameData.getBlockRegistry().getRaw(this.toResLoc().toString());
    }

    public BlockState getBlockState() {
        if (this.cache.blockState != null) {
            return this.cache.blockState;
        }
        Block block = this.getBlockOrNull();
        int meta = this.getMeta();
        if (block == null) {
            ForgeStack stack = this.getFirstFoundOre();
            if (stack.exists()) {
                block = ForgeBlock.getBlockOrNull(stack.getItem());
            }
            if (block != null) {
                meta = stack.getMeta();
            }
        }
        if (block != null) {
            this.cache.blockState = BlockState.from(block, meta);
            return this.cache.blockState;
        }
        return BlockState.EMPTY;
    }

    protected Item getItemOrNull() {
        return (Item)GameData.getItemRegistry().getRaw(this.toResLoc().toString());
    }

    public ItemState getItemState() {
        ForgeStack stack;
        if (this.cache.itemState != null) {
            return this.cache.itemState;
        }
        Item item = this.getItemOrNull();
        int meta = this.getMeta();
        if (item == null && (stack = this.getFirstFoundOre()).exists()) {
            item = stack.getItem();
            meta = stack.getMeta();
        }
        if (item != null) {
            this.cache.itemState = ItemState.from(item, meta);
            return this.cache.itemState;
        }
        return ItemState.EMPTY;
    }

    public List<BlockState> getAllBlockStates() {
        if (this.cache.allBlockStates.isEmpty()) {
            BlockState blockState = this.getBlockState();
            if (blockState.exists()) {
                this.cache.allBlockStates.add(blockState);
            }
            List<ItemStack> allOres = this.getAllOres();
            for (ItemStack stack : allOres) {
                Block block = ForgeBlock.getBlockOrNull(stack.func_77973_b());
                if (block == null) continue;
                blockState = BlockState.from(block, stack.func_77960_j());
                if (this.cache.allBlockStates.contains(blockState)) continue;
                this.cache.allBlockStates.add(blockState);
            }
        }
        return Collections.unmodifiableList(this.cache.allBlockStates);
    }

    protected List<ItemStack> getAllOres() {
        if (this.cache.allOres.isEmpty() && this.isOreDictName()) {
            this.cache.allOres = OreDictionary.getOres((String)this.getDictName(), (boolean)false);
        }
        return Collections.unmodifiableList(this.cache.allOres);
    }

    protected ForgeStack getFirstFoundOre() {
        List<ItemStack> allOres = this.getAllOres();
        if (allOres.isEmpty()) {
            return ForgeStack.EMPTY;
        }
        return ForgeStack.from(allOres.get(0));
    }

    public List<ItemState> getAllItemStates() {
        if (this.cache.allItemStates.isEmpty()) {
            ItemState itemState = this.getItemState();
            if (itemState.exists()) {
                this.cache.allItemStates.add(itemState);
            }
            List<ItemStack> oreList = this.getAllOres();
            for (ItemStack stack : oreList) {
                itemState = ItemState.from(stack.func_77973_b(), stack.func_77960_j());
                if (this.cache.allItemStates.contains(itemState)) continue;
                this.cache.allItemStates.add(itemState);
            }
        }
        return Collections.unmodifiableList(this.cache.allItemStates);
    }

    public UnitId withNewMeta(int meta) {
        return UnitId.from(this.getModId(), this.getRegName(), meta);
    }

    public UnitId withMetaAll() {
        return this.withNewMeta(Short.MAX_VALUE);
    }

    public UnitId withNewName(String newName) {
        return UnitId.from(this.getModId(), newName, this.getMeta());
    }

    public UnitId withNewName(String ... nameWords) {
        return UnitId.from(this.getModId(), nameWords).withNewMeta(this.getMeta());
    }

    public UnitId withNamePrefix(String prefix) {
        return this.withNewName(prefix, this.getRegName());
    }

    public UnitId withNameSuffix(String suffix) {
        return this.withNewName(this.getRegName(), suffix);
    }

    public String toString() {
        if (this.cache.string == null) {
            StringJoiner joiner = new StringJoiner(DELIMITER);
            if (!this.getModId().equals(MOD_ID_MINECRAFT)) {
                joiner.add(this.getModId());
            }
            joiner.add(this.getRegName());
            if (this.getMeta() != 0) {
                joiner.add(this.getMetaData());
            }
            this.cache.string = joiner.toString();
        }
        return this.cache.string;
    }

    public ResourceLocation toResLoc() {
        if (this.cache.location == null) {
            this.cache.location = new ResourceLocation(this.getModId(), this.getRegName());
        }
        return this.cache.location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitId) {
            UnitId id = (UnitId)obj;
            return this.getModId().equals(id.getModId()) && this.getRegName().equals(id.getRegName()) && this.getMeta() == id.getMeta();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getModId(), this.getRegName(), this.getMeta());
    }

    protected boolean isOreDictName() {
        return this.getRegName().equals(this.getDictName()) && this.getModId().equals(MOD_ID_MINECRAFT) && this.getMeta() == 0;
    }

    public String getRegName() {
        return this.regName;
    }

    public String getDictName() {
        return this.dictName;
    }

    public String getModId() {
        return this.modId;
    }

    public int getMeta() {
        return this.meta;
    }

    private class Cache {
        private BlockState blockState;
        private ItemState itemState;
        private List<BlockState> allBlockStates = new ArrayList<BlockState>();
        private List<ItemState> allItemStates = new ArrayList<ItemState>();
        private List<ItemStack> allOres = new ArrayList<ItemStack>();
        private ResourceLocation location;
        private String string;

        private Cache() {
        }
    }

    public static enum Segments {
        modId,
        unitName,
        meta;

    }
}

