/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.commands.ForgeCommand;
import com.endertech.minecraft.forge.commands.ICommandTask;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adlods.Main;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.Generator;
import com.endertech.minecraft.mods.adlods.ore.Stripper;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.StringJoiner;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class Command
extends ForgeCommand {
    public Command() {
        super("lods", (ICommandTask[])Tasks.values());
    }

    protected void sendDepositNotFoundMsg(ICommandSender sender, String name) {
        this.sendChatMessageTo(sender, "Deposit with name " + CommonString.quoted((String)name) + " not found! Use </lods list> command.");
    }

    public void executeTask(World world, String taskName, ICommandSender sender, String[] args) throws CommandException {
        ChunkPos centerPos;
        if (Tasks.ADD.complyWith(taskName, args)) {
            String name;
            Path baseDir = Main.getGenerator().getConfigsDir();
            File configFile = UnitConfig.buildPath((Path)baseDir, (String)(name = args[0])).toFile();
            if (configFile.isFile()) {
                this.sendChatMessageTo(sender, "Config file <" + configFile.getName() + "> already exists!");
                return;
            }
            Deposit deposit = Main.getGenerator().findDepositBy(name);
            if (deposit != null) {
                String fileName = deposit.getConfig().getConfigFile().getName();
                this.sendChatMessageTo(sender, "Deposit with this name already defined in: " + fileName);
                return;
            }
            try {
                int rarity = Integer.parseInt(args[1]);
                Deposit.Size size = Deposit.Size.from(args[2]);
                Deposit.Altitude altitude = Deposit.Altitude.from(args[3]);
                Deposit deposit2 = Main.getGenerator().createDeposit(baseDir, name, size, altitude, rarity);
                this.sendChatMessageTo(sender, "Deposit config created");
                if (!deposit2.isValid()) {
                    this.sendChatMessageTo(sender, "Deposit is not valid! Check its parameters");
                }
                if (Main.getGenerator().addDeposit(deposit2)) {
                    this.sendChatMessageTo(sender, "Deposit definition successfully added");
                }
                return;
            }
            catch (NumberFormatException e) {
                this.sendChatMessageTo(sender, e.toString());
                return;
            }
        }
        if (Tasks.REMOVE.complyWith(taskName, args)) {
            Path baseDir = Main.getGenerator().getConfigsDir();
            String name = args[0];
            File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
            Deposit deposit = Main.getGenerator().findDepositBy(name);
            if (deposit != null) {
                if (Main.getGenerator().removeDeposit(deposit)) {
                    this.sendChatMessageTo(sender, "Deposit definition removed");
                }
                configFile = deposit.getConfig().getConfigFile();
            }
            if (configFile.delete()) {
                this.sendChatMessageTo(sender, "Deposit config removed");
            }
            return;
        }
        if (Tasks.GEN.complyWith(taskName, args)) {
            String name = args[0];
            Deposit deposit = Main.getGenerator().findDepositBy(args[0]);
            if (deposit != null) {
                BlockPos startPos = sender.func_180425_c();
                DepositGenResult result = deposit.generateAt(world, new ChunkPos(startPos));
                this.sendChatMessageTo(sender, result.toString());
            } else {
                this.sendDepositNotFoundMsg(sender, name);
            }
            return;
        }
        if (Tasks.TEST.complyWith(taskName, args)) {
            String name = args[0];
            Deposit deposit = Main.getGenerator().findDepositBy(name);
            if (deposit != null) {
                BlockPos startPos = sender.func_180425_c();
                int amount = Integer.parseInt(args[1]);
                DepositGenResult result = deposit.generateAt(world, startPos, amount, true);
                this.sendChatMessageTo(sender, result.toString());
            } else {
                this.sendDepositNotFoundMsg(sender, name);
            }
            return;
        }
        if (Tasks.RELOAD.complyWith(taskName, args)) {
            Main.getGenerator().loadDeposits();
            Main.getVanillaGenController().loadOres();
            this.sendChatMessageTo(sender, "Configs reloaded");
            return;
        }
        if (Tasks.LIST.complyWith(taskName, args)) {
            switch (args[0]) {
                case "deposits": {
                    StringJoiner joiner = new StringJoiner(", ");
                    for (Deposit deposit : Main.getGenerator().getDeposits()) {
                        joiner.add(deposit.getName());
                    }
                    this.sendChatMessageTo(sender, joiner.toString());
                    return;
                }
                case "generated": {
                    for (DepositGenResult result : WorldData.getData(world).getGeneratedDeposits().values()) {
                        Main.instance.getLogger().info((Object)result);
                    }
                    this.sendChatMessageTo(sender, "List of generated deposits was written to the log");
                    return;
                }
            }
        }
        if (Tasks.STRIP.complyWith(taskName, args)) {
            centerPos = new ChunkPos(sender.func_180425_c());
            Stripper stripper = Stripper.getFor(world);
            Generator generator = Main.getGenerator();
            switch (args[0]) {
                case "chunk": {
                    stripper.stripChunk(world, centerPos, generator::isOreBlock);
                    this.sendChatMessageTo(sender, "Chunk at " + centerPos + " stripped");
                    return;
                }
                case "around": {
                    stripper.stripChunksAround(world, centerPos, generator::isOreBlock);
                    this.sendChatMessageTo(sender, "Chunks around " + centerPos + " stripped");
                    return;
                }
            }
        }
        if (Tasks.DRESS.complyWith(taskName, args)) {
            centerPos = new ChunkPos(sender.func_180425_c());
            Stripper stripper = Stripper.getFor(world);
            switch (args[0]) {
                case "chunk": {
                    stripper.dressChunk(world, centerPos);
                    this.sendChatMessageTo(sender, "Chunk at " + centerPos + " dressed");
                    return;
                }
                case "around": {
                    stripper.dressChunksAround(world, centerPos);
                    this.sendChatMessageTo(sender, "Chunks around " + centerPos + " dressed");
                    return;
                }
                case "all": {
                    stripper.dressAllChunks(world);
                    this.sendChatMessageTo(sender, "All stripped chunks dressed");
                    return;
                }
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    public int func_82362_a() {
        return 3;
    }

    public static enum Tasks implements ICommandTask
    {
        LIST("deposits | generated"),
        ADD("deposit", "rarity", "minSize-maxSize", "minAltitude-maxAltitude"),
        REMOVE("deposit"),
        GEN("deposit"),
        TEST("deposit", "amount"),
        RELOAD(new String[0]),
        STRIP("chunk | around"),
        DRESS("chunk | around | all");

        private final String[] usageArgs;

        private Tasks(String ... usageArgs) {
            this.usageArgs = usageArgs;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String[] getUsageArgs() {
            return this.usageArgs;
        }
    }
}

