/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonPath;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.StateHashSet;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adlods.Main;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.ore.Ore;
import com.endertech.minecraft.mods.adlods.ore.Vein;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Deposit
implements IHaveConfig {
    protected final UnitConfig config;
    protected final boolean enabled;
    protected final String name;
    protected final Altitude altitude;
    protected final Size size;
    protected final CommonCollect.BlackWhiteList<Biome> biomes;
    protected final CommonCollect.BlackWhiteList<Integer> dimensions;
    protected final Set<BlockState> replaceableBlocks;
    protected final CommonCollect.WeightedList<Ore> ores;
    protected final int rarity;
    protected final Percentage chance;
    protected final Patterns pattern = Patterns.DEFAULT;
    protected final Indicator indicator;

    public Deposit(UnitConfig config, Size size, Altitude altitude, int rarity, String[] ores, String[] replaceableBlocks) {
        this(config != null ? CommonPath.getFileNameOnly((Path)config.getConfigFile().toPath()) : "null", config, size, altitude, rarity, ores, replaceableBlocks);
    }

    public Deposit(String name, UnitConfig config, Size size, Altitude altitude, int rarity, String[] ores, String[] replaceableBlocks) {
        String category = this.getClassCategory();
        this.config = config;
        this.name = name;
        this.altitude = Altitude.from(ForgeConfig.getIntBounds((ForgeConfig)config, (String)category, (String)"Altitude", (IntBounds)altitude, (IntBounds)ForgeBounds.HEIGHT.getIntBounds(), (String)"Defines the altitude limits which this deposit can be generated at."));
        this.enabled = ForgeConfig.readConfigEnabled((ForgeConfig)config, (boolean)true);
        this.size = Size.from(ForgeConfig.getIntBounds((ForgeConfig)config, (String)category, (String)"Size", (IntBounds)size, (IntBounds)IntBounds.from((Integer)1, (Integer)8000), (String)"Defines the size limits (in blocks) of this deposit."));
        this.dimensions = Dimensions.from((ForgeConfig)config, (String)category, (String)"Defines the dimensions which this deposit can be generated in.");
        this.biomes = Biomes.from((ForgeConfig)config, (String)category, (String)"Defines the biomes which this deposit can be generated in.");
        this.rarity = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"rarity", (int)rarity, (IntBounds)IntBounds.from((Integer)1, (Integer)256000), (String)"Defines the rarity (in chunks) of this deposit.\nHigher values give more rare deposit spawning.\nExample: value of 1000, means that 1 deposit can be spawned per 1000 chunks,\n that gives us 1 / 1000 * 100% = 0.1% chance of spawing per chunk.");
        this.chance = Percentage.from((int)1, (int)this.rarity);
        this.indicator = new Indicator(config, category);
        replaceableBlocks = ForgeConfig.getStrArray((ForgeConfig)config, (String)category, (String)"replaceableBlocks", (String[])replaceableBlocks, (String)"Defines the blocks that can be replaced with ore.");
        this.replaceableBlocks = StateHashSet.parseBlockStatesFrom((String[])replaceableBlocks);
        ores = ForgeConfig.getStrArray((ForgeConfig)config, (String)category, (String)"ores", (String[])ores, (String)"Defines the ores and their weights for this deposit.\nSyntax: oreId [, weight]\nFor example, the definition:\n     minecraft:gold_ore, 1\n     minecraft:iron_ore, 5\n means that gold and iron will be in the proportion 1 to 5.");
        this.ores = Deposit.parseOresFrom(ores);
        this.saveConfig();
    }

    public static CommonCollect.WeightedList<Ore> parseOresFrom(String[] array) {
        CommonCollect.WeightedList ores = new CommonCollect.WeightedList();
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split(",");
            UnitId id = UnitId.from((String)split[0].trim());
            int proportion = 1;
            boolean error = id.isEmpty();
            if (split.length > 1) {
                try {
                    proportion = Integer.parseInt(split[1].trim());
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                Ore ore = new Ore(id, proportion);
                if (!ore.exists()) continue;
                ores.add((CommonCollect.IWeighted)ore);
                continue;
            }
            ForgeMain.instance.getLogger().error("Unable to parse ore from " + CommonString.quoted((String)str));
        }
        return ores;
    }

    public boolean canBeReplaced(World world, BlockPos pos, boolean testing) {
        if (testing && ForgeWorld.isAirBlock((World)world, (BlockPos)pos)) {
            return true;
        }
        BlockState replaceable = ForgeWorld.getBlockState((World)world, (BlockPos)pos);
        return this.replaceableBlocks.contains(replaceable);
    }

    public boolean isValidPosition(World world, BlockPos pos, BlockPos startPos, boolean testing) {
        if (!ForgeBounds.HEIGHT.getIntBounds().encloses(Integer.valueOf(pos.func_177956_o()))) {
            return false;
        }
        if (testing ? Math.abs(pos.func_177956_o() - startPos.func_177956_o()) > this.altitude.length() / 2 : !this.altitude.encloses(pos.func_177956_o())) {
            return false;
        }
        if (this.canCauseCascadingWorldGen(world, pos)) {
            return false;
        }
        return testing || this.inAllowableBiome(world, pos);
    }

    protected boolean canCauseCascadingWorldGen(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkBounds bounds = ChunkBounds.from((ChunkPos)chunkPos);
        BlockPos relative = bounds.relative(pos);
        int dx = relative.func_177958_n() >= 8 ? 1 : -1;
        int dz = relative.func_177952_p() >= 8 ? 1 : -1;
        return !world.func_190526_b(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
    }

    public DepositGenResult generateAt(World world, ChunkPos chunkPos) {
        ChunkBounds chunkBounds = ChunkBounds.from((ChunkPos)chunkPos);
        BlockPos startPos = new BlockPos(chunkBounds.getX().randomBetween().intValue(), this.altitude.randomBetween().intValue(), chunkBounds.getZ().randomBetween().intValue());
        startPos = startPos.func_177982_a(8, 0, 8);
        int amount = this.size.randomBetween();
        DepositGenResult result = this.generateAt(world, startPos, amount, false);
        if (result.size >= this.size.min) {
            this.indicator.placeFor(world, result);
        }
        return result;
    }

    public DepositGenResult generateAt(World world, BlockPos startPos, int amount, boolean testing) {
        DepositGenResult result;
        if (!testing && !this.inAllowableDimenstion(world)) {
            Main.instance.getLogger().info("Not in allowable dimension for " + this.getName() + " deposit");
            return new DepositGenResult(this.getName(), startPos, 0);
        }
        switch (this.pattern) {
            case VANILLA: {
                result = this.generateVanilla(world, startPos, amount, testing);
                break;
            }
            default: {
                result = this.generateDefault(world, startPos, amount, testing);
            }
        }
        WorldData.getData(world).addDepositGenResult(result);
        Main.instance.getLogger().debug((Object)result);
        ForgeMain.debugMsg((String)result.toString());
        return result;
    }

    protected DepositGenResult generateDefault(World world, BlockPos startPos, int amount, final boolean testing) {
        int count = new Vein(world, startPos, amount){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return Deposit.this.replaceWithOre(this.world, pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                return Deposit.this.isValidPosition(this.world, pos, this.startPos, testing) && Deposit.this.isOreBlock(this.world, pos);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return Deposit.this.isValidPosition(this.world, pos, this.startPos, testing) && Deposit.this.canBeReplaced(this.world, pos, testing);
            }
        }.generate().getCount();
        return new DepositGenResult(this.getName(), startPos, count);
    }

    protected DepositGenResult generateVanilla(World world, BlockPos startPos, int amount, boolean testing) {
        int count = 0;
        float f = CommonMath.Random.getFloat() * (float)Math.PI;
        double minX = (float)(startPos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)amount / 8.0f;
        double maxX = (float)(startPos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)amount / 8.0f;
        double minZ = (float)(startPos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)amount / 8.0f;
        double maxZ = (float)(startPos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)amount / 8.0f;
        double minY = startPos.func_177956_o() + CommonMath.Random.between((int)-2, (int)2);
        double maxY = startPos.func_177956_o() + CommonMath.Random.between((int)-2, (int)2);
        block0: for (int i = 0; i < amount; ++i) {
            float progress = (float)i / (float)amount;
            double centerX = minX + (maxX - minX) * (double)progress;
            double centerY = minY + (maxY - minY) * (double)progress;
            double centerZ = minZ + (maxZ - minZ) * (double)progress;
            double d9 = CommonMath.Random.getDouble() * (double)amount / 16.0;
            double offsetXZ = (double)(MathHelper.func_76126_a((float)((float)Math.PI * progress)) + 1.0f) * d9 + 1.0;
            double offsetY = (double)(MathHelper.func_76126_a((float)((float)Math.PI * progress)) + 1.0f) * d9 + 1.0;
            int startX = MathHelper.func_76128_c((double)(centerX - offsetXZ / 2.0));
            int endX = MathHelper.func_76128_c((double)(centerX + offsetXZ / 2.0));
            int startY = MathHelper.func_76128_c((double)(centerY - offsetY / 2.0));
            int endY = MathHelper.func_76128_c((double)(centerY + offsetY / 2.0));
            int startZ = MathHelper.func_76128_c((double)(centerZ - offsetXZ / 2.0));
            int endZ = MathHelper.func_76128_c((double)(centerZ + offsetXZ / 2.0));
            for (int x = startX; x <= endX; ++x) {
                double normX = ((double)x + 0.5 - centerX) / (offsetXZ / 2.0);
                if (!(normX * normX < 1.0)) continue;
                for (int y = startY; y <= endY; ++y) {
                    double normY = ((double)y + 0.5 - centerY) / (offsetY / 2.0);
                    if (!(normX * normX + normY * normY < 1.0)) continue;
                    for (int z = startZ; z <= endZ; ++z) {
                        BlockPos pos;
                        double normZ = ((double)z + 0.5 - centerZ) / (offsetXZ / 2.0);
                        if (count >= amount) continue block0;
                        if (!(normX * normX + normY * normY + normZ * normZ < 1.0) || !this.isValidPosition(world, pos = new BlockPos(x, y, z), startPos, testing) || !this.canBeReplaced(world, pos, testing) || !this.replaceWithOre(world, pos)) continue;
                        ++count;
                    }
                }
            }
        }
        return new DepositGenResult(this.getName(), startPos, count);
    }

    protected boolean replaceWithOre(World world, BlockPos pos) {
        Ore ore = (Ore)this.ores.getRandom();
        if (ore != null) {
            IBlockState state = ore.getId().getIBlockState();
            return state != null && world.func_180501_a(pos, state, 18);
        }
        return false;
    }

    public boolean isOreBlock(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        for (Ore ore : this.ores.getElements()) {
            IBlockState oreState = ore.getId().getIBlockState();
            if (oreState != blockState) continue;
            return true;
        }
        return ForgeWorld.isOreBlock((World)world, (BlockPos)pos);
    }

    public boolean inAllowableDimenstion(World world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)world.field_73011_w.getDimension());
    }

    public boolean inAllowableBiome(World world, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)world.func_180494_b(pos));
    }

    public boolean isValid() {
        return this.enabled && !this.ores.isEmpty() && !this.replaceableBlocks.isEmpty() && CommonMath.notZero((double)this.getChance().getValue()) && this.size.min > 0;
    }

    public Percentage getChance() {
        return this.chance;
    }

    public ForgeConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    protected static IntBounds parseBoundsFrom(String string) {
        String[] split = string.split("-");
        try {
            int bound1 = Integer.parseInt(split[0].trim());
            int bound2 = Integer.parseInt(split[1].trim());
            return IntBounds.from((Integer)bound1, (Integer)bound2);
        }
        catch (Exception e) {
            throw new NumberFormatException(CommonString.doubleQuoted((String)string) + ". Valid format is: <minValue>-<maxValue>");
        }
    }

    public static class Rarity
    extends IntBounds {
        public Rarity(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Size
    extends IntBounds {
        public static final Size ZERO = new Size(0, 0);

        public static Size from(String string) {
            return Size.from(Deposit.parseBoundsFrom(string));
        }

        public static Size from(IntBounds bounds) {
            return new Size(bounds.getMin(), bounds.getMax());
        }

        public Size(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Altitude
    extends IntBounds {
        public static final Altitude ZERO = new Altitude(0, 0);

        public static Altitude from(String string) {
            return Altitude.from(Deposit.parseBoundsFrom(string));
        }

        public static Altitude from(IntBounds bounds) {
            return new Altitude(bounds.getMin(), bounds.getMax());
        }

        public Altitude(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static enum Patterns {
        DEFAULT,
        VANILLA;

    }
}

