/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.DepositSample;
import com.endertech.minecraft.mods.adlods.ore.Ore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class Generator
implements IWorldGenerator {
    protected final Path configsDir;
    protected final List<Deposit> deposits = new ArrayList<Deposit>();
    protected final Set<IBlockState> oreBlocks = new HashSet<IBlockState>();

    public Generator(Path configsDir) {
        this.configsDir = configsDir;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        DepositGenResult result;
        Deposit deposit2;
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        List passed = this.deposits.stream().filter(deposit -> deposit.inAllowableDimenstion(world) && deposit.getChance().takeChance()).collect(Collectors.toList());
        int maxAttempts = 8;
        for (int attempt = 0; attempt < maxAttempts && (deposit2 = (Deposit)CommonCollect.getRandomElementFrom(passed)) != null && (result = deposit2.generateAt(world, pos)).isEmpty(); ++attempt) {
        }
    }

    protected void createDefaultDeposits(Path dir) {
        this.createDeposit(dir, "coal", new Deposit.Size(900, 1800), new Deposit.Altitude(32, 80), 800);
        DepositSample sample = new DepositSample(new Deposit.Size(700, 1400), new Deposit.Altitude(16, 64), new Deposit.Rarity(1000, 3000));
        this.createDeposit(dir, "iron", sample, 1.0f);
        this.createDeposit(dir, "aluminum", sample, 6.6f);
        this.createDeposit(dir, "lead", sample, 7.0f);
        this.createDeposit(dir, "zinc", sample, 10.3f);
        this.createDeposit(dir, "copper", sample, 22.6f);
        this.createDeposit(dir, "nickel", sample, 44.6f);
        this.createDeposit(dir, "tin", sample, 74.8f);
        this.createDeposit(dir, "cobalt", sample, 104.7f);
        sample = new DepositSample(new Deposit.Size(500, 1000), new Deposit.Altitude(8, 32), new Deposit.Rarity(1200, 3600));
        this.createDeposit(dir, "silver", sample, 1.0f);
        this.createDeposit(dir, "ruthenium", sample, 17.45f);
        this.createDeposit(dir, "platinum", sample, 58.89f);
        this.createDeposit(dir, "gold", sample, 85.67f);
        this.createDeposit(dir, "palladium", sample, 90.97f);
        this.createDeposit(dir, "iridium", sample, 97.8f);
        this.createDeposit(dir, "uranium", sample, 100.0f);
        this.createDeposit(dir, "rodium", sample, 211.94f);
        sample = new DepositSample(new Deposit.Size(300, 600), new Deposit.Altitude(4, 16), new Deposit.Rarity(1400, 4200));
        this.createDeposit(dir, "redstone", sample, 60.0f);
        this.createDeposit(dir, "lapis", sample, 80.0f);
        this.createDeposit(dir, "diamond", sample, 100.0f);
        this.createDeposit(dir, "amethyst", sample, 70.0f);
        this.createDeposit(dir, "sapphire", sample, 80.0f);
        this.createDeposit(dir, "ruby", sample, 90.0f);
        this.createDeposit(dir, "topaz", sample, 100.0f);
        this.createDeposit(dir, "emerald", sample, 110.0f);
    }

    public Deposit createDeposit(Path dir, String name, DepositSample sample, float priceFactor) {
        float factor = new Percentage(priceFactor).toFraction();
        int rarity = sample.getRarity(factor);
        return this.createDeposit(dir, name, sample.size, sample.altitude, rarity);
    }

    public Deposit createDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity) {
        return new Deposit(new UnitConfig(dir, name), size, altitude, rarity, new String[]{UnitId.buildDictName((String[])new String[]{"ore", name})}, new String[]{Dimensions.overworld.replaceableBlockId.toString()});
    }

    protected void parseDepositsFrom(Path dir) {
        this.deposits.clear();
        String[] array = new String[]{};
        for (Path path : UnitConfig.listCustomConfigs((Path)dir, null)) {
            Deposit deposit = new Deposit(new UnitConfig(path.toFile()), Deposit.Size.ZERO, Deposit.Altitude.ZERO, 0, array, array);
            this.addDeposit(deposit);
        }
    }

    public Path getConfigsDir() {
        return this.configsDir;
    }

    public List<Deposit> getDeposits() {
        return Collections.unmodifiableList(this.deposits);
    }

    public void loadDeposits() {
        this.createDefaultDeposits(this.configsDir);
        this.parseDepositsFrom(this.configsDir);
        this.mapOreBlocks();
    }

    protected void mapOreBlocks() {
        this.oreBlocks.clear();
        for (Deposit deposit : this.deposits) {
            for (Ore ore : deposit.ores.getElements()) {
                IBlockState state = ore.getId().getIBlockState();
                if (state == null) continue;
                this.oreBlocks.add(state);
            }
        }
    }

    public boolean isOreBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (ForgeWorld.isAirBlock((IBlockState)state)) {
            return false;
        }
        return this.oreBlocks.contains(state) || ForgeWorld.isOreBlock((World)world, (BlockPos)pos);
    }

    public boolean addDeposit(Deposit deposit) {
        if (!deposit.isValid()) {
            return false;
        }
        if (this.findDepositBy(deposit.getName()) != null) {
            return false;
        }
        return this.deposits.add(deposit);
    }

    public boolean removeDeposit(Deposit deposit) {
        return this.deposits.remove(deposit);
    }

    @Nullable
    public Deposit findDepositBy(String name) {
        for (Deposit deposit : this.deposits) {
            if (!deposit.getName().equals(name)) continue;
            return deposit;
        }
        return null;
    }
}

