/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class Indicator
implements IHaveConfig {
    public static int searchRadius = 4;
    protected final UnitConfig config;
    protected final UnitId id;

    public Indicator(UnitConfig config, String headCategory) {
        this.config = config;
        String category = this.expandClassCategory(headCategory);
        if (config != null) {
            config.setCategoryComment(category, "Defines the above-ground indicator for this deposit (e.g., a rare flower)");
        }
        this.id = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"id", (UnitId)UnitId.EMPTY, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper \n");
    }

    public UnitId getId() {
        return this.id;
    }

    public boolean placeFor(IWorld world, DepositGenResult result) {
        if (result.size < 1) {
            return false;
        }
        if (this.getId().isEmpty()) {
            return false;
        }
        BlockState state = this.getId().getFirstMatchedState();
        if (state == null) {
            return false;
        }
        BlockPos pos = this.findPosition(world, result.pos, searchRadius);
        if (pos == null) {
            return false;
        }
        return world.func_180501_a(pos, state, 2);
    }

    @Nullable
    protected BlockPos findPosition(IWorld world, BlockPos centerPos, int radius) {
        BlockState indicatorState = this.getId().getFirstMatchedState();
        if (indicatorState == null) {
            return null;
        }
        for (int r = 0; r <= radius; ++r) {
            block1: for (BlockPos startPos : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (int)r, (boolean)true)) {
                if (!world.func_175667_e(startPos)) continue;
                int topY = GameBounds.HEIGHT.getIntBounds().getMax();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos);
                for (int y = topY; y > 0; --y) {
                    pos.func_185336_p(y);
                    if (world.func_175623_d((BlockPos)pos)) continue;
                    BlockState state = world.func_180495_p((BlockPos)pos);
                    Block block = state.func_177230_c();
                    Material material = state.func_185904_a();
                    if (!material.func_76230_c() || material.func_76224_d() || block.func_203417_a(BlockTags.field_206952_E) || state.isFoliage((IWorldReader)world, (BlockPos)pos) || block instanceof HugeMushroomBlock) continue;
                    BlockPos placePos = pos.func_177984_a();
                    if (!indicatorState.func_196955_c((IWorldReader)world, placePos)) continue block1;
                    return placePos;
                }
            }
        }
        return null;
    }

    public UnitConfig getConfig() {
        return this.config;
    }
}

