/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraftforge.registries.ForgeRegistries;

public final class VanillaGen {
    static final Map<Biome, List<ConfiguredFeature<?>>> DISABLED_FEATURES = new HashMap();
    private final ForgeMod mod;
    private VanillaOres ores;

    public VanillaGen(ForgeMod mod) {
        this.mod = mod;
    }

    public void loadOres() {
        this.ores = new VanillaOres(this.mod);
        this.ores.onPostInit();
        this.updateFeatures();
    }

    protected void updateFeatures() {
        GenerationStage.Decoration stage = GenerationStage.Decoration.UNDERGROUND_ORES;
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            List disabledFeatures = DISABLED_FEATURES.computeIfAbsent(biome, key -> new ArrayList());
            disabledFeatures.removeIf(feature -> {
                if (!this.shouldBeDisabledIn(biome, (ConfiguredFeature<?>)feature)) {
                    biome.func_203611_a(stage, feature);
                    return true;
                }
                return false;
            });
            biome.func_203607_a(stage).removeIf(feature -> {
                if (this.shouldBeDisabledIn(biome, (ConfiguredFeature<?>)feature)) {
                    disabledFeatures.add(feature);
                    return true;
                }
                return false;
            });
        }
    }

    protected boolean shouldBeDisabledIn(Biome biome, ConfiguredFeature<?> feature) {
        Feature oreFeature;
        if (feature.field_222738_b instanceof DecoratedFeatureConfig && ((oreFeature = ((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222737_a) == Feature.field_202290_aj || oreFeature == Feature.field_202294_an)) {
            IFeatureConfig featureConfig = ((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222738_b;
            BlockState blockState = null;
            if (featureConfig instanceof ReplaceBlockConfig) {
                blockState = ((ReplaceBlockConfig)featureConfig).field_202458_b;
            }
            if (featureConfig instanceof OreFeatureConfig) {
                blockState = ((OreFeatureConfig)featureConfig).field_202444_d;
            }
            if (blockState != null) {
                VanillaOre ore = (VanillaOre)this.ores.findBy(blockState);
                return ore != null && (!ore.isEnabled() || !ore.inAllowedBiome(biome));
            }
        }
        return false;
    }

    static class VanillaOres
    extends RelatedUnitsInit<VanillaOre, BuiltIn> {
        public VanillaOres(ForgeMod mod) {
            super(mod, BuiltIn.class);
        }

        public VanillaOre createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
            return new VanillaOre(config, UnitId.from((Enum)e, (String)""));
        }

        public VanillaOre createCustomUnitFrom(UnitConfig config, String name) {
            return new VanillaOre(config, UnitId.from((String)config.getConfigFile().getPath()));
        }

        static enum BuiltIn implements IForgeEnum
        {
            DIRT,
            GRAVEL,
            GRANITE,
            DIORITE,
            ANDESITE,
            COAL_ORE,
            IRON_ORE,
            GOLD_ORE,
            REDSTONE_ORE,
            DIAMOND_ORE,
            EMERALD_ORE,
            LAPIS_ORE,
            NETHER_QUARTZ_ORE,
            MAGMA_BLOCK,
            INFESTED_STONE;

        }
    }
}

