/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;

@OnlyIn(value=Dist.CLIENT)
public class ItemModel {
    public static final String INVENTORY = "inventory";

    public static ModelResourceLocation getInventoryLoc(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), INVENTORY);
    }

    public static class RegistryWrapper {
        protected final Map<ResourceLocation, IBakedModel> registry;

        public RegistryWrapper(Map<ResourceLocation, IBakedModel> registry) {
            this.registry = registry;
        }

        @Nullable
        public IBakedModel getModelOf(Item item) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.get(loc);
        }

        public boolean replaceModelOf(Item item, IBakedModel newModel) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.put((ResourceLocation)loc, newModel) != null;
        }
    }

    public static class Combined
    implements IBakedModel {
        protected final IBakedModel baseModel;
        protected final IBakedModel[] additionalModels;

        public Combined(IBakedModel baseModel, IBakedModel ... additionalModels) {
            this.baseModel = baseModel;
            this.additionalModels = additionalModels;
        }

        public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
            ImmutableList.Builder quads = ImmutableList.builder();
            quads.addAll((Iterable)this.baseModel.func_200117_a(state, side, rand));
            for (IBakedModel additional : this.additionalModels) {
                quads.addAll((Iterable)additional.func_200117_a(state, side, rand));
            }
            return quads.build();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean func_177555_b() {
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.baseModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.baseModel.func_177552_f();
        }
    }

    public static abstract class Replacer<T extends IBakedModel>
    extends BakedModelWrapper<T> {
        protected final ItemOverrideList overrides = new ItemOverrideList(){

            public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, World world, LivingEntity entity) {
                return this.chooseModelFor(stack, world, entity);
            }
        };

        public Replacer(T originalModel) {
            super(originalModel);
        }

        public abstract IBakedModel chooseModelFor(ItemStack var1, @Nullable World var2, @Nullable LivingEntity var3);

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

