/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.UnitId;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class JsonGen {
    protected static JsonWriter createWriter(File file) throws IOException {
        JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(file)));
        writer.setIndent("\t");
        writer.setLenient(false);
        return writer;
    }

    public static void blockState(ResourceLocation regName) throws IOException {
        GamePath path = GamePath.blockState(regName, new String[0]);
        System.out.println(path.absolute.toString());
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("variants").beginObject();
        writer.name("").beginObject();
        writer.name("model").value(GamePath.blockModel((ResourceLocation)regName, (String[])new String[0]).shortcut.toString());
        writer.endObject().endObject().endObject();
        writer.close();
    }

    public static void blockModel(ResourceLocation regName, ResourceLocation parent, ResourceLocation texture) throws IOException {
        GamePath path = GamePath.blockModel(regName, new String[0]);
        System.out.println(path.absolute.toString());
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("parent").value(parent.toString());
        writer.name("textures").beginObject();
        writer.name("0").value(texture.toString());
        writer.name("particle").value(texture.toString());
        writer.endObject().endObject();
        writer.close();
    }

    public static void itemModel(ResourceLocation regName) throws IOException {
        GamePath path = GamePath.itemModel(regName, new String[0]);
        System.out.println(path.absolute.toString());
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("parent").value(GamePath.blockModel((ResourceLocation)regName, (String[])new String[0]).shortcut.toString());
        writer.endObject();
        writer.close();
    }

    public static LangFile<?> langFile(String modId, Locale locale) {
        GamePath path = GamePath.langFile(modId, locale);
        System.out.println(path.absolute.toString());
        return new LangFile<LangFile>(LangFile.class, path.absolute.toFile());
    }

    public static RecipeFile<?> recipeFile(ResourceLocation regName) {
        GamePath path = GamePath.recipe(regName, new String[0]);
        System.out.println(path.absolute.toString());
        return new RecipeFile<RecipeFile>(RecipeFile.class, path.absolute.toFile());
    }

    public static class RecipeFile<T extends RecipeFile<T>>
    extends BaseJsonFile<T> {
        protected String type = "minecraft:crafting_shaped";
        protected String[] pattern;
        protected List<KeyValuePair> items = new ArrayList<KeyValuePair>();
        protected KeyValuePair result;

        protected RecipeFile(Class<T> thisClass, File file) {
            super(thisClass, file);
        }

        public T type(String type) {
            this.type = type;
            return (T)((RecipeFile)this.self);
        }

        public T pattern(String ... rows) throws IOException {
            this.pattern = rows;
            return (T)((RecipeFile)this.self);
        }

        public T addItem(String key, ResourceLocation item) {
            this.items.add(new KeyValuePair(key, item.toString()));
            return (T)((RecipeFile)this.self);
        }

        public T result(ResourceLocation item, int count) {
            this.result = new KeyValuePair(item.toString(), String.valueOf(count));
            return (T)((RecipeFile)this.self);
        }

        @Override
        public void end() throws IOException {
            this.writer.name("type").value(this.type);
            this.writer.name("pattern");
            this.writer.beginArray();
            for (String row : this.pattern) {
                this.writer.value(row);
            }
            this.writer.endArray();
            this.writer.name("key").beginObject();
            for (KeyValuePair entry : this.items) {
                this.writer.name(entry.key).beginObject().name("item").value(entry.value).endObject();
            }
            this.writer.endObject();
            this.writer.name("result").beginObject();
            this.writer.name("item").value(this.result.key);
            this.writer.name("count").value((long)Integer.parseInt(this.result.value));
            this.writer.endObject();
            super.end();
        }
    }

    public static class LangFile<T extends LangFile<T>>
    extends BaseJsonFile<T> {
        protected LangFile(Class<T> thisClass, File file) {
            super(thisClass, file);
        }

        public T addItemGroup(String name, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("itemGroup", name)).value(localizedName);
            return (T)((LangFile)this.self);
        }

        public T addBlock(ResourceLocation regName) throws IOException {
            String localizedName = Names.localized().join(UnitId.splitRegName(regName.func_110623_a(), true, false));
            return this.addBlock(regName, localizedName);
        }

        public T addBlock(ResourceLocation regName, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("block", regName.func_110624_b(), regName.func_110623_a())).value(localizedName);
            return (T)((LangFile)this.self);
        }

        public T addItem(ResourceLocation regName, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("item", regName.func_110624_b(), regName.func_110623_a())).value(localizedName);
            return (T)((LangFile)this.self);
        }
    }

    public static abstract class BaseJsonFile<T extends BaseJsonFile<T>> {
        protected final T self;
        protected final File file;
        protected JsonWriter writer;

        protected BaseJsonFile(Class<T> thisClass, File file) {
            this.self = (BaseJsonFile)thisClass.cast(this);
            this.file = file;
        }

        public T begin() throws Exception {
            if (this.writer != null) {
                throw new Exception("Writer for " + this.file.toString() + " already created!");
            }
            this.writer = JsonGen.createWriter(this.file).beginObject();
            return this.self;
        }

        public void end() throws IOException {
            this.writer.endObject().close();
        }
    }
}

