/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChestWearItem
extends EquipmentItem {
    public ChestWearItem(ForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, UnitId repairItem, SoundEvent equipSound) {
        super(mod, config, name, props, durability, repairItem, EquipmentSlotType.CHEST, equipSound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInitClient() {
        for (Map.Entry e : Minecraft.func_71410_x().func_175598_ae().getSkinMap().entrySet()) {
            PlayerRenderer renderer = (PlayerRenderer)e.getValue();
            LayerChestWear layer = new LayerChestWear((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer);
            renderer.func_177094_a((LayerRenderer)layer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayerChestWear
    extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
        protected final RendererModel model;

        public LayerChestWear(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
            super(renderer);
            this.model = ((PlayerModel)renderer.func_217764_d()).field_178730_v;
        }

        public void render(AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (stack.func_77973_b() instanceof ChestWearItem) {
                GlStateManager.pushMatrix();
                if (player.func_70093_af()) {
                    GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
                }
                if (player.func_70631_g_()) {
                    GlStateManager.translatef((float)0.0f, (float)(0.5f * scale), (float)0.0f);
                    GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
                    GlStateManager.translatef((float)0.0f, (float)(16.0f * scale), (float)0.0f);
                }
                this.model.func_78794_c(0.0625f);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.scalef((float)0.625f, (float)-0.625f, (float)-0.625f);
                minecraft.func_175599_af().func_184392_a(stack, (LivingEntity)player, ItemCameraTransforms.TransformType.HEAD, false);
                GlStateManager.popMatrix();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

