/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class GlassMeter
extends EquipmentItem {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final TextFormatting textFormatting;

    public GlassMeter(ForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, EquipmentSlotType equipSlot, TextFormatting textFormating) {
        super(mod, config, name, props, durability, UnitId.from("#forge:glass_panes"), equipSlot, SoundEvents.field_187565_bO);
        this.textFormatting = textFormating;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        Item item = stack.func_77973_b();
        if (item instanceof GlassMeter) {
            ((GlassMeter)item).onHit(stack, player);
        }
    }

    protected void onHit(ItemStack stack, PlayerEntity player) {
        if (GlassMeter.notBroken(stack)) {
            GlassMeter.damageItem(1, stack, false, player, damager -> player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_211708_a(this.getTextFormatting());
    }
}

