/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MotionController {
    protected static Map<Entity, Vect3d> motionsMap = new ConcurrentHashMap<Entity, Vect3d>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<Entity, Vect3d> entry : motionsMap.entrySet()) {
                Entity entity = entry.getKey();
                Vect3d motion = entry.getValue();
                ForgeEntity.addMotion(entity, motion);
                if (!(entity instanceof ServerPlayerEntity)) continue;
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                MotionController.sendMotionToPlayer(player, MotionMsg.Type.ADD, motion);
            }
            motionsMap.clear();
        }
    }

    public static void addMotionFor(Entity entity, Vect3d motion) {
        Vect3d mapedMotion = motionsMap.getOrDefault(entity, Vect3d.ZERO);
        Vect3d newMotion = mapedMotion.add(motion);
        motionsMap.put(entity, newMotion);
    }

    public static void setMotionFor(Entity entity, Vect3d motion) {
        ForgeEntity.setMotion(entity, motion);
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            MotionController.sendMotionToPlayer(player, MotionMsg.Type.SET, motion);
        }
        motionsMap.remove(entity);
    }

    protected static void sendMotionToPlayer(ServerPlayerEntity player, MotionMsg.Type type, Vect3d motion) {
        MotionMsg message = MotionMsg.addMotion(player, motion);
        ForgeEndertech.getInstance().getConnection().sendToPlayer(message, player);
    }

    public static class MotionMsg
    extends ForgeNetMsg<MotionMsg> {
        public int id = -1;
        public Type type = Type.ADD;
        public Vect3d motion = Vect3d.ZERO;

        public MotionMsg() {
        }

        public MotionMsg(ServerPlayerEntity player, Type type, Vect3d motion) {
            this.id = ForgeEntity.getId((Entity)player);
            this.type = type;
            this.motion = motion;
        }

        public static MotionMsg setMotion(ServerPlayerEntity player, Vect3d motion) {
            return new MotionMsg(player, Type.SET, motion);
        }

        public static MotionMsg addMotion(ServerPlayerEntity player, Vect3d motion) {
            return new MotionMsg(player, Type.ADD, motion);
        }

        @Override
        public MotionMsg create() {
            return new MotionMsg();
        }

        @Override
        public void handle(World world, PlayerEntity player) {
            switch (this.type) {
                case ADD: {
                    ForgeEntity.addMotion((Entity)player, this.motion);
                    break;
                }
                case SET: {
                    ForgeEntity.setMotion((Entity)player, this.motion);
                    break;
                }
            }
        }

        public static enum Type {
            ADD,
            SET;

        }
    }
}

