function initializeCoreMod() {
    Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/client/renderer/ItemRenderer',
		'methodName' : resolveName('func_180454_a'), // renderItem
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/IBakedModel;)V'
	}
	
	var handler = {
		'class': 'com/endertech/minecraft/forge/events/ItemRenderEvent',
		'methodName': 'createAndPost',
		'methodDesc': '(Lnet/minecraft/item/ItemStack;)V'
	}

	var node = {
		'class': target.class,
		'methodName': resolveName('func_191961_a'), // "renderModel"
		'methodDesc': "(Lnet/minecraft/client/renderer/model/IBakedModel;Lnet/minecraft/item/ItemStack;)V"
	}
	
    var instructions = [
		insnLoadObj(1, "stack"), 
		insnCallHandler(handler)
	];
    
	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions);
				return method;
			}
		}
	}
}