/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.ChunkLoc;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class Connection {
    protected static final String PROTOCOL_VERSION = Integer.toString(1);
    protected final SimpleChannel channel;
    protected int index = 0;

    public Connection(String modId) {
        ResourceLocation name = new ResourceLocation(modId, "main");
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }

    public <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(MSG msg) {
        Class<?> msgType = msg.getClass();
        this.channel.registerMessage(this.index++, msgType, msg::encode, msg::decode, msg::handle);
    }

    public <MSG> void sendToPlayer(MSG message, ServerPlayerEntity player) {
        if (player instanceof FakePlayer) {
            return;
        }
        this.channel.sendTo(message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG> void sendToRemotePlayer(MSG message, ServerPlayerEntity player) {
        if (player.func_184102_h().func_71262_S() || !player.func_146103_bH().getName().equals(player.func_184102_h().func_71214_G())) {
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToServer(MSG message) {
        this.channel.sendToServer(message);
    }

    public <MSG> void sendToAll(MSG message) {
        this.getServerPlayers().forEach(player -> this.sendToRemotePlayer(message, (ServerPlayerEntity)player));
    }

    public <MSG> void sendToAllInDimension(MSG message, DimensionType dimension) {
        for (ServerPlayerEntity player : this.getServerPlayers()) {
            if (player.func_130014_f_().func_230315_m_() != dimension) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllAround(MSG message, IWorldReader world, BlockPos pos, int radius) {
        for (ServerPlayerEntity player : this.getServerPlayers()) {
            double distSq;
            if (player.func_130014_f_().func_230315_m_() != world.func_230315_m_() || !((distSq = pos.func_177951_i((Vector3i)player.func_233580_cy_())) <= (double)(radius * radius))) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllObservingChunk(MSG message, Chunk chunk) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), message);
    }

    public <MSG> void sendToAllAround(MSG message, PacketDistributor.TargetPoint point) {
        this.channel.send(PacketDistributor.NEAR.with(() -> point), message);
    }

    public <MSG> void sendToAllInChunk(MSG message, ChunkLoc location) {
        for (ServerPlayerEntity player : this.getServerPlayers()) {
            if (!location.contains((Entity)player)) continue;
            this.sendToPlayer(message, player);
        }
    }

    public List<ServerPlayerEntity> getServerPlayers() {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
    }

    public <MSG> IPacket<?> toVanillaPacket(MSG msg, NetworkDirection direction) {
        return this.channel.toVanillaPacket(msg, direction);
    }
}

