/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.DepositSample;
import com.endertech.minecraft.mods.adlods.ore.Flowers;
import com.endertech.minecraft.mods.adlods.ore.Ore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class Generator
extends Feature<NoFeatureConfig> {
    protected final Path configsDir;
    protected final List<Deposit> deposits = new ArrayList<Deposit>();
    protected final Set<BlockState> oreBlocks = new BlockStatesSet();
    protected final ConfiguredFeature<?, ?> configuredFeature = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)this.getRegistryName(), (Object)this.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));

    public Generator(ForgeMod mod) {
        super(NoFeatureConfig.field_236558_a_);
        this.configsDir = mod.getConfigsDir().resolve("Deposits");
        this.setRegistryName(mod.getId(), "generator");
    }

    public void registerOn(MinecraftServer server) {
        MutableRegistry registry = server.func_244267_aX().func_230521_a_(Registry.field_239720_u_).orElse(null);
        if (registry != null) {
            registry.forEach(biome -> Biomes.addFeatures((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature[])new ConfiguredFeature[]{this.configuredFeature}));
        }
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        ChunkPos chunkPos = new ChunkPos(pos);
        List passed = this.deposits.stream().filter(deposit -> deposit.inAllowedDimenstion((IServerWorld)world) && deposit.getChance().takeChance()).collect(Collectors.toList());
        int maxAttempts = 8;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            DepositGenResult result;
            Deposit deposit2 = (Deposit)CommonCollect.getRandomElementFrom(passed);
            if (deposit2 == null || (result = deposit2.generateAt((IServerWorld)world, chunkPos)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void createDefaultDeposits(Path dir) {
        this.createDeposit(dir, "coal", new Deposit.Size(900, 1800), new Deposit.Altitude(32, 80), 800, Flowers.circles(Flowers.GlowRose.BLACK_DIAMOND, Flowers.Mystical.BLACK, Flowers.Vanilla.LARGE_FERN));
        DepositSample sample = new DepositSample(new Deposit.Size(700, 1400), new Deposit.Altitude(16, 64), new Deposit.Rarity(1000, 3000));
        this.createDeposit(dir, "iron", sample, 1.0f, Flowers.circles(Flowers.GlowRose.CITRINE, Flowers.Mystical.BROWN, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "aluminum", sample, 6.6f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "lead", sample, 7.0f, Flowers.circles(Flowers.GlowRose.ONYX, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "zinc", sample, 10.3f, Flowers.circles(Flowers.GlowRose.EUCLAUSE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "copper", sample, 22.6f, Flowers.circles(Flowers.GlowRose.SPINEL, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "nickel", sample, 44.6f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "tin", sample, 74.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "cobalt", sample, 104.7f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER, Flowers.Metal.NORMAL));
        sample = new DepositSample(new Deposit.Size(500, 1000), new Deposit.Altitude(8, 32), new Deposit.Rarity(1200, 3600));
        this.createDeposit(dir, "silver", sample, 1.0f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "ruthenium", sample, 17.45f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "platinum", sample, 58.89f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "gold", sample, 85.67f, Flowers.circles(Flowers.GlowRose.JASPER, Flowers.Mystical.ORANGE, Flowers.Vanilla.DANDELION, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "palladium", sample, 90.97f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "iridium", sample, 97.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "uranium", sample, 100.0f, Flowers.circles(Flowers.GlowRose.MALACHITE, Flowers.Mystical.LIME, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "rhodium", sample, 211.94f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        sample = new DepositSample(new Deposit.Size(300, 600), new Deposit.Altitude(4, 16), new Deposit.Rarity(1400, 4200));
        this.createDeposit(dir, "redstone", sample, 60.0f, Flowers.circles(Flowers.GlowRose.CARNELIAN, Flowers.Mystical.RED, Flowers.Vanilla.POPPY));
        this.createDeposit(dir, "lapis", sample, 80.0f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createDeposit(dir, "diamond", sample, 100.0f, Flowers.circles(Flowers.GlowRose.FLUORITE, Flowers.Mystical.CYAN, Flowers.Vanilla.BLUE_ORCHID));
        this.createDeposit(dir, "amethyst", sample, 70.0f, Flowers.circles(Flowers.GlowRose.AMETHYST, Flowers.Mystical.PURPLE, Flowers.Vanilla.PINK_TULIP));
        this.createDeposit(dir, "sapphire", sample, 80.0f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createDeposit(dir, "ruby", sample, 90.0f, Flowers.circles(Flowers.GlowRose.RUBY, Flowers.Mystical.RED, Flowers.Vanilla.RED_TULIP));
        this.createDeposit(dir, "topaz", sample, 100.0f, Flowers.circles(Flowers.GlowRose.TOPAZ, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP));
        this.createDeposit(dir, "emerald", sample, 110.0f, Flowers.circles(Flowers.GlowRose.PHOSPHOPHYLLITE, Flowers.Mystical.LIME, Flowers.Vanilla.WHITE_TULIP));
        this.createNetherDeposit(dir, "ancient_debris", new Deposit.Size(250, 500), 4200, false);
        this.createNetherDeposit(dir, "nether_gold", new Deposit.Size(500, 1000), 3200, true);
        this.createNetherDeposit(dir, "nether_quartz", new Deposit.Size(700, 1400), 1200, true);
    }

    public Deposit createNetherDeposit(Path dir, String name, Deposit.Size size, int rarity, boolean replaceOnlyNetherrack) {
        String[] stringArray;
        if (replaceOnlyNetherrack) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "netherrack";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "netherrack";
            stringArray3[1] = "basalt";
            stringArray = stringArray3;
            stringArray3[2] = "blackstone";
        }
        String[] replaceables = stringArray;
        String[] ores = new String[]{name.startsWith("nether") ? name + "_ore" : name};
        return new Deposit(UnitConfig.in((Path)dir, (String)name), size, new Deposit.Altitude(8, 118), rarity, ores, replaceables, new String[0]);
    }

    public Deposit createDeposit(Path dir, String name, DepositSample sample, float priceFactor) {
        return this.createDeposit(dir, name, sample, priceFactor, new String[0]);
    }

    public Deposit createDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicatorCircles) {
        float factor = new Percentage(priceFactor).toFraction();
        int rarity = sample.getRarity(factor);
        return this.createDeposit(dir, name, sample.size, sample.altitude, rarity, indicatorCircles);
    }

    public Deposit createDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity) {
        return this.createDeposit(dir, name, size, altitude, rarity, new String[0]);
    }

    public Deposit createDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] indicatorCircles) {
        return new Deposit(UnitConfig.in((Path)dir, (String)name), size, altitude, rarity, new String[]{"#forge:ores/" + name}, new String[]{Dimensions.OVERWORLD.replaceableBlockId.toString()}, indicatorCircles);
    }

    protected void parseDepositsFrom(Path dir) {
        this.deposits.clear();
        String[] array = new String[]{};
        for (Path path : UnitConfig.listCustomConfigs((Path)dir, null)) {
            Deposit deposit = new Deposit(new UnitConfig(path.toFile()), Deposit.Size.ZERO, Deposit.Altitude.ZERO, 0, array, array, array);
            this.addDeposit(deposit);
        }
    }

    public Path getConfigsDir() {
        return this.configsDir;
    }

    public List<Deposit> getDeposits() {
        return Collections.unmodifiableList(this.deposits);
    }

    public void loadDeposits() {
        this.createDefaultDeposits(this.configsDir);
        this.parseDepositsFrom(this.configsDir);
        this.mapOreBlocks();
    }

    protected void mapOreBlocks() {
        this.oreBlocks.clear();
        for (Deposit deposit : this.deposits) {
            for (Ore ore : deposit.ores.getElements()) {
                BlockStatesSet states = ore.getId().getAllMatchedBlockStates();
                if (states == null) continue;
                this.oreBlocks.addAll((Collection<BlockState>)states);
            }
        }
    }

    public boolean isOreBlock(World world, BlockPos pos) {
        if (GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        return this.oreBlocks.contains(state) || GameWorld.isOreBlock((IWorldReader)world, (BlockPos)pos);
    }

    public boolean addDeposit(Deposit deposit) {
        if (!deposit.isValid()) {
            return false;
        }
        if (this.findDepositBy(deposit.getName()) != null) {
            return false;
        }
        return this.deposits.add(deposit);
    }

    public boolean removeDeposit(Deposit deposit) {
        return this.deposits.remove(deposit);
    }

    @Nullable
    public Deposit findDepositBy(String name) {
        for (Deposit deposit : this.deposits) {
            if (!deposit.getName().equals(name)) continue;
            return deposit;
        }
        return null;
    }
}

