/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.mods.adlods.vanilla.BiomeFeatures;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

@Deprecated
public final class VanillaGen {
    static final Map<Biome, List<ConfiguredFeature<?, ?>>> DISABLED_FEATURES = new HashMap();
    private final ForgeMod mod;
    private VanillaOres ores;

    public VanillaGen(ForgeMod mod) {
        this.mod = mod;
    }

    public void loadOres() {
        this.ores = new VanillaOres(this.mod);
        this.ores.onPostInit();
        this.updateFeatures();
    }

    protected void updateFeatures() {
        GenerationStage.Decoration decoration = GenerationStage.Decoration.UNDERGROUND_ORES;
        for (Biome biome : Biomes.getAll()) {
            List disabledFeatures = DISABLED_FEATURES.computeIfAbsent(biome, key -> new ArrayList());
            BiomeFeatures biomeFeatures = BiomeFeatures.of(biome);
            disabledFeatures.removeIf(feature -> {
                if (!this.shouldBeDisabledIn(biome, (ConfiguredFeature<?, ?>)feature)) {
                    biomeFeatures.listFeaturesOf(decoration).add(() -> feature);
                    return true;
                }
                return false;
            });
            biomeFeatures.listFeaturesOf(decoration).removeIf(feature -> {
                if (this.shouldBeDisabledIn(biome, (ConfiguredFeature)feature.get())) {
                    disabledFeatures.add((ConfiguredFeature)feature.get());
                    return true;
                }
                return false;
            });
            biomeFeatures.applyChanges();
        }
    }

    protected boolean shouldBeDisabledIn(Biome biome, ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
            configuredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.get();
            Feature feature = configuredFeature.field_222737_a;
            if (feature == Feature.field_202290_aj || feature == Feature.field_202294_an) {
                IFeatureConfig config = configuredFeature.field_222738_b;
                BlockState blockState = null;
                if (config instanceof ReplaceBlockConfig) {
                    blockState = ((ReplaceBlockConfig)config).field_202458_b;
                }
                if (config instanceof OreFeatureConfig) {
                    blockState = ((OreFeatureConfig)config).field_202444_d;
                }
                if (blockState != null) {
                    VanillaOre ore = (VanillaOre)this.ores.findBy(blockState);
                    return ore != null && (!ore.isEnabled() || !ore.inAllowedBiome(biome));
                }
            }
        }
        return false;
    }

    static class VanillaOres
    extends RelatedUnitsInit<VanillaOre, BuiltIn> {
        public VanillaOres(ForgeMod mod) {
            super(mod, BuiltIn.class);
        }

        public VanillaOre createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
            return new VanillaOre(config, UnitId.from((Enum)e, (String)""));
        }

        public VanillaOre createCustomUnitFrom(UnitConfig config, String name) {
            return new VanillaOre(config, UnitId.from((String)config.getConfigFile().getPath()));
        }

        static enum BuiltIn implements IForgeEnum
        {
            DIRT,
            GRAVEL,
            GRANITE,
            DIORITE,
            ANDESITE,
            COAL_ORE,
            IRON_ORE,
            GOLD_ORE,
            REDSTONE_ORE,
            DIAMOND_ORE,
            EMERALD_ORE,
            LAPIS_ORE,
            NETHER_QUARTZ_ORE,
            MAGMA_BLOCK,
            INFESTED_STONE;

        }
    }
}

