/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.core.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChallengeArrowEntity
extends AbstractArrowEntity {
    private static float baseDamage = 0.0f;
    private static final int DISTANCE_FACTOR = 4;
    private static final int MAX_DISTANCE = 10;
    private static final int DURATION = 200;
    private static final int MISS_DURATION = 600;
    public boolean discharged;
    private BlockPos origin;

    public ChallengeArrowEntity(EntityType<? extends ChallengeArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public ChallengeArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.CHALLENGE_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = shooter.func_180425_c();
    }

    public ChallengeArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.CHALLENGE_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = new BlockPos(x, y, z);
    }

    protected ItemStack func_184550_j() {
        return this.discharged ? new ItemStack((IItemProvider)APReferences.TRAINING_ARROW_ITEM) : new ItemStack((IItemProvider)APReferences.CHALLENGE_ARROW_ITEM);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        PlayerEntity shooter;
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK && this.func_212360_k() instanceof PlayerEntity && !Utils.isFakePlayer((Entity)this.func_212360_k()) && (shooter = (PlayerEntity)this.func_212360_k()).func_70644_a(APReferences.CHALLENGE_STREAK)) {
            EffectInstance effect = shooter.func_70660_b(APReferences.CHALLENGE_STREAK);
            shooter.func_70688_c(effect);
            shooter.func_184596_c(APReferences.CHALLENGE_STREAK);
            shooter.func_195064_c(new EffectInstance(APReferences.CHALLENGE_MISS, 600, 0, false, false));
            shooter.field_70170_p.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187561_bM, shooter.func_184176_by(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
        super.func_184549_a(raytraceResultIn);
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.func_216348_a();
        if (entity instanceof LivingEntity) {
            PlayerEntity shooter;
            LivingEntity target = (LivingEntity)entity;
            if (this.func_212360_k() instanceof PlayerEntity && !Utils.isFakePlayer((Entity)this.func_212360_k()) && (shooter = (PlayerEntity)this.func_212360_k()) != target && !shooter.func_70644_a(APReferences.CHALLENGE_MISS) && !shooter.func_70644_a(APReferences.CHALLENGE_COMPLETE)) {
                Vec3d originVec;
                double distance;
                int challengeCount = 0;
                if (shooter.func_70644_a(APReferences.CHALLENGE_STREAK)) {
                    challengeCount = shooter.func_70660_b(APReferences.CHALLENGE_STREAK).func_76458_c() + 1;
                }
                if ((distance = (originVec = new Vec3d((Vec3i)(this.origin == null ? shooter.func_180425_c() : this.origin))).func_72438_d(this.func_213303_ch())) >= (double)Math.min(10, challengeCount)) {
                    int distanceBonus = (int)(4.0 * distance);
                    shooter.func_195064_c(new EffectInstance(APReferences.CHALLENGE_STREAK, 200 + distanceBonus, challengeCount, false, false));
                    shooter.func_184185_a(SoundEvents.field_193808_ex, 1.0f, Math.min(0.6f + 0.05f * (float)challengeCount, 1.1f));
                    shooter.field_70170_p.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_193808_ex, shooter.func_184176_by(), 1.0f, Math.min(0.6f + 0.05f * (float)challengeCount, 1.1f));
                    this.discharged = true;
                }
            }
        }
        if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
            this.func_70099_a(this.func_184550_j(), 0.1f);
        }
        this.func_70106_y();
        this.func_184185_a(SoundEvents.field_187751_eD, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
    }

    public void func_213872_b(byte level) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

