/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.core.util.AreaUtils;
import cofh.core.util.Utils;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class GlowstoneArrowEntity
extends AbstractArrowEntity {
    private static final int CLOUD_DURATION = 20;
    public static float baseDamage = 0.5f;
    public static int effectRadius = 4;
    public boolean discharged;

    public GlowstoneArrowEntity(EntityType<? extends GlowstoneArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public GlowstoneArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.GLOWSTONE_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public GlowstoneArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.GLOWSTONE_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
    }

    protected ItemStack func_184550_j() {
        return this.discharged ? new ItemStack((IItemProvider)Items.field_151032_g) : new ItemStack((IItemProvider)APReferences.GLOWSTONE_ARROW_ITEM);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        super.func_184549_a(raytraceResultIn);
        if (!this.discharged && raytraceResultIn.func_216346_c() != RayTraceResult.Type.MISS && effectRadius > 0 && !this.func_70090_H()) {
            if (Utils.isServerWorld((World)this.field_70170_p)) {
                AreaUtils.transformGlowAir((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)effectRadius);
            }
            this.discharged = true;
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        super.func_213868_a(raytraceResultIn);
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
    }

    public void func_213872_b(byte level) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((!this.field_70254_i || this.func_203047_q()) && Utils.isClientWorld((World)this.field_70170_p) && !this.func_70090_H()) {
            Vec3d vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197590_A, this.func_226277_ct_() + d1 * 0.25, this.func_226278_cu_() + d2 * 0.25, this.func_226281_cx_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("ArrowData", this.discharged);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.discharged = compound.func_74767_n("ArrowData");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197590_A);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)effectRadius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)cloud);
    }
}

