/*
 * Decompiled with CFR 0.152.
 */
package com.tanttinator.bedrocktools2;

import com.google.common.collect.Lists;
import com.tanttinator.bedrocktools2.BedrockTools2;
import com.tanttinator.bedrocktools2.capabilities.IRunes;
import com.tanttinator.bedrocktools2.capabilities.RunesProvider;
import com.tanttinator.bedrocktools2.items.bedrock.BedrockArmor;
import com.tanttinator.bedrocktools2.items.bedrockium.BedrockiumArmor;
import com.tanttinator.bedrocktools2.items.bedrockium.BedrockiumAxe;
import com.tanttinator.bedrocktools2.items.bedrockium.BedrockiumPickaxe;
import com.tanttinator.bedrocktools2.items.bedrockium.BedrockiumShovel;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="bedrocktools2")
public class EventHandlers {
    static List<Entity> setOnFire;

    @SubscribeEvent
    public static void getBreakSpeed(PlayerEvent.BreakSpeed speed) {
        IRunes runes;
        EntityPlayer player = speed.getEntityPlayer();
        ItemStack item = player.func_184614_ca();
        if ((item.func_77973_b() instanceof BedrockiumPickaxe || item.func_77973_b() instanceof BedrockiumAxe || item.func_77973_b() instanceof BedrockiumShovel) && (runes = (IRunes)item.getCapability(RunesProvider.RUNES, null)).hasRune(BedrockTools2.Element.WATER).booleanValue() && player.func_70055_a(Material.field_151586_h)) {
            speed.setNewSpeed(speed.getOriginalSpeed() * 5.0f);
        }
    }

    static void AddEffect(EntityPlayer entity, int effectId, int level) {
        Potion effect = Potion.func_188412_a((int)effectId);
        entity.func_184589_d(effect);
        PotionEffect instance = new PotionEffect(effect, Integer.MAX_VALUE, level, false, false);
        instance.func_100012_b(true);
        entity.func_70690_d(instance);
    }

    @SubscribeEvent
    public static void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            IRunes runes;
            BedrockiumArmor armor;
            EntityPlayer entity = (EntityPlayer)event.getEntity();
            Item from = event.getFrom().func_77973_b();
            ItemStack to = event.getTo();
            if (from instanceof BedrockiumArmor) {
                armor = (BedrockiumArmor)from;
                runes = (IRunes)event.getFrom().getCapability(RunesProvider.RUNES, null);
                switch (armor.func_185083_B_()) {
                    case HEAD: {
                        if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue()) {
                            entity.func_184589_d(Potion.func_188412_a((int)16));
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) break;
                        entity.field_71075_bZ.field_75100_b = false;
                        entity.field_71075_bZ.field_75101_c = false;
                        entity.func_71016_p();
                        break;
                    }
                    case CHEST: {
                        if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue()) {
                            entity.func_184589_d(Potion.func_188412_a((int)21));
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_184589_d(Potion.func_188412_a((int)3));
                        break;
                    }
                    case LEGS: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_184589_d(Potion.func_188412_a((int)1));
                        break;
                    }
                    case FEET: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_184589_d(Potion.func_188412_a((int)8));
                        break;
                    }
                    case MAINHAND: {
                        break;
                    }
                }
            }
            if (to.func_77973_b() instanceof BedrockiumArmor) {
                armor = (BedrockiumArmor)to.func_77973_b();
                runes = (IRunes)to.getCapability(RunesProvider.RUNES, null);
                switch (armor.func_185083_B_()) {
                    case HEAD: {
                        if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue()) {
                            EventHandlers.AddEffect(entity, 16, 0);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.field_71075_bZ.field_75101_c = true;
                        entity.func_71016_p();
                        break;
                    }
                    case CHEST: {
                        if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue()) {
                            EventHandlers.AddEffect(entity, 21, 4);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, 3, 2);
                        break;
                    }
                    case LEGS: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, 1, 1);
                        break;
                    }
                    case FEET: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, 8, 4);
                        break;
                    }
                    case MAINHAND: {
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTickPlayerEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        int bedrockArmor = 0;
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_77973_b() instanceof BedrockArmor) {
                ++bedrockArmor;
            }
            if (!(stack.func_77973_b() instanceof BedrockiumArmor)) continue;
            BedrockiumArmor armor = (BedrockiumArmor)stack.func_77973_b();
            IRunes runes = (IRunes)stack.getCapability(RunesProvider.RUNES, null);
            switch (armor.func_185083_B_()) {
                case HEAD: {
                    if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue() && !player.func_70644_a(Potion.func_188412_a((int)16))) {
                        EventHandlers.AddEffect(player, 16, 0);
                    }
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                    break;
                }
                case CHEST: {
                    if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue() && !player.func_70644_a(Potion.func_188412_a((int)21))) {
                        EventHandlers.AddEffect(player, 21, 4);
                    }
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Potion.func_188412_a((int)3))) break;
                    EventHandlers.AddEffect(player, 3, 2);
                    break;
                }
                case LEGS: {
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Potion.func_188412_a((int)1))) break;
                    EventHandlers.AddEffect(player, 1, 1);
                    break;
                }
                case FEET: {
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Potion.func_188412_a((int)8))) break;
                    EventHandlers.AddEffect(player, 8, 4);
                    break;
                }
                case MAINHAND: {
                    break;
                }
            }
        }
        player.func_184589_d(Potion.func_188412_a((int)2));
        if (bedrockArmor > 1) {
            player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), Integer.MAX_VALUE, (int)Math.floor((float)bedrockArmor / 2.0f) - 1, false, false));
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        EntityLivingBase target = event.getEntityLiving();
        if (source instanceof EntityDamageSource && source.func_76364_f() != null) {
            for (ItemStack item : target.func_184193_aE()) {
                BedrockiumArmor armor;
                if (!(item.func_77973_b() instanceof BedrockiumArmor) || (armor = (BedrockiumArmor)item.func_77973_b()).func_185083_B_() != EntityEquipmentSlot.CHEST) continue;
                setOnFire.add(source.func_76364_f());
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            setOnFire = Lists.newArrayList();
        }
        if (event.phase == TickEvent.Phase.END) {
            for (Entity entity : setOnFire) {
                entity.func_70015_d(8);
            }
        }
    }
}

