/*
 * Decompiled with CFR 0.152.
 */
package com.tanttinator.bedrocktools2.worldgen;

import com.google.common.base.Predicate;
import com.tanttinator.bedrocktools2.blocks.BT2Blocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BedrockiumOreGen
implements IWorldGenerator {
    private final WorldGenMinable bedrockiumOreGenerator = new WorldGenMinable(BT2Blocks.bedrockium_ore.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.genStandard((WorldGenerator)this.bedrockiumOreGenerator, world, random, chunkX, chunkZ, 2, 0, 10);
        }
    }

    private void genStandard(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int spawnTries, int minHeight, int maxHeight) {
        if (minHeight < 0) {
            minHeight = 0;
        }
        if (maxHeight > 255) {
            maxHeight = 255;
        }
        if (maxHeight < minHeight) {
            maxHeight += minHeight;
            minHeight = maxHeight - minHeight;
            maxHeight -= minHeight;
        } else if (maxHeight == minHeight) {
            if (maxHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        BlockPos chunkPosAsBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < spawnTries; ++i) {
            generator.func_180709_b(world, random, chunkPosAsBlockPos.func_177982_a(random.nextInt(16), minHeight + random.nextInt(heightDiff), random.nextInt(16)));
        }
    }
}

