/*
 * Decompiled with CFR 0.152.
 */
package com.tanttinator.bedrocktools2;

import com.google.common.collect.Lists;
import com.tanttinator.bedrocktools2.BedrockTools2;
import com.tanttinator.bedrocktools2.capabilities.IRunes;
import com.tanttinator.bedrocktools2.capabilities.RunesProvider;
import com.tanttinator.bedrocktools2.items.BedrockArmor;
import com.tanttinator.bedrocktools2.items.BedrockiumArmor;
import com.tanttinator.bedrocktools2.items.BedrockiumAxe;
import com.tanttinator.bedrocktools2.items.BedrockiumPickaxe;
import com.tanttinator.bedrocktools2.items.BedrockiumShovel;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bedrocktools2")
public class EventHandlers {
    static List<Entity> setOnFire;

    @SubscribeEvent
    public static void getBreakSpeed(PlayerEvent.BreakSpeed speed) {
        IRunes runes;
        PlayerEntity player = speed.getPlayer();
        ItemStack item = player.func_184614_ca();
        if ((item.func_77973_b() instanceof BedrockiumPickaxe || item.func_77973_b() instanceof BedrockiumAxe || item.func_77973_b() instanceof BedrockiumShovel) && (runes = (IRunes)item.getCapability(RunesProvider.RUNES, null).orElse(RunesProvider.RUNES.getDefaultInstance())).hasRune(BedrockTools2.Element.WATER).booleanValue() && player.func_208600_a(FluidTags.field_206959_a)) {
            speed.setNewSpeed(speed.getOriginalSpeed() * 5.0f);
        }
    }

    static void AddEffect(PlayerEntity entity, Effect effect, int level) {
        entity.func_195063_d(effect);
        EffectInstance instance = new EffectInstance(effect, Integer.MAX_VALUE, level, false, false, false);
        instance.func_100012_b(true);
        entity.func_195064_c(instance);
    }

    @SubscribeEvent
    public static void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            IRunes runes;
            BedrockiumArmor armor;
            PlayerEntity entity = (PlayerEntity)event.getEntity();
            Item from = event.getFrom().func_77973_b();
            ItemStack to = event.getTo();
            if (from instanceof BedrockiumArmor) {
                armor = (BedrockiumArmor)from;
                runes = (IRunes)event.getFrom().getCapability(RunesProvider.RUNES, null).orElse(RunesProvider.RUNES.getDefaultInstance());
                switch (armor.func_185083_B_()) {
                    case HEAD: {
                        if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue()) {
                            entity.func_195063_d(Effects.field_76439_r);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) break;
                        entity.field_71075_bZ.field_75100_b = false;
                        entity.field_71075_bZ.field_75101_c = false;
                        entity.func_71016_p();
                        break;
                    }
                    case CHEST: {
                        if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue()) {
                            entity.func_195063_d(Effects.field_180152_w);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_195063_d(Effects.field_76422_e);
                        break;
                    }
                    case LEGS: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_195063_d(Effects.field_76424_c);
                        break;
                    }
                    case FEET: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.func_195063_d(Effects.field_76430_j);
                        break;
                    }
                    case MAINHAND: {
                        break;
                    }
                }
            }
            if (to.func_77973_b() instanceof BedrockiumArmor) {
                armor = (BedrockiumArmor)to.func_77973_b();
                runes = (IRunes)to.getCapability(RunesProvider.RUNES, null).orElse(RunesProvider.RUNES.getDefaultInstance());
                switch (armor.func_185083_B_()) {
                    case HEAD: {
                        if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue()) {
                            EventHandlers.AddEffect(entity, Effects.field_76439_r, 0);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        entity.field_71075_bZ.field_75101_c = true;
                        entity.func_71016_p();
                        break;
                    }
                    case CHEST: {
                        if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue()) {
                            EventHandlers.AddEffect(entity, Effects.field_180152_w, 4);
                        }
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, Effects.field_76422_e, 2);
                        break;
                    }
                    case LEGS: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, Effects.field_76424_c, 1);
                        break;
                    }
                    case FEET: {
                        if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                        EventHandlers.AddEffect(entity, Effects.field_76430_j, 4);
                        break;
                    }
                    case MAINHAND: {
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTickPlayerEvent(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        int bedrockArmor = 0;
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_77973_b() instanceof BedrockArmor) {
                ++bedrockArmor;
            }
            if (!(stack.func_77973_b() instanceof BedrockiumArmor)) continue;
            BedrockiumArmor armor = (BedrockiumArmor)stack.func_77973_b();
            IRunes runes = (IRunes)stack.getCapability(RunesProvider.RUNES, null).orElse(RunesProvider.RUNES.getDefaultInstance());
            switch (armor.func_185083_B_()) {
                case HEAD: {
                    if (runes.hasRune(BedrockTools2.Element.FIRE).booleanValue() && !player.func_70644_a(Effects.field_76439_r)) {
                        EventHandlers.AddEffect(player, Effects.field_76439_r, 0);
                    }
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue()) break;
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                    break;
                }
                case CHEST: {
                    if (runes.hasRune(BedrockTools2.Element.EARTH).booleanValue() && !player.func_70644_a(Effects.field_180152_w)) {
                        EventHandlers.AddEffect(player, Effects.field_180152_w, 4);
                    }
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Effects.field_76422_e)) break;
                    EventHandlers.AddEffect(player, Effects.field_76422_e, 2);
                    break;
                }
                case LEGS: {
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Effects.field_76424_c)) break;
                    EventHandlers.AddEffect(player, Effects.field_76424_c, 1);
                    break;
                }
                case FEET: {
                    if (!runes.hasRune(BedrockTools2.Element.AIR).booleanValue() || player.func_70644_a(Effects.field_76430_j)) break;
                    EventHandlers.AddEffect(player, Effects.field_76430_j, 4);
                    break;
                }
                case MAINHAND: {
                    break;
                }
            }
        }
        player.func_195063_d(Effects.field_76421_d);
        if (bedrockArmor > 1) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, Integer.MAX_VALUE, (int)Math.floor((float)bedrockArmor / 2.0f) - 1, false, false, false));
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntityLiving();
        if (source instanceof EntityDamageSource && source.func_76364_f() != null) {
            for (ItemStack item : target.func_184193_aE()) {
                BedrockiumArmor armor;
                if (!(item.func_77973_b() instanceof BedrockiumArmor) || (armor = (BedrockiumArmor)item.func_77973_b()).func_185083_B_() != EquipmentSlotType.CHEST) continue;
                setOnFire.add(source.func_76364_f());
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            setOnFire = Lists.newArrayList();
        }
        if (event.phase == TickEvent.Phase.END) {
            for (Entity entity : setOnFire) {
                entity.func_70015_d(8);
            }
        }
    }
}

