/*
 * Decompiled with CFR 0.152.
 */
package com.tanttinator.bedrocktools2.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.tanttinator.bedrocktools2.items.IUpgradeable;
import com.tanttinator.bedrocktools2.items.RuneItem;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RuneUpgradeRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = new ResourceLocation("bedrocktools2", "rune_upgrade");
    public static final Serializer SERIALIZER = new Serializer();

    public RuneUpgradeRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack item = ItemStack.field_190927_a;
        ItemStack rune = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof IUpgradeable) {
                if (!item.func_190926_b()) {
                    return false;
                }
                item = itemstack;
                continue;
            }
            if (itemstack.func_77973_b() instanceof RuneItem) {
                if (IUpgradeable.HasRune(item, ((RuneItem)itemstack.func_77973_b()).getElement()).booleanValue()) {
                    return false;
                }
                rune = itemstack;
                continue;
            }
            return false;
        }
        return !item.func_190926_b() && !rune.func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ArrayList runes = Lists.newArrayList();
        ItemStack item = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof IUpgradeable) {
                if (!item.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                item = itemstack.func_77946_l();
                continue;
            }
            if (itemstack.func_77973_b() instanceof RuneItem) {
                if (IUpgradeable.HasRune(item, ((RuneItem)itemstack.func_77973_b()).getElement()).booleanValue()) {
                    return ItemStack.field_190927_a;
                }
                runes.add(itemstack);
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (!item.func_190926_b() && !runes.isEmpty()) {
            for (ItemStack rune : runes) {
                ((IUpgradeable)item.func_77973_b()).addRune(item, ((RuneItem)rune.func_77973_b()).getElement());
            }
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RuneUpgradeRecipe> {
        public RuneUpgradeRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new RuneUpgradeRecipe(recipeId);
        }

        public RuneUpgradeRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new RuneUpgradeRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, RuneUpgradeRecipe recipe) {
        }
    }
}

