/*
 * Decompiled with CFR 0.152.
 */
package net.korti.bettermuffling.client.gui;

import net.korti.bettermuffling.common.config.ModConfig;
import net.korti.bettermuffling.common.tileentity.TileMuffling;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MufflingBlockGui
extends GuiScreen {
    private TileMuffling tileMuffling;
    private String title = "Muffling Options";
    private GuiButton placerOnlyButton;

    public MufflingBlockGui(TileMuffling tileMuffling) {
        this.tileMuffling = tileMuffling;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.title = I18n.func_135052_a((String)"gui.muffling_block.title", (Object[])new Object[0]);
        int i = 0;
        this.field_146292_n.add(new RangeButton(42, this.field_146294_l / 2 - 155 + i % 2 * 160, this.field_146295_m / 6 - 12 + 24 * (i >> 1) + 35, this.tileMuffling.getRange()));
        this.placerOnlyButton = new GuiButton(199, this.field_146294_l / 2 - 155 + ++i % 2 * 160, this.field_146295_m / 6 - 12 + 24 * (i >> 1) + 35, 150, 20, "");
        this.setPlacerOnlyButtonName(this.tileMuffling.getPlacerOnly());
        this.field_146292_n.add(this.placerOnlyButton);
        ++i;
        for (SoundCategory soundcategory : SoundCategory.values()) {
            if (soundcategory == SoundCategory.MASTER || soundcategory == SoundCategory.MUSIC) continue;
            this.field_146292_n.add(new SoundButton(soundcategory.ordinal(), this.field_146294_l / 2 - 155 + i % 2 * 160, this.field_146295_m / 6 - 12 + 24 * (i >> 1) + 35, soundcategory, this.tileMuffling.getSoundLevel(soundcategory)));
            ++i;
        }
        this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 143, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, this.field_146295_m / 6 + 10, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 199: {
                    boolean placerOnly = this.tileMuffling.switchPlacerOnly();
                    this.setPlacerOnlyButtonName(placerOnly);
                    break;
                }
                case 200: {
                    this.field_146297_k.func_147108_a(null);
                    if (this.field_146297_k.field_71462_r != null) break;
                    this.field_146297_k.func_71381_h();
                }
            }
        }
    }

    private void updateRange(int range) {
        this.tileMuffling.updateRange(range);
    }

    private void updateSoundLevel(SoundCategory category, float volume) {
        this.tileMuffling.updateSoundLevel(category, volume);
    }

    private void setPlacerOnlyButtonName(boolean placerOnly) {
        this.placerOnlyButton.field_146126_j = placerOnly ? I18n.func_135052_a((String)"button.muffling_block.placer_only.on.name", (Object[])new Object[0]) : I18n.func_135052_a((String)"button.muffling_block.placer_only.off.name", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    class SoundButton
    extends GuiButton {
        private final SoundCategory category;
        private final String categoryName;
        private float minVolume;
        private float maxVolume;
        public float volume;
        public boolean pressed;

        public SoundButton(int buttonId, int x, int y, SoundCategory category, float volume) {
            super(buttonId, x, y, 150, 20, "");
            this.minVolume = (float)ModConfig.minVolume;
            this.maxVolume = (float)ModConfig.maxVolume - this.minVolume;
            this.category = category;
            this.categoryName = I18n.func_135052_a((String)("soundCategory." + category.func_187948_a()), (Object[])new Object[0]);
            this.volume = (volume - this.minVolume) / this.maxVolume;
            this.field_146126_j = this.categoryName + ": " + this.getDisplayString();
        }

        private String getDisplayString() {
            return (int)(this.calcVolume() * 100.0f) + "%";
        }

        private float calcVolume() {
            return this.volume * this.maxVolume + this.minVolume;
        }

        protected int func_146114_a(boolean mouseOver) {
            return 0;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.pressed) {
                    this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                    this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.0f, (float)1.0f);
                    MufflingBlockGui.this.updateSoundLevel(this.category, this.calcVolume());
                    this.field_146126_j = this.categoryName + ": " + this.getDisplayString();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h + (int)(this.volume * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.volume * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.0f, (float)1.0f);
                MufflingBlockGui.this.updateSoundLevel(this.category, this.calcVolume());
                this.field_146126_j = this.categoryName + ": " + this.getDisplayString();
                this.pressed = true;
                return true;
            }
            return false;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this.pressed = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    class RangeButton
    extends GuiButton {
        private final String labelName;
        private float minRange;
        private float maxRange;
        public float range;
        public boolean pressed;

        public RangeButton(int buttonId, int x, int y, int range) {
            super(buttonId, x, y, 150, 20, "");
            this.minRange = 2.0f;
            this.maxRange = (float)ModConfig.maxRange - this.minRange;
            this.labelName = I18n.func_135052_a((String)"button.muffling_block.range.name", (Object[])new Object[0]);
            this.range = ((float)range - this.minRange) / this.maxRange;
            this.field_146126_j = this.labelName + ": " + this.getDisplayString();
        }

        private String getDisplayString() {
            return String.valueOf(this.getRange());
        }

        private int getRange() {
            return (int)(this.range * this.maxRange + this.minRange);
        }

        protected int func_146114_a(boolean mouseOver) {
            return 0;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.pressed) {
                    this.range = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                    this.range = MathHelper.func_76131_a((float)this.range, (float)0.0f, (float)1.0f);
                    MufflingBlockGui.this.updateRange(this.getRange());
                    this.field_146126_j = this.labelName + ": " + this.getDisplayString();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h + (int)(this.range * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.range * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.range = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.range = MathHelper.func_76131_a((float)this.range, (float)0.0f, (float)1.0f);
                MufflingBlockGui.this.updateRange(this.getRange());
                this.field_146126_j = this.labelName + ": " + this.getDisplayString();
                this.pressed = true;
                return true;
            }
            return false;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this.pressed = false;
        }
    }
}

