/*
 * Decompiled with CFR 0.152.
 */
package net.korti.bettermuffling.client.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.korti.bettermuffling.client.model.MeshDefinitionFix;
import net.korti.bettermuffling.common.registry.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModModelManager {
    public static final ModModelManager INSTANCE = new ModModelManager();
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    private ModModelManager() {
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerBlockModels();
    }

    private void registerBlockModels() {
        this.registerBlockItemModel(ModBlocks.MUFFLING_BLOCK.func_176223_P());
        ModBlocks.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerBlockItemModel(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            this.registerItemModel(item, new ModelResourceLocation(block.getRegistryName(), this.propertyStringMapper.func_178131_a((Map)state.func_177228_b())));
        }
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    private void registerItemModel(Item item, ItemMeshDefinition itemMeshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)itemMeshDefinition);
    }
}

