/*
 * Decompiled with CFR 0.152.
 */
package net.korti.bettermuffling.common.block;

import javax.annotation.Nullable;
import net.korti.bettermuffling.BetterMuffling;
import net.korti.bettermuffling.common.tileentity.TileMuffling;
import net.korti.bettermuffling.common.util.TileCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class MufflingBlock
extends BlockContainer {
    public MufflingBlock() {
        super(Material.field_151580_n);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.setRegistryName("bettermuffling", "muffling_block");
        this.func_149663_c("bettermuffling.muffling_block");
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileMuffling();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMuffling && !player.func_70093_af() && ((TileMuffling)te).isPlayerAllowedToOpen(player)) {
            player.openGui((Object)BetterMuffling.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tileData = stack.func_179543_a("tile_data");
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMuffling) {
            if (tileData != null) {
                ((TileMuffling)te).readMufflingData(tileData);
            }
            ((TileMuffling)te).setPlacedBy(placer.func_110124_au());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile;
        if (world.field_72995_K && (tile = world.func_175625_s(pos)) != null) {
            if (tile instanceof TileMuffling) {
                ((TileMuffling)tile).hideIndicator();
            }
            MinecraftForge.EVENT_BUS.unregister((Object)tile);
            TileCache.removeTileEntity(tile);
        }
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMuffling) {
            TileMuffling tMuffling = (TileMuffling)te;
            ItemStack dropStack = new ItemStack((Block)this);
            NBTTagCompound tileData = dropStack.func_190925_c("tile_data");
            tMuffling.writeMufflingData(tileData);
            drops.add((Object)dropStack);
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }
}

