/*
 * Decompiled with CFR 0.152.
 */
package net.korti.bettermuffling.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="bettermuffling")
@Config.LangKey(value="gui.config.title")
public class ModConfig {
    @Config.Comment(value={"Maximum range for the sound muffling effect."})
    @Config.RangeInt(min=2, max=64)
    @Config.Name(value="Max Range")
    @Config.RequiresWorldRestart
    public static int maxRange = 16;
    @Config.Comment(value={"Minimum volume for the sound muffling effect."})
    @Config.RangeDouble(min=0.0, max=0.99)
    @Config.Name(value="Min Volume")
    @Config.RequiresWorldRestart
    public static double minVolume = 0.0;
    @Config.Comment(value={"Maximum volume for the sound muffling effect."})
    @Config.RangeDouble(min=0.01, max=1.0)
    @Config.Name(value="Max Volume")
    @Config.RequiresWorldRestart
    public static double maxVolume = 1.0;
    @Config.Name(value="Muffler Indicator")
    public static final MufflerIndicator mufflerIndicator = new MufflerIndicator();

    public static class MufflerIndicator {
        @Config.Comment(value={"Show muffler indicator."})
        @Config.Name(value="Enable")
        public boolean enable = true;
        @Config.Comment(value={"The x coordinate of the indicator position."})
        @Config.Name(value="Position X")
        public int x = 25;
        @Config.Comment(value={"The y coordinate of the indicator position."})
        @Config.Name(value="Position Y")
        public int y = 25;
    }

    @Mod.EventBusSubscriber(modid="bettermuffling")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bettermuffling")) {
                ConfigManager.sync((String)"bettermuffling", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

