/*
 * Decompiled with CFR 0.152.
 */
package net.korti.bettermuffling.common.tileentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.korti.bettermuffling.common.config.ModConfig;
import net.korti.bettermuffling.common.network.PacketNetworkHandler;
import net.korti.bettermuffling.common.network.UpdateTileEntityMessage;
import net.korti.bettermuffling.common.network.UpdateTileEntityRequestMessage;
import net.korti.bettermuffling.common.util.TileCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMuffling
extends TileEntity
implements ITickable {
    private final Map<SoundCategory, Float> soundLevels = new HashMap<SoundCategory, Float>();
    private int range = 6;
    private UUID placedBy;
    private boolean placerOnly = false;

    public TileMuffling() {
        this.init();
    }

    private void init() {
        Set categoryNames = SoundCategory.func_187949_b();
        categoryNames.remove(SoundCategory.MASTER.func_187948_a());
        categoryNames.remove(SoundCategory.MUSIC.func_187948_a());
        for (String categoryName : categoryNames) {
            SoundCategory category = SoundCategory.func_187950_a((String)categoryName);
            this.soundLevels.put(category, Float.valueOf((float)ModConfig.minVolume));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeMufflingData(compound);
        return super.func_189515_b(compound);
    }

    public void writeMufflingData(NBTTagCompound compound) {
        for (Map.Entry<SoundCategory, Float> soundLevel : this.soundLevels.entrySet()) {
            compound.func_74776_a(soundLevel.getKey().func_187948_a(), soundLevel.getValue().floatValue());
        }
        compound.func_74768_a("range", this.range);
        compound.func_186854_a("placedBy", this.placedBy);
        compound.func_74757_a("placerOnly", this.placerOnly);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readMufflingData(compound);
        this.validateWithConfig();
    }

    public void readMufflingData(NBTTagCompound compound) {
        for (SoundCategory category : this.soundLevels.keySet()) {
            this.soundLevels.replace(category, Float.valueOf(compound.func_74760_g(category.func_187948_a())));
        }
        this.range = compound.func_74762_e("range");
        this.placedBy = compound.func_186857_a("placedBy");
        this.placerOnly = compound.func_74767_n("placerOnly");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onSoundPlaying(PlaySoundEvent event) {
        ISound iSound = event.getSound();
        SoundCategory category = iSound.func_184365_d();
        if (this.isInRange(iSound) && this.soundLevels.containsKey(category)) {
            iSound.func_184366_a(event.getManager().field_148622_c);
            float soundLevel = this.soundLevels.get(category).floatValue();
            PositionedSoundRecord newSound = new PositionedSoundRecord(iSound.func_147650_b(), category, iSound.func_147653_e() * soundLevel, iSound.func_147655_f(), iSound.func_147657_c(), iSound.func_147652_d(), iSound.func_147656_j(), iSound.func_147649_g(), iSound.func_147654_h(), iSound.func_147651_i());
            event.setResultSound((ISound)newSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isInRange(ISound sound) {
        double distance = Math.sqrt(this.func_145835_a(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()));
        return this.isInRange(distance);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isInRange(double distance) {
        return distance <= (double)(this.range + 1);
    }

    private void writePos(BlockPos pos, NBTTagCompound compound) {
        compound.func_74768_a("pos_x", pos.func_177958_n());
        compound.func_74768_a("pos_y", pos.func_177956_o());
        compound.func_74768_a("pos_z", pos.func_177952_p());
    }

    private BlockPos readPos(NBTTagCompound compound) {
        return new BlockPos(compound.func_74762_e("pos_x"), compound.func_74762_e("pos_y"), compound.func_74762_e("pos_z"));
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleIndicator();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleIndicator() {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        double distance = Math.sqrt(player.func_174831_c(this.func_174877_v())) + 0.5;
        if (this.isInRange(distance)) {
            this.showIndicator();
        } else {
            this.hideIndicator();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showIndicator() {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound mufflingIndicator = entityData.func_74775_l("muffling_indicator");
        if (!mufflingIndicator.func_74767_n("render")) {
            mufflingIndicator.func_74757_a("render", true);
            this.writePos(this.func_174877_v(), mufflingIndicator);
            entityData.func_74782_a("muffling_indicator", (NBTBase)mufflingIndicator);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void hideIndicator() {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound mufflingIndicator = entityData.func_74775_l("muffling_indicator");
        if (this.readPos(mufflingIndicator).equals((Object)this.func_174877_v()) && mufflingIndicator.func_74767_n("render")) {
            mufflingIndicator.func_74757_a("render", false);
            this.writePos(BlockPos.field_177992_a, mufflingIndicator);
            entityData.func_74782_a("muffling_indicator", (NBTBase)mufflingIndicator);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onLoad() {
        if (this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            TileCache.addTileEntity(this);
            PacketNetworkHandler.sendToServer(new UpdateTileEntityRequestMessage(this.func_174877_v()));
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeMufflingData(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, compound);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readMufflingData(pkt.func_148857_g());
    }

    public void syncToClient() {
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
        }
    }

    private void syncToServer() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeMufflingData(compound);
        PacketNetworkHandler.sendToServer(new UpdateTileEntityMessage(this.func_174877_v(), compound));
    }

    public void onDataPacket(UpdateTileEntityMessage message) {
        this.readMufflingData(message.getCompound());
        this.syncToClient();
    }

    private void validateWithConfig() {
        this.range = MathHelper.func_76125_a((int)this.range, (int)2, (int)ModConfig.maxRange);
        for (Map.Entry<SoundCategory, Float> soundLevel : this.soundLevels.entrySet()) {
            this.soundLevels.replace(soundLevel.getKey(), Float.valueOf(MathHelper.func_76131_a((float)soundLevel.getValue().floatValue(), (float)((float)ModConfig.minVolume), (float)((float)ModConfig.maxVolume))));
        }
    }

    public float getSoundLevel(SoundCategory soundCategory) {
        return this.soundLevels.get(soundCategory).floatValue();
    }

    public int getRange() {
        return this.range;
    }

    public void updateSoundLevel(SoundCategory soundCategory, float volume) {
        this.soundLevels.replace(soundCategory, Float.valueOf(volume));
        this.syncToServer();
    }

    public void updateRange(int range) {
        this.range = range;
        this.syncToServer();
    }

    public void setPlacedBy(UUID placedBy) {
        this.placedBy = placedBy;
    }

    public boolean getPlacerOnly() {
        return this.placerOnly;
    }

    public boolean switchPlacerOnly() {
        this.placerOnly = !this.placerOnly;
        this.syncToServer();
        return this.placerOnly;
    }

    public boolean isPlayerAllowedToOpen(EntityPlayer player) {
        return !this.placerOnly || this.placedBy.equals(player.func_110124_au());
    }
}

