/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uk.co.harryyoud.biospheres.Sphere;
import uk.co.harryyoud.biospheres.config.BiosphereConfig;

public class BiosphereBiomeProvider
extends BiomeProvider {
    public final IWorld world;
    public static final Set<Biome> biomes = new HashSet<Biome>(ForgeRegistries.BIOMES.getValues());
    public static final Biome[] biomesArray;

    protected BiosphereBiomeProvider(IWorld worldIn, OverworldBiomeProviderSettings settingsProvider) {
        super(biomes);
        this.world = worldIn;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        BlockPos pos = new BlockPos(x <<= 2, y, z <<= 2);
        Sphere sphere = Sphere.getClosest(this.world, pos);
        return sphere.getBiome();
    }

    static {
        biomes.removeIf(biome -> BiosphereConfig.bannedBiomeCategories.contains(biome.func_201856_r()));
        biomes.removeIf(biome -> BiosphereConfig.bannedBiomes.contains(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).toString()));
        biomesArray = biomes.toArray(new Biome[biomes.size()]);
    }
}

