/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uk.co.harryyoud.biospheres.BlockPosIterator;
import uk.co.harryyoud.biospheres.Sphere;
import uk.co.harryyoud.biospheres.Utils;
import uk.co.harryyoud.biospheres.config.BiosphereGenSettingsSerializer;
import uk.co.harryyoud.biospheres.wrappers.IChunkWrapper;
import uk.co.harryyoud.biospheres.wrappers.IWorldWrapper;

public class BiosphereChunkGenerator
extends OverworldChunkGenerator {
    private final BlockState DOME_BLOCK;
    private final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final BlockState OUTSIDE_FILLER_BLOCK;
    private final BlockState BRIDGE_BLOCK;
    private final BlockState FENCE_BLOCK = Blocks.field_180407_aO.func_176223_P();
    private static final ArrayList<Block> BANNED_BLOCKS = new ArrayList<Block>(Arrays.asList(Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150353_l));
    private final ArrayList<Block> ALLOWED_BLOCKS = new ArrayList<Block>(Arrays.asList(this.AIR.func_177230_c(), this.FENCE_BLOCK.func_177230_c()));
    public final int BRIDGE_WIDTH = 2;
    public final int BRIDGE_HEIGHT = 4;
    private final INoiseGenerator surfaceDepthNoise2;
    private final BiosphereGenSettingsSerializer.BiosphereGenSettings genSettings;
    private static final int noiseSizeX = 4;
    private static final int noiseSizeY = 32;
    private static final int noiseSizeZ = 4;
    private static final int verticalNoiseGranularity = 8;
    private static final int horizontalNoiseGranularity = 4;
    private final Map<ChunkPos, double[][][]> depthNoiseCache = new LinkedHashMap<ChunkPos, double[][][]>(500, 0.7f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ChunkPos, double[][][]> eldest) {
            return this.size() > 500;
        }
    };

    public BiosphereChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, BiosphereGenSettingsSerializer.BiosphereGenSettings genSettings) {
        super(worldIn, biomeProviderIn, (OverworldGenSettings)genSettings);
        this.genSettings = genSettings;
        this.DOME_BLOCK = this.genSettings.domeBlock;
        this.BRIDGE_BLOCK = this.genSettings.bridgeBlock;
        this.OUTSIDE_FILLER_BLOCK = this.genSettings.outsideFillerBlock;
        this.ALLOWED_BLOCKS.add(this.DOME_BLOCK.func_177230_c());
        this.ALLOWED_BLOCKS.add(this.BRIDGE_BLOCK.func_177230_c());
        this.ALLOWED_BLOCKS.add(this.OUTSIDE_FILLER_BLOCK.func_177230_c());
        Sphere.minRadius = this.genSettings.sphereMinRadius;
        Sphere.maxRadius = this.genSettings.sphereMaxRadius;
        Sphere.midY = this.genSettings.sphereMidY;
        try {
            this.surfaceDepthNoise2 = (INoiseGenerator)ObfuscationReflectionHelper.getPrivateValue(NoiseChunkGenerator.class, (Object)((Object)this), (String)"field_222571_r");
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new Error();
        }
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunkIn) {
        Sphere sphere = Sphere.getClosest((IWorld)region, chunkIn.func_76632_l().func_206849_h());
        for (BlockPos pos : new BlockPosIterator(chunkIn.func_76632_l())) {
            double sphereDistance = sphere.getDistanceToCenter(pos);
            if (pos.func_177956_o() != sphere.getCentre().func_177956_o() || !(sphereDistance <= (double)sphere.radius)) continue;
            Biome biome = region.func_226691_t_(pos);
            biome.func_206854_a(sphere.getRandom(), chunkIn, pos.func_177958_n(), pos.func_177952_p(), chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p()), this.getSurfaceDepthNoise(pos), this.genSettings.func_205532_l(), this.genSettings.func_205533_m(), this.func_222530_f(), region.func_72905_C());
        }
    }

    public void func_202092_b(WorldGenRegion region) {
        IWorldWrapper worldWrapper = new IWorldWrapper((IWorld)region, this.func_222530_f());
        worldWrapper.setBlockStatePredicate(pos -> {
            Sphere sphere = Sphere.getClosest((IWorld)region.func_201672_e(), pos);
            return sphere.getDistanceToCenter((BlockPos)pos) < sphere.radius;
        });
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_225552_a_(region.func_225523_d_(), blockpos.func_177982_a(8, 8, 8));
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
            try {
                biome.func_203608_a(generationstage$decoration, (ChunkGenerator)this, (IWorld)worldWrapper, i1, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)generationstage$decoration).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome));
                throw new ReportedException(crashreport);
            }
        }
        IChunk chunkIn = region.func_212866_a_(region.func_201679_a(), region.func_201680_b());
        Sphere sphere = Sphere.getClosest((IWorld)region, chunkIn.func_76632_l().func_206849_h());
        for (BlockPos pos2 : new BlockPosIterator(chunkIn.func_76632_l())) {
            double sphereDistance = sphere.getDistanceToCenter(pos2);
            BlockState prevState = region.func_180495_p(pos2);
            BlockState state = null;
            for (int d = 0; d < 4; ++d) {
                sphere.computeBridgeJoin(this, Direction.func_176731_b((int)d));
            }
            if (sphereDistance == (double)sphere.radius) {
                if (BANNED_BLOCKS.contains(prevState.func_177230_c()) || prevState.isAir((IBlockReader)region, pos2) || prevState.isFoliage((IWorldReader)region, pos2) || prevState.func_177230_c() instanceof BushBlock || prevState.func_177230_c().func_203417_a(BlockTags.field_206952_E) || !prevState.func_200132_m() || chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, pos2.func_177958_n(), pos2.func_177952_p()) == pos2.func_177956_o() - 1 && !this.ALLOWED_BLOCKS.contains(region.func_180495_p(pos2).func_177230_c())) {
                    state = this.DOME_BLOCK;
                }
                for (MutableBoundingBox box : sphere.getCutouts()) {
                    if (!box.func_175898_b((Vec3i)pos2) || state == null || state.func_177230_c() != this.DOME_BLOCK.func_177230_c()) continue;
                    state = this.AIR;
                    break;
                }
            }
            if (sphereDistance > (double)sphere.radius && !this.ALLOWED_BLOCKS.contains(prevState.func_177230_c()) && !region.func_175623_d(pos2) && prevState.getLightValue((IBlockReader)region, pos2) == 0) {
                state = this.AIR;
            }
            if (state == null) continue;
            if (state == this.AIR) {
                region.func_217377_a(pos2, false);
                continue;
            }
            region.func_180501_a(pos2, state, 3);
        }
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        double[][][] noises = this.getNoiseForChunk(worldIn, chunkIn.func_76632_l());
        Sphere sphere = Sphere.getClosest(worldIn, chunkIn.func_76632_l().func_206849_h());
        for (BlockPos pos : new BlockPosIterator(chunkIn.func_76632_l())) {
            BlockState state = null;
            int sphereDistance = sphere.getDistanceToCenter(pos);
            if (pos.func_177956_o() < this.func_222530_f() && sphereDistance < sphere.radius) {
                state = this.genSettings.func_205533_m();
            }
            if (noises[Math.abs(pos.func_177958_n()) % 16][this.correctYValue(pos.func_177956_o())][Math.abs(pos.func_177952_p()) % 16] > 0.0 && sphereDistance <= sphere.radius) {
                state = this.genSettings.func_205532_l();
            }
            if (state != null && !state.func_196958_f()) {
                chunkIn.func_177436_a(pos, state, false);
            }
            if (sphereDistance > sphere.radius) {
                chunkIn.func_177436_a(pos, this.OUTSIDE_FILLER_BLOCK, false);
            }
            if (sphereDistance < sphere.radius) continue;
            Direction dir = null;
            if (Utils.inIncRange(pos.func_177958_n(), sphere.getCentre().func_177958_n() + 2, sphere.getCentre().func_177958_n() - 2)) {
                if (pos.func_177952_p() < sphere.getCentre().func_177952_p()) {
                    dir = Direction.NORTH;
                } else if (pos.func_177952_p() > sphere.getCentre().func_177952_p()) {
                    dir = Direction.SOUTH;
                }
            }
            if (Utils.inIncRange(pos.func_177952_p(), sphere.getCentre().func_177952_p() + 2, sphere.getCentre().func_177952_p() - 2)) {
                if (pos.func_177958_n() < sphere.getCentre().func_177958_n()) {
                    dir = Direction.WEST;
                } else if (pos.func_177958_n() > sphere.getCentre().func_177958_n()) {
                    dir = Direction.EAST;
                }
            }
            if (dir == null) continue;
            Direction.Axis axis = dir.func_176740_k();
            Direction.Axis otherAxis = dir.func_176746_e().func_176740_k();
            Sphere nextClosestSphere = Sphere.getClosest(worldIn, Utils.moveChunk(sphere.getCentreChunk(), dir, 15).func_206849_h());
            BlockPos aimFor = nextClosestSphere.computeBridgeJoin(this, dir.func_176734_d());
            BlockPos aimFrom = sphere.computeBridgeJoin(this, dir);
            int diffDenom = Utils.getCoord(aimFrom, axis) - Utils.getCoord(aimFor, axis);
            if (diffDenom == 0) {
                diffDenom = 1;
            }
            double gradient = (double)(aimFrom.func_177956_o() - aimFor.func_177956_o()) / (double)diffDenom;
            double newY = Math.round(gradient * (double)(Utils.getCoord(pos, axis) - Utils.getCoord(aimFrom, axis)) + (double)aimFrom.func_177956_o());
            if (!Utils.inIncRange(Utils.getCoord(pos, axis), Utils.getCoord(aimFrom, axis), Utils.getCoord(aimFor, axis))) continue;
            if ((double)pos.func_177956_o() == newY) {
                chunkIn.func_177436_a(pos, this.BRIDGE_BLOCK, false);
            }
            if ((double)pos.func_177956_o() != newY + 1.0 || Utils.getCoord(pos, otherAxis) != Utils.getCoord(sphere.getCentre(), otherAxis) + 2 && Utils.getCoord(pos, otherAxis) != Utils.getCoord(sphere.getCentre(), otherAxis) - 2) continue;
            chunkIn.func_177436_a(pos, this.FENCE_BLOCK, false);
            chunkIn.func_201594_d(pos);
        }
    }

    double[][][] getNoiseForChunk(IWorld worldIn, ChunkPos chunkPos) {
        if (this.depthNoiseCache.containsKey(chunkPos)) {
            return this.depthNoiseCache.get(chunkPos);
        }
        double[][][] depthNoise = this.calcNoiseForChunk(worldIn, chunkPos);
        this.depthNoiseCache.put(chunkPos, depthNoise);
        return depthNoise;
    }

    private double[][][] calcNoiseForChunk(IWorld worldIn, ChunkPos chunkPos) {
        int chunkXPos = chunkPos.field_77276_a;
        int chunkXStart = chunkPos.func_180334_c();
        int chunkZPos = chunkPos.field_77275_b;
        int chunkZStart = chunkPos.func_180333_d();
        double[][][] noises = new double[2][5][33];
        double[][][] finalNoises = new double[16][256][16];
        for (int zNoiseOffset = 0; zNoiseOffset < 5; ++zNoiseOffset) {
            noises[0][zNoiseOffset] = new double[33];
            this.func_222548_a(noises[0][zNoiseOffset], chunkXPos * 4, chunkZPos * 4 + zNoiseOffset);
            noises[1][zNoiseOffset] = new double[33];
        }
        for (int xNoiseOffset = 0; xNoiseOffset < 4; ++xNoiseOffset) {
            int zNoiseOffset;
            for (zNoiseOffset = 0; zNoiseOffset < 5; ++zNoiseOffset) {
                this.func_222548_a(noises[1][zNoiseOffset], chunkXPos * 4 + xNoiseOffset + 1, chunkZPos * 4 + zNoiseOffset);
            }
            for (zNoiseOffset = 0; zNoiseOffset < 4; ++zNoiseOffset) {
                for (int yNoiseOffset = 31; yNoiseOffset >= 0; --yNoiseOffset) {
                    double noise000 = noises[0][zNoiseOffset][yNoiseOffset];
                    double noise010 = noises[0][zNoiseOffset + 1][yNoiseOffset];
                    double noise100 = noises[1][zNoiseOffset][yNoiseOffset];
                    double noise110 = noises[1][zNoiseOffset + 1][yNoiseOffset];
                    double noise001 = noises[0][zNoiseOffset][yNoiseOffset + 1];
                    double noise011 = noises[0][zNoiseOffset + 1][yNoiseOffset + 1];
                    double noise101 = noises[1][zNoiseOffset][yNoiseOffset + 1];
                    double noise111 = noises[1][zNoiseOffset + 1][yNoiseOffset + 1];
                    for (int yGranularityOffset = 7; yGranularityOffset >= 0; --yGranularityOffset) {
                        int worldY = yNoiseOffset * 8 + yGranularityOffset;
                        double yNoiseScale = (double)yGranularityOffset / 8.0;
                        double d6 = MathHelper.func_219803_d((double)yNoiseScale, (double)noise000, (double)noise001);
                        double d7 = MathHelper.func_219803_d((double)yNoiseScale, (double)noise100, (double)noise101);
                        double d8 = MathHelper.func_219803_d((double)yNoiseScale, (double)noise010, (double)noise011);
                        double d9 = MathHelper.func_219803_d((double)yNoiseScale, (double)noise110, (double)noise111);
                        for (int XGranularityOffset = 0; XGranularityOffset < 4; ++XGranularityOffset) {
                            int worldX = chunkXStart + xNoiseOffset * 4 + XGranularityOffset;
                            double xNoiseScale = (double)XGranularityOffset / 4.0;
                            double d11 = MathHelper.func_219803_d((double)xNoiseScale, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)xNoiseScale, (double)d8, (double)d9);
                            for (int zGranularityOffset = 0; zGranularityOffset < 4; ++zGranularityOffset) {
                                double finalNoiseClamped;
                                int worldZ = chunkZStart + zNoiseOffset * 4 + zGranularityOffset;
                                double zNoiseScale = (double)zGranularityOffset / 4.0;
                                double finalNoise = MathHelper.func_219803_d((double)zNoiseScale, (double)d11, (double)d12);
                                finalNoises[Math.abs((int)worldX) % 16][worldY][Math.abs((int)worldZ) % 16] = finalNoiseClamped = MathHelper.func_151237_a((double)(finalNoise / 200.0), (double)-1.0, (double)1.0);
                            }
                        }
                    }
                }
            }
            double[][] temp = noises[0];
            noises[0] = noises[1];
            noises[1] = temp;
        }
        return finalNoises;
    }

    public double getSurfaceDepthNoise(BlockPos pos) {
        double scale = 0.0625;
        return this.surfaceDepthNoise2.func_215460_a((double)pos.func_177958_n() * scale, (double)pos.func_177952_p() * scale, scale, (double)pos.func_177956_o() * scale) * 15.0;
    }

    public int func_205470_d() {
        return this.func_222530_f() + 1;
    }

    public int func_222530_f() {
        return this.genSettings.sphereMidY;
    }

    public int correctYValue(int yIn) {
        int seaLevelDiff = this.func_222530_f() - 63;
        int newY = yIn - seaLevelDiff;
        return Math.max(0, newY);
    }

    public void func_225550_a_(BiomeManager biomeManager, IChunk chunkIn, GenerationStage.Carving genStage) {
        Sphere sphere = Sphere.getClosest(this.field_222540_a, chunkIn.func_76632_l().func_206849_h());
        IChunkWrapper newChunk = new IChunkWrapper(chunkIn, pos -> sphere.getDistanceToCenter((BlockPos)pos) > sphere.radius);
        super.func_225550_a_(biomeManager, (IChunk)newChunk, genStage);
    }
}

