/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.co.harryyoud.biospheres.BiosphereBiomeProvider;
import uk.co.harryyoud.biospheres.BiosphereChunkGenerator;
import uk.co.harryyoud.biospheres.config.BiosphereConfig;
import uk.co.harryyoud.biospheres.config.BiosphereGenSettingsSerializer;
import uk.co.harryyoud.biospheres.gui.CreateBiospheresWorldScreen;

public class BiosphereWorldType
extends WorldType {
    public BiosphereWorldType() {
        super("biospheres");
    }

    public ChunkGenerator<?> createChunkGenerator(World world) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return super.createChunkGenerator(world);
        }
        OverworldBiomeProviderSettings biomeProvSettings = new OverworldBiomeProviderSettings(world.func_72912_H());
        BiosphereBiomeProvider biomeProv = new BiosphereBiomeProvider((IWorld)world, biomeProvSettings);
        BiosphereGenSettingsSerializer.BiosphereGenSettings settings = BiosphereGenSettingsSerializer.get(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)world.func_72912_H().func_211027_A()));
        return new BiosphereChunkGenerator((IWorld)world, biomeProv, settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        mc.func_147108_a((Screen)new CreateBiospheresWorldScreen(gui, gui.field_146334_a));
    }

    public String func_77128_b() {
        return "biospheres.generatorname";
    }

    public boolean func_205393_e() {
        return true;
    }

    public float getCloudHeight() {
        return BiosphereConfig.cloudHeight;
    }
}

