/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.co.harryyoud.biospheres.BiosphereWorldType;
import uk.co.harryyoud.biospheres.config.BiosphereConfig;
import uk.co.harryyoud.biospheres.config.BiosphereGenSettingsSerializer;

@Mod(value="biospheres")
public class Biospheres {
    public static final String MODID = "biospheres";
    public static final Logger LOGGER = LogManager.getLogger((String)"biospheres");
    public static final BiosphereWorldType worldType = new BiosphereWorldType();

    public Biospheres() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetup);
        BiosphereConfig.setup();
    }

    public void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        ServerProperties props = ((DedicatedServer)event.getServerSupplier().get()).func_213221_d_();
        if (!BiosphereConfig.shouldInjectWorldType) {
            System.out.println("World type injection disabled, not injecting biospheres world type");
            return;
        }
        if (props.field_219023_q != WorldType.field_77137_b) {
            System.out.println("World type injection enabled, but level-type is not default, aborting");
            return;
        }
        System.out.println(String.format("Biospheres injection is enabled, injecting biospheres level-type and generator-settings", new Object[0]));
        System.out.println(String.format("Original level-type=\"%s\"", props.field_219023_q.func_211888_a()));
        System.out.println(String.format("Original generator-settings=\"%s\"", props.field_219024_r));
        String newGenSettings = ((JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)((CompoundNBT)new BiosphereGenSettingsSerializer().toNBT(NBTDynamicOps.field_210820_a).getValue()))).toString();
        try {
            ObfuscationReflectionHelper.setPrivateValue(ServerProperties.class, (Object)props, (Object)((Object)worldType), (String)"field_219023_q");
            if (props.field_219024_r.isEmpty()) {
                ObfuscationReflectionHelper.setPrivateValue(ServerProperties.class, (Object)props, (Object)newGenSettings, (String)"field_219024_r");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new Error("Reflection failed when trying to edit the level-type and generator-settings properties", e);
        }
        Properties p = PropertyManager.func_218969_b((Path)Paths.get("server.properties", new String[0]));
        p.replace("level-type", "default", worldType.func_211888_a());
        p.replace("generator-settings", "", newGenSettings);
        props = new ServerProperties(p);
        props.func_218970_c(Paths.get("server.properties", new String[0]));
    }
}

