/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import java.util.Iterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;

public class BlockPosIterator
implements Iterable<BlockPos>,
Iterator<BlockPos> {
    private final BlockPos.Mutable pos;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public BlockPosIterator(ChunkPos chunkPos) {
        this.minX = chunkPos.func_180334_c();
        this.minY = 0;
        this.minZ = chunkPos.func_180333_d();
        this.maxX = chunkPos.func_180332_e();
        this.maxY = 255;
        this.maxZ = chunkPos.func_180330_f();
        this.pos = new BlockPos.Mutable(this.minX, this.minY, this.minZ);
    }

    public BlockPosIterator(SectionPos secPos) {
        this.minX = secPos.func_218161_d();
        this.minY = secPos.func_218151_e();
        this.minZ = secPos.func_218164_f();
        this.maxX = secPos.func_218152_g();
        this.maxY = secPos.func_218165_h();
        this.maxZ = secPos.func_218143_r();
        this.pos = new BlockPos.Mutable(this.minX, this.minY, this.minZ);
    }

    @Override
    public boolean hasNext() {
        boolean xIsMax = this.pos.func_177958_n() == this.maxX;
        boolean yIsMax = this.pos.func_177956_o() == this.maxY;
        boolean zIsMax = this.pos.func_177952_p() == this.maxZ;
        return !xIsMax || !yIsMax || !zIsMax;
    }

    @Override
    public BlockPos next() {
        BlockPos ret = this.pos.func_185334_h();
        if (this.pos.func_177952_p() < this.maxZ) {
            this.pos.func_223472_q(this.pos.func_177952_p() + 1);
            return ret;
        }
        if (this.pos.func_177956_o() < this.maxY) {
            this.pos.func_185336_p(this.pos.func_177956_o() + 1);
            this.pos.func_223472_q(this.minZ);
            return ret;
        }
        if (this.pos.func_177958_n() < this.maxX) {
            this.pos.func_223471_o(this.pos.func_177958_n() + 1);
            this.pos.func_185336_p(this.minY);
            this.pos.func_223472_q(this.minZ);
            return ret;
        }
        return null;
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return this;
    }
}

