/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import uk.co.harryyoud.biospheres.BiosphereBiomeProvider;
import uk.co.harryyoud.biospheres.BiosphereChunkGenerator;
import uk.co.harryyoud.biospheres.Utils;

public class Sphere {
    private final IWorld world;
    private final BlockPos centre;
    private final ChunkPos centreChunk;
    private final Random rnd;
    private final Biome biome;
    static int minRadius;
    static int maxRadius;
    static int midY;
    public final int radius;
    public static final int gridSize = 15;
    private HashMap<Direction, BlockPos> bridgeJoin = new HashMap();
    private ArrayList<MutableBoundingBox> domeCutouts = new ArrayList();
    public static Map<BlockPos, Sphere> sphereCache;

    private Sphere(IWorld world, BlockPos centrePos) {
        this.world = world;
        this.centre = centrePos;
        this.centreChunk = new ChunkPos(centrePos);
        this.rnd = new Random((long)centrePos.hashCode() * world.func_72905_C());
        this.biome = this.getRandomBiome(this.rnd);
        this.radius = this.rnd.nextInt(maxRadius - minRadius + 1) + minRadius;
    }

    public static Sphere fromCentre(IWorld worldIn, BlockPos centrePos) {
        if (sphereCache.containsKey(centrePos)) {
            return sphereCache.get(centrePos);
        }
        Sphere sphere = new Sphere(worldIn, centrePos);
        sphereCache.put(centrePos, sphere);
        return sphere;
    }

    public static Sphere fromCentreChunk(IWorld worldIn, ChunkPos chunkPos) {
        BlockPos pos = chunkPos.func_180331_a(8, midY, 8);
        return Sphere.fromCentre(worldIn, pos);
    }

    public static Sphere getClosest(IWorld worldIn, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkOffsetX = (int)Math.floor(Math.IEEEremainder(chunkPos.field_77276_a, 15.0));
        int chunkOffsetZ = (int)Math.floor(Math.IEEEremainder(chunkPos.field_77275_b, 15.0));
        return Sphere.fromCentreChunk(worldIn, new ChunkPos(chunkPos.field_77276_a - chunkOffsetX, chunkPos.field_77275_b - chunkOffsetZ));
    }

    private Biome getRandomBiome(Random rnd) {
        Biome biome = BiosphereBiomeProvider.biomesArray[rnd.nextInt(BiosphereBiomeProvider.biomesArray.length)];
        return biome;
    }

    public int getDistanceToCenter(BlockPos pos) {
        return (int)Math.floor(Math.sqrt(this.getCentre().func_218140_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false)));
    }

    public Random getRandom() {
        return this.rnd;
    }

    public ChunkPos getCentreChunk() {
        return this.centreChunk;
    }

    public BlockPos getCentre() {
        return this.centre;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public BlockPos computeBridgeJoin(BiosphereChunkGenerator chunkGen, Direction dir) {
        double[][][] noisesFrom;
        ChunkPos joinChunk;
        int domeHeight;
        BlockPos fromCache = this.bridgeJoin.get(dir);
        if (fromCache != null) {
            return fromCache;
        }
        BlockPos.Mutable join = new BlockPos.Mutable(this.getCentre()).func_189534_c(dir, this.radius);
        do {
            join.func_189534_c(dir.func_176734_d(), 1);
            joinChunk = new ChunkPos((BlockPos)join);
            noisesFrom = chunkGen.getNoiseForChunk(this.world, joinChunk);
            domeHeight = midY + (int)Math.round(Math.sqrt(Math.abs(Math.pow(this.radius, 2.0) - Math.pow(Utils.getCoord(this.getCentre(), dir.func_176740_k()) - Utils.getCoord((BlockPos)join, dir.func_176740_k()), 2.0))));
            join.func_185336_p(Utils.topBlockFromNoise(noisesFrom, Math.abs(join.func_177958_n()) % 16, Math.abs(join.func_177952_p()) % 16, domeHeight, chunkGen.func_222530_f(), i -> chunkGen.correctYValue(i)));
        } while (Utils.getCoord(this.getCentre(), dir.func_176740_k()) != Utils.getCoord((BlockPos)join, dir.func_176740_k()) && join.func_177956_o() >= domeHeight);
        join.func_189534_c(dir, 1);
        joinChunk = new ChunkPos((BlockPos)join);
        noisesFrom = chunkGen.getNoiseForChunk(this.world, joinChunk);
        domeHeight = midY + (int)Math.round(Math.sqrt(Math.abs(Math.pow(this.radius, 2.0) - Math.pow(Utils.getCoord(this.getCentre(), dir.func_176740_k()) - Utils.getCoord((BlockPos)join, dir.func_176740_k()), 2.0))));
        if (domeHeight < midY + 3) {
            domeHeight = midY + 10;
        }
        join.func_185336_p(Utils.topBlockFromNoise(noisesFrom, Math.abs(join.func_177958_n()) % 16, Math.abs(join.func_177952_p()) % 16, domeHeight, chunkGen.func_222530_f(), i -> chunkGen.correctYValue(i)));
        BlockPos joinIm = join.func_185334_h();
        this.bridgeJoin.put(dir, joinIm);
        BlockPos.Mutable one = new BlockPos.Mutable(joinIm);
        BlockPos.Mutable two = new BlockPos.Mutable(joinIm);
        one.func_189534_c(dir.func_176746_e(), chunkGen.BRIDGE_WIDTH).func_189536_c(Direction.UP);
        two.func_189534_c(dir.func_176735_f(), chunkGen.BRIDGE_WIDTH);
        two.func_189534_c(dir.func_176734_d(), Math.abs(Utils.getCoord(joinIm, dir.func_176740_k()) - Utils.getCoord(this.getCentre(), dir.func_176740_k())));
        two.func_189534_c(Direction.UP, chunkGen.BRIDGE_HEIGHT);
        this.domeCutouts.add(new MutableBoundingBox((Vec3i)one, (Vec3i)two));
        return joinIm;
    }

    public HashMap<Direction, BlockPos> getBridgeJoins() {
        return this.getBridgeJoins();
    }

    public ArrayList<MutableBoundingBox> getCutouts() {
        return this.domeCutouts;
    }

    static {
        sphereCache = new LinkedHashMap<BlockPos, Sphere>(500, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<BlockPos, Sphere> eldest) {
                return this.size() > 500;
            }
        };
    }
}

