/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres;

import java.util.function.IntFunction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class Utils {
    public static int topBlockFromNoise(double[][][] noise, int x, int z, int topLimit, int bottomLimit, IntFunction<Integer> yCorrection) {
        for (int y = topLimit; y >= bottomLimit; --y) {
            if (!(noise[x][yCorrection.apply(y)][z] > 0.0)) continue;
            return y;
        }
        return bottomLimit - 1;
    }

    public static int getCoord(BlockPos pos, Direction.Axis axis) {
        return axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static ChunkPos moveChunk(ChunkPos chunkPos, Direction dir, int amount) {
        switch (dir) {
            case NORTH: {
                return new ChunkPos(chunkPos.field_77276_a, chunkPos.field_77275_b - amount);
            }
            case SOUTH: {
                return new ChunkPos(chunkPos.field_77276_a, chunkPos.field_77275_b + amount);
            }
            case WEST: {
                return new ChunkPos(chunkPos.field_77276_a - amount, chunkPos.field_77275_b);
            }
            case EAST: {
                return new ChunkPos(chunkPos.field_77276_a + amount, chunkPos.field_77275_b);
            }
        }
        throw new IllegalStateException("Unable to get offset chunk in Y direction");
    }

    public static boolean inIncRange(int num, int range1, int range2) {
        return Math.min(range1, range2) <= num && num <= Math.max(range1, range2);
    }
}

