/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres.config;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import uk.co.harryyoud.biospheres.config.serializers.BlockStateSerializer;

@Mod.EventBusSubscriber(modid="biospheres", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiosphereConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final GeneralConfig GENERAL;
    public static final ForgeConfigSpec DEFAULT_PER_WORLD_SPEC;
    public static final DefaultPerWorldConfig DEFAULT_PER_WORLD;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static boolean shouldInjectWorldType;
    public static float cloudHeight;
    public static List<String> bannedBiomes;
    public static List<Biome.Category> bannedBiomeCategories;
    public static List<BlockState> bannedBlocks;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path ourConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "biospheres");
        try {
            Files.createDirectory(ourConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            System.out.println("Failed to create biospheres config directory");
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GENERAL_SPEC, "biospheres/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DEFAULT_PER_WORLD_SPEC, "biospheres/world-generation-defaults.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC, "biospheres/client.toml");
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == GENERAL_SPEC) {
            BiosphereConfig.bakeGeneralConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            BiosphereConfig.bakeClientConfig();
        }
    }

    public static void bakeGeneralConfig() {
        shouldInjectWorldType = (Boolean)BiosphereConfig.GENERAL.shouldInjectWorldType.get();
        bannedBiomes = (List)BiosphereConfig.GENERAL.bannedBiomes.get();
        bannedBiomeCategories = ((List)BiosphereConfig.GENERAL.bannedBiomeCategories.get()).stream().map(cat -> Biome.Category.valueOf((String)cat)).collect(Collectors.toList());
    }

    public static void bakeClientConfig() {
        cloudHeight = ((Integer)BiosphereConfig.CLIENT.cloudHeight.get()).intValue();
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(GeneralConfig::new);
        GENERAL = (GeneralConfig)commonSpecPair.getLeft();
        GENERAL_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        Pair worldGenSpecPair = new ForgeConfigSpec.Builder().configure(DefaultPerWorldConfig::new);
        DEFAULT_PER_WORLD = (DefaultPerWorldConfig)worldGenSpecPair.getLeft();
        DEFAULT_PER_WORLD_SPEC = (ForgeConfigSpec)worldGenSpecPair.getRight();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.IntValue cloudHeight;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.cloudHeight = builder.comment("Cloud height\nUseful for when spheres are high up and/or big").translation("biospheres.config.cloudHeight").defineInRange("cloudHeight", 255, 0, 256);
        }
    }

    public static class GeneralConfig {
        public final ForgeConfigSpec.BooleanValue shouldInjectWorldType;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bannedBiomes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bannedBiomeCategories;

        public GeneralConfig(ForgeConfigSpec.Builder builder) {
            this.shouldInjectWorldType = builder.comment("Inject level-type on dedicated server startup. Won't do anything on a client.").translation("biospheres.config.shouldInjectWorldType").define("shouldInjectWorldType", true);
            builder.push("biomes");
            this.bannedBiomes = builder.comment("Don't use these biomes").defineList("bannedBiomes", new ArrayList(), s -> ForgeRegistries.BIOMES.containsKey(new ResourceLocation((String)s)));
            this.bannedBiomeCategories = builder.comment("Don't use these biome categories").defineList("bannedBiomeCategories", Arrays.asList(Biome.Category.THEEND.toString(), Biome.Category.NETHER.toString()), this::validateBiomeCategory);
            builder.pop();
        }

        private boolean validateBiomeCategory(Object obj) {
            try {
                String s = (String)obj;
                Biome.Category.valueOf((String)s);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    public static class DefaultPerWorldConfig {
        public final ForgeConfigSpec.IntValue sphereMidY;
        public final ForgeConfigSpec.IntValue sphereMinRadius;
        public final ForgeConfigSpec.IntValue sphereMaxRadius;
        public final ForgeConfigSpec.ConfigValue<String> domeBlock;
        public final ForgeConfigSpec.ConfigValue<String> outsideFillerBlock;
        public final ForgeConfigSpec.ConfigValue<String> bridgeBlock;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bannedBlocks;

        public DefaultPerWorldConfig(ForgeConfigSpec.Builder builder) {
            builder.push("spheres");
            this.sphereMidY = builder.comment("Sea level (aka vertical midpoint of spheres)\nThis should be between sphereMaxRadius and (256 - sphereMaxRadius)").defineInRange("sphereMidY", 100, 0, 255);
            this.sphereMinRadius = builder.comment("Minimum sphere radius").defineInRange("sphereMinRadius", 40, 15, 100);
            this.sphereMaxRadius = builder.comment("Maximum sphere radius").defineInRange("sphereMaxRadius", 100, 15, 100);
            builder.pop();
            builder.push("blocks");
            this.domeBlock = builder.comment("Block to use for the dome").define("domeBlock", (Object)new BlockStateSerializer().serialize(Blocks.field_196807_gj.func_176223_P()), new BlockStateSerializer()::validate);
            this.outsideFillerBlock = builder.comment("Block to use for outside the spheres").define("outsideFillerBlock", (Object)new BlockStateSerializer().serialize(Blocks.field_150350_a.func_176223_P()), new BlockStateSerializer()::validate);
            this.bridgeBlock = builder.comment("Block to use for the bridges between spheres").define("bridgeBlock", (Object)new BlockStateSerializer().serialize(Blocks.field_196662_n.func_176223_P()), new BlockStateSerializer()::validate);
            this.bannedBlocks = builder.comment("Blocks to always replace with dome blocks if at the radius").defineList("bannedBlocks", Arrays.asList(new BlockStateSerializer().serialize(Blocks.field_150350_a.func_176223_P()), new BlockStateSerializer().serialize(Blocks.field_150355_j.func_176223_P()), new BlockStateSerializer().serialize(Blocks.field_150353_l.func_176223_P())), new BlockStateSerializer()::validate);
            builder.pop();
        }
    }
}

