/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres.config;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.OverworldGenSettings;
import uk.co.harryyoud.biospheres.config.BiosphereConfig;
import uk.co.harryyoud.biospheres.config.serializers.BlockStateSerializer;
import uk.co.harryyoud.biospheres.config.serializers.ISerializer;
import uk.co.harryyoud.biospheres.config.serializers.IntegerSerializer;

public class BiosphereGenSettingsSerializer {
    private static Map<String, ISerializer<?>> OPTIONS = ImmutableMap.builder().put((Object)"domeBlock", (Object)new BlockStateSerializer()).put((Object)"bridgeBlock", (Object)new BlockStateSerializer()).put((Object)"outsideFillerBlock", (Object)new BlockStateSerializer()).put((Object)"sphereMidY", (Object)new IntegerSerializer().addInRange(0, 255)).put((Object)"sphereMinRadius", (Object)new IntegerSerializer().addInRange(15, 100)).put((Object)"sphereMaxRadius", (Object)new IntegerSerializer().addInRange(15, 100)).build();
    private Map<String, String> values = new HashMap<String, String>();

    public BiosphereGenSettingsSerializer() {
        this.values.put("domeBlock", (String)BiosphereConfig.DEFAULT_PER_WORLD.domeBlock.get());
        this.values.put("bridgeBlock", (String)BiosphereConfig.DEFAULT_PER_WORLD.bridgeBlock.get());
        this.values.put("outsideFillerBlock", (String)BiosphereConfig.DEFAULT_PER_WORLD.outsideFillerBlock.get());
        this.values.put("sphereMidY", ((Integer)BiosphereConfig.DEFAULT_PER_WORLD.sphereMidY.get()).toString());
        this.values.put("sphereMinRadius", ((Integer)BiosphereConfig.DEFAULT_PER_WORLD.sphereMinRadius.get()).toString());
        this.values.put("sphereMaxRadius", ((Integer)BiosphereConfig.DEFAULT_PER_WORLD.sphereMaxRadius.get()).toString());
    }

    public static BiosphereGenSettingsSerializer fromNBT(Dynamic<?> in) {
        BiosphereGenSettingsSerializer settings = new BiosphereGenSettingsSerializer();
        for (Map.Entry<String, ISerializer<?>> entry : OPTIONS.entrySet()) {
            ISerializer<?> serializer;
            String key = entry.getKey();
            String val = (serializer = entry.getValue()) instanceof IntegerSerializer ? String.valueOf(in.get(key).asInt(-1)) : in.get(key).asString("");
            if (!serializer.validate(val)) continue;
            settings.set(key, val);
        }
        return settings;
    }

    public <T> Dynamic<T> toNBT(DynamicOps<T> in) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<String, ISerializer<?>> entry : OPTIONS.entrySet()) {
            Object val = entry.getValue() instanceof IntegerSerializer ? in.createInt(Integer.valueOf(this.get(entry.getKey())).intValue()) : in.createString(this.get(entry.getKey()));
            map.put(in.createString(entry.getKey()), val);
        }
        return new Dynamic(in, in.createMap(map));
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public Predicate<String> getValidator(String key) {
        return OPTIONS.get(key)::validate;
    }

    public ISerializer<?> getSerializer(String key) {
        return OPTIONS.get(key);
    }

    public Object getValue(String key) {
        return this.getSerializer(key).deserialize(this.get(key));
    }

    public Map<String, ISerializer<?>> getSerializers() {
        return OPTIONS;
    }

    public void set(String key, String value) {
        if (!this.values.containsKey(key)) {
            return;
        }
        this.values.put(key, value);
    }

    public static BiosphereGenSettings get(Dynamic<?> in) {
        BiosphereGenSettingsSerializer serializer;
        BiosphereGenSettingsSerializer biosphereGenSettingsSerializer = serializer = BiosphereGenSettingsSerializer.fromNBT(in);
        biosphereGenSettingsSerializer.getClass();
        return biosphereGenSettingsSerializer.new BiosphereGenSettings();
    }

    public class BiosphereGenSettings
    extends OverworldGenSettings {
        public final BlockState domeBlock;
        public final BlockState bridgeBlock;
        public final BlockState outsideFillerBlock;
        public final int sphereMidY;
        public final int sphereMinRadius;
        public final int sphereMaxRadius;

        private BiosphereGenSettings() {
            this.domeBlock = (BlockState)BiosphereGenSettingsSerializer.this.getValue("domeBlock");
            this.bridgeBlock = (BlockState)BiosphereGenSettingsSerializer.this.getValue("bridgeBlock");
            this.outsideFillerBlock = (BlockState)BiosphereGenSettingsSerializer.this.getValue("outsideFillerBlock");
            this.sphereMidY = (Integer)BiosphereGenSettingsSerializer.this.getValue("sphereMidY");
            this.sphereMinRadius = (Integer)BiosphereGenSettingsSerializer.this.getValue("sphereMinRadius");
            this.sphereMaxRadius = (Integer)BiosphereGenSettingsSerializer.this.getValue("sphereMaxRadius");
        }
    }
}

