/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres.config.serializers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.state.IProperty;
import net.minecraft.util.Util;
import uk.co.harryyoud.biospheres.config.serializers.ISerializer;

public class BlockStateSerializer
implements ISerializer<BlockState> {
    @Override
    public String serialize(BlockState state) {
        String stateString = state.func_177230_c().getRegistryName().toString();
        ArrayList<String> properties = new ArrayList<String>();
        for (Map.Entry entry : state.func_206871_b().entrySet()) {
            IProperty property = (IProperty)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            properties.add(property.func_177701_a() + "=" + Util.func_200269_a((IProperty)property, (Object)value));
        }
        if (!properties.isEmpty()) {
            stateString = stateString + "[";
            stateString = stateString + String.join((CharSequence)",", properties);
            stateString = stateString + "]";
        }
        return stateString;
    }

    @Override
    public BlockState deserialize(String s) {
        try {
            return new BlockStateArgument().parse(new StringReader(s)).func_197231_a();
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Couldn't parse blockstate");
        }
    }

    @Override
    public boolean validate(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        try {
            new BlockStateArgument().parse(new StringReader(s));
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    @Override
    public Object[] getInvalidString() {
        return new Object[]{"biospheres.gui.block.invalid"};
    }
}

