/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harryyoud.biospheres.gui;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import uk.co.harryyoud.biospheres.config.BiosphereGenSettingsSerializer;
import uk.co.harryyoud.biospheres.config.serializers.ISerializer;
import uk.co.harryyoud.biospheres.gui.ScrollingOptionsList;

public class CreateBiospheresWorldScreen
extends Screen {
    private BiosphereGenSettingsSerializer generatorInfo = new BiosphereGenSettingsSerializer();
    private final CreateWorldScreen createWorldGui;
    private ScrollingOptionsList optionsList;

    public CreateBiospheresWorldScreen(CreateWorldScreen parent, CompoundNBT generatorOptions) {
        super((ITextComponent)new TranslationTextComponent("biospheres.gui.title", new Object[0]));
        this.createWorldGui = parent;
        this.loadGeneratorOptions(generatorOptions);
    }

    public CompoundNBT getGeneratorOptions() {
        return (CompoundNBT)this.generatorInfo.toNBT(NBTDynamicOps.field_210820_a).getValue();
    }

    public void loadGeneratorOptions(CompoundNBT nbt) {
        this.generatorInfo = BiosphereGenSettingsSerializer.fromNBT(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt));
    }

    protected void init() {
        this.optionsList = new ScrollingOptionsList(this, this.minecraft, this.width, this.height);
        this.children.add(this.optionsList);
        this.initOptions();
        this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_213010_1_ -> {
            this.createWorldGui.field_146334_a = this.getGeneratorOptions();
            this.minecraft.func_147108_a((Screen)this.createWorldGui);
        }));
        this.addButton((Widget)new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), p_213009_1_ -> this.minecraft.func_147108_a((Screen)this.createWorldGui)));
    }

    protected void initOptions() {
        for (Map.Entry<String, ISerializer<?>> entry : this.generatorInfo.getSerializers().entrySet()) {
            String key = entry.getKey();
            String label = "biospheres.gui." + key + ".label";
            this.optionsList.create().setTitle(label, new Object[0]).setMessage(label).setText(this.generatorInfo.get(key)).setInvalidString(this.generatorInfo.getSerializer(key).getInvalidString()).setResponder(s -> this.generatorInfo.set(key, (String)s)).setValidator(this.generatorInfo.getValidator(key)).setFieldValidator(this.generatorInfo.getSerializer(key)::validateField);
        }
    }

    public void onClose() {
        this.minecraft.func_147108_a((Screen)this.createWorldGui);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.optionsList.render(p_render_1_, p_render_2_, p_render_3_);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    FontRenderer getFont() {
        return this.font;
    }

    public void tick() {
        this.optionsList.tick();
    }
}

