/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import newBiospheresMod.BiosphereMapGen;
import newBiospheresMod.BlockEntry;
import newBiospheresMod.Configuration.ModConfig;
import newBiospheresMod.Helpers.AvgCalc;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;
import newBiospheresMod.Helpers.ModConsts;
import newBiospheresMod.Helpers.Predicate;
import newBiospheresMod.Helpers.TopDownBoundingBox;
import newBiospheresMod.Helpers.Utils;
import newBiospheresMod.Models.Sphere;
import newBiospheresMod.Models.SphereChunk;

public class BiosphereChunkProvider
implements IChunkProvider {
    private static LruCacheList<BiosphereChunkProvider> chunkProviders = new LruCacheList<BiosphereChunkProvider>(3, new IKeyProvider<BiosphereChunkProvider>(){

        @Override
        public Object provideKey(BiosphereChunkProvider item) {
            if (item == null) {
                return null;
            }
            return item.world;
        }
    });
    LruCacheList<Chunk> ChunksCache = new LruCacheList<Chunk>(15, new IKeyProvider<Chunk>(){

        @Override
        public Object provideKey(Chunk item) {
            if (item == null) {
                return 0;
            }
            if (!item.field_76636_d) {
                return 0;
            }
            return new ChunkCacheKey(item.field_76637_e, item.field_76635_g, item.field_76647_h);
        }
    });
    public final World world;
    public final ModConfig config;
    public final NoiseGeneratorOctaves noiseGenerator;
    public final long worldSeed;
    private final MapGenBase caveGen = new BiosphereMapGen();
    private static final AvgCalc avg = new AvgCalc();
    private static long lastPrintedAt = Long.MIN_VALUE;

    public static BiosphereChunkProvider get(final World world) {
        return chunkProviders.FindOrAdd(world, new Creator<BiosphereChunkProvider>(){

            @Override
            public BiosphereChunkProvider create() {
                return new BiosphereChunkProvider(world);
            }
        });
    }

    private BiosphereChunkProvider(World world) {
        this.world = world;
        this.worldSeed = world.func_72905_C();
        this.config = ModConfig.get(world);
        this.config.update();
        this.noiseGenerator = this.config.isNoiseEnabled() ? new NoiseGeneratorOctaves(new Random(this.worldSeed), 4) : null;
    }

    private SphereChunk GenerateChunk(int chunkX, int chunkZ, Block[] blocks) {
        Arrays.fill(blocks, this.config.getOutsideFillerBlock());
        SphereChunk chunk = SphereChunk.get(this, chunkX, chunkZ);
        if (chunk != null && chunk.masterSphere != null) {
            Sphere sphere = chunk.masterSphere;
            final TopDownBoundingBox chunkBox = TopDownBoundingBox.FromChunk(chunkX, chunkZ);
            if (Utils.Any(Utils.Where(sphere.getBoundingBoxes(), new Predicate<TopDownBoundingBox>(){

                @Override
                public boolean test(TopDownBoundingBox box) {
                    return chunkBox.CollidesWith(box);
                }
            }))) {
                this.GenerateChunkInner(chunkX, chunkZ, blocks, chunk);
            }
        }
        return chunk;
    }

    private void GenerateChunkInner(int chunkX, int chunkZ, Block[] blocks, SphereChunk chunk) {
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        int bridgeWidth = this.config.getBridgeWidth();
        Block outsideFillerBlock = this.config.getOutsideFillerBlock();
        Sphere sphere = chunk.masterSphere;
        Random rnd = chunk.GetPhaseRandom("GenerateChunk");
        for (int zo = 0; zo < 16; ++zo) {
            for (int xo = 0; xo < 16; ++xo) {
                int midY = chunk.getChunkBoundSurfaceLevel(xo, zo);
                for (int rawY = 255; rawY >= 0; --rawY) {
                    Block stairwayBlock;
                    int idx = ModConsts.GetChunkArrayIndex(xo, rawY, zo);
                    Block block = Blx.air;
                    int rawX = baseX + xo;
                    int rawZ = baseZ + zo;
                    int sphereDistance = sphere.getMainDistance(rawX, rawY, rawZ);
                    int orbDistance = sphere.getOrbDistance(rawX, rawY, rawZ);
                    int lakeDistance = sphere.getLakeDistance(rawX, rawY, rawZ);
                    if (sphereDistance > sphere.scaledSphereRadius && (stairwayBlock = sphere.getOrbStairwayBlock(rawX, rawY, rawZ)) != null) {
                        block = stairwayBlock;
                    }
                    if (rawY > midY) {
                        if (sphere.scaledSphereRadius == sphereDistance) {
                            if (rawY >= midY + 4 || Math.abs(rawX - sphere.sphereLocation.field_71574_a) > bridgeWidth && Math.abs(rawZ - sphere.sphereLocation.field_71573_c) > bridgeWidth) {
                                block = sphere.getDomeBlock(rawX, rawY, rawZ);
                            }
                        } else if (sphere.hasLake && this.config.isNoiseEnabled() && sphere.biome != BiomeGenBase.field_76769_d && lakeDistance > sphere.scaledLakeRadius && lakeDistance <= sphere.scaledLakeEdgeRadius) {
                            if (rawY == sphere.lakeLocation.field_71572_b) {
                                block = sphere.biome.field_76752_A;
                            } else if (rawY < sphere.lakeLocation.field_71572_b) {
                                block = sphere.biome.field_76753_B;
                            }
                        } else if (sphere.hasLake && this.config.isNoiseEnabled() && sphere.biome != BiomeGenBase.field_76769_d && lakeDistance <= sphere.scaledLakeRadius) {
                            if (rawY == sphere.lakeLocation.field_71572_b && sphere.biome == BiomeGenBase.field_76774_n) {
                                block = Blx.ice;
                            } else if (rawY <= sphere.lakeLocation.field_71572_b) {
                                block = sphere.GetLakeBlock();
                            }
                        } else if (this.config.doesNeedProtectionGlass() && rawY <= midY + 4 && sphereDistance > sphere.scaledSphereRadius && (Math.abs(rawX - sphere.sphereLocation.field_71574_a) == bridgeWidth || Math.abs(rawZ - sphere.sphereLocation.field_71573_c) == bridgeWidth)) {
                            block = sphere.getDomeBlock(rawX, rawY, rawZ);
                        } else if (this.config.doesNeedProtectionGlass() && rawY == midY + 4 && sphereDistance > sphere.scaledSphereRadius && (Math.abs(rawX - sphere.sphereLocation.field_71574_a) < bridgeWidth || Math.abs(rawZ - sphere.sphereLocation.field_71573_c) < bridgeWidth)) {
                            block = sphere.getDomeBlock(rawX, rawY, rawZ);
                        } else if (this.config.doesNeedProtectionGlass() && rawY < midY + 4 && sphereDistance > sphere.scaledSphereRadius && (Math.abs(rawX - sphere.sphereLocation.field_71574_a) < bridgeWidth || Math.abs(rawZ - sphere.sphereLocation.field_71573_c) < bridgeWidth)) {
                            block = Blx.air;
                        } else if (this.config.doesNeedProtectionGlass() && sphereDistance > sphere.scaledSphereRadius) {
                            block = outsideFillerBlock;
                        } else if (rawY == midY + 1 && sphereDistance > sphere.scaledSphereRadius && (Math.abs(rawX - sphere.sphereLocation.field_71574_a) == bridgeWidth || Math.abs(rawZ - sphere.sphereLocation.field_71573_c) == bridgeWidth)) {
                            block = this.config.getBridgeRailBlock();
                        }
                    } else if (sphere.scaledSphereRadius == sphereDistance) {
                        block = Blx.stone;
                    } else if (sphere.hasLake && sphere.biome != BiomeGenBase.field_76769_d && lakeDistance <= sphere.scaledLakeRadius) {
                        if (rawY == sphere.lakeLocation.field_71572_b && sphere.biome == BiomeGenBase.field_76774_n) {
                            block = Blx.ice;
                        } else if (rawY <= sphere.lakeLocation.field_71572_b) {
                            block = sphere.GetLakeBlock();
                        }
                    } else if (sphere.hasLake && rawY < sphere.lakeLocation.field_71572_b - 1 && sphere.biome != BiomeGenBase.field_76769_d && lakeDistance <= sphere.scaledLakeEdgeRadius) {
                        block = sphere.lavaLake ? Blx.gravel : Blx.sand;
                    } else if (sphereDistance < sphere.scaledSphereRadius) {
                        block = rawY == midY ? sphere.biome.field_76752_A : (rawY == midY - 1 ? sphere.biome.field_76753_B : Blx.stone);
                    } else if (rawY == midY && sphereDistance > sphere.scaledSphereRadius && (Math.abs(rawX - sphere.sphereLocation.field_71574_a) < bridgeWidth + 1 || Math.abs(rawZ - sphere.sphereLocation.field_71573_c) < bridgeWidth + 1)) {
                        block = this.config.getBridgeSupportBlock();
                    } else if (this.config.doesNeedProtectionGlass() && sphereDistance > sphere.scaledSphereRadius) {
                        block = outsideFillerBlock;
                    }
                    if (sphere.scaledOrbRadius == orbDistance) {
                        block = this.config.getOrbBlock();
                    } else if (orbDistance < sphere.scaledOrbRadius) {
                        block = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, this.config.OreOrbBlocks)).Block;
                    }
                    blocks[idx] = block;
                }
            }
        }
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public Chunk func_73154_d(final int x, final int z) {
        return this.ChunksCache.FindOrAdd(new ChunkCacheKey(this.world, x, z), new Creator<Chunk>(){

            @Override
            public Chunk create() {
                return BiosphereChunkProvider.this.GenerateNewChunk(x, z);
            }
        });
    }

    private Chunk GenerateNewChunk(int x, int z) {
        long startedAt = System.currentTimeMillis();
        Block[] blocks = new Block[ModConsts.GetChunkArraySize()];
        byte[] metadata = new byte[ModConsts.GetChunkArraySize()];
        SphereChunk sphereChunk = this.GenerateChunk(x, z, blocks);
        this.caveGen.func_151539_a((IChunkProvider)this, this.world, x, z, blocks);
        Chunk chunk = new Chunk(this.world, blocks, metadata, x, z);
        chunk.func_76603_b();
        if (sphereChunk != null && sphereChunk.masterSphere != null && sphereChunk.masterSphere.biome != null) {
            byte[] biomes = new byte[256];
            Arrays.fill(biomes, (byte)(sphereChunk.masterSphere.biome.field_76756_M & 0xFF));
            chunk.func_76616_a(biomes);
        }
        long now = System.currentTimeMillis();
        long elapsed = now - startedAt;
        avg.addValue((double)elapsed / 1000.0);
        if (elapsed >= 100L) {
            System.out.printf("WARNING: BIOSPHERE GENERATE NEW CHUNK @ [%d, %d] TOOK %.3f SECONDS!%n", x, z, (double)elapsed / 1000.0);
        }
        if (lastPrintedAt == Long.MIN_VALUE || now - lastPrintedAt > 2500L) {
            double av;
            lastPrintedAt = now;
            if (avg.getCount() >= 5 && (av = avg.getAverage()) >= 0.02) {
                System.out.printf("INFO: BIOSPHERE GENERATE NEW CHUNK ON AVERAGE TAKES %.3f SECONDS.%n", av);
            }
        }
        return chunk;
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        int x;
        int i;
        int z;
        int y;
        int y2;
        int x2;
        int i2;
        int z2;
        int y3;
        int x3;
        int i3;
        SphereChunk chunk = SphereChunk.get(this, chunkX, chunkZ);
        Sphere sphere = chunk.masterSphere;
        Random rnd = chunk.GetPhaseRandom("populate");
        BlockSand.field_149832_M = true;
        int absX = chunkX << 4;
        int absZ = chunkZ << 4;
        for (i3 = 0; i3 < 10; ++i3) {
            x3 = absX + rnd.nextInt(16);
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16);
            new WorldGenClay(4).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            x3 = absX + rnd.nextInt(16);
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16);
            new WorldGenMinable(Blx.coal_ore, 16).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            x3 = absX + rnd.nextInt(16);
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16);
            new WorldGenMinable(Blx.iron_ore, 8).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        for (i3 = 0; i3 < 2; ++i3) {
            x3 = absX + rnd.nextInt(16);
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16);
            new WorldGenMinable(Blx.gold_ore, 8).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        for (i3 = 0; i3 < 8; ++i3) {
            x3 = absX + rnd.nextInt(16);
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16);
            new WorldGenMinable(Blx.redstone_ore, 7).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        int treesPerChunk = sphere.biome.field_76760_I.field_76832_z;
        if (rnd.nextInt(10) == 0) {
            ++treesPerChunk;
        }
        for (i2 = 0; i2 < treesPerChunk; ++i2) {
            x2 = absX + rnd.nextInt(16) + 8;
            z2 = absZ + rnd.nextInt(16) + 8;
            y2 = this.world.func_72976_f(x2, z2);
            WorldGenAbstractTree gen = sphere.biome.func_150567_a(rnd);
            gen.func_76487_a((double)this.config.getScale(), (double)this.config.getScale(), (double)this.config.getScale());
            gen.func_76484_a(this.world, rnd, x2, y2, z2);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            x2 = absX + rnd.nextInt(16) + 8;
            y = rnd.nextInt(256);
            z = absZ + rnd.nextInt(16) + 8;
            new WorldGenFlowers(Blx.yellow_flower).func_76484_a(this.world, rnd, x2, y, z);
        }
        if (rnd.nextInt(2) == 0) {
            x3 = absX + rnd.nextInt(16) + 8;
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16) + 8;
            new WorldGenFlowers(Blx.red_flower).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        if (rnd.nextInt(4) == 0) {
            x3 = absX + rnd.nextInt(16) + 8;
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16) + 8;
            new WorldGenFlowers(Blx.brown_mushroom).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        if (rnd.nextInt(8) == 0) {
            x3 = absX + rnd.nextInt(16) + 8;
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16) + 8;
            new WorldGenFlowers(Blx.red_mushroom).func_76484_a(this.world, rnd, x3, y3, z2);
        }
        if (this.config.isTallGrassEnabled()) {
            int grassPerChunk = sphere.biome.field_76760_I.field_76803_B;
            for (i = 0; i < grassPerChunk; ++i) {
                int metadata = 1;
                if (sphere.biome == BiomeGenBase.field_76769_d && rnd.nextInt(3) != 0) {
                    metadata = 2;
                }
                x = absX + rnd.nextInt(16) + 8;
                int y4 = rnd.nextInt(256);
                int z3 = absZ + rnd.nextInt(16) + 8;
                new WorldGenTallGrass(Blx.tallgrass, metadata).func_76484_a(this.world, rnd, x, y4, z3);
            }
        }
        for (i2 = 0; i2 < 20; ++i2) {
            x2 = absX + rnd.nextInt(16) + 8;
            y = rnd.nextInt(256);
            z = absZ + rnd.nextInt(16) + 8;
            new WorldGenReed().func_76484_a(this.world, rnd, x2, y, z);
        }
        if (rnd.nextInt(32) == 0) {
            x3 = absX + rnd.nextInt(16) + 8;
            y3 = rnd.nextInt(256);
            z2 = absZ + rnd.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(this.world, rnd, x3, y3, z2);
        }
        if (sphere.biome == BiomeGenBase.field_76769_d) {
            int count = rnd.nextInt(5);
            for (i = 0; i < count; ++i) {
                int x4 = absX + rnd.nextInt(16) + 8;
                z = absZ + rnd.nextInt(16) + 8;
                int y5 = this.world.func_72976_f(x4, z);
                new WorldGenCactus().func_76484_a(this.world, rnd, x4, y5, z);
            }
        } else if (sphere.biome == BiomeGenBase.field_76778_j) {
            if (rnd.nextBoolean()) {
                x3 = absX + rnd.nextInt(16) + 8;
                int z4 = absZ + rnd.nextInt(16) + 8;
                y = this.world.func_72976_f(x3, z4);
                new WorldGenFire().func_76484_a(this.world, rnd, x3, y, z4);
            }
        } else if (sphere.biome == BiomeGenBase.field_76789_p) {
            for (i2 = 0; i2 < 2; ++i2) {
                x2 = absX + rnd.nextInt(16) + 8;
                z2 = absZ + rnd.nextInt(16) + 8;
                y2 = this.world.func_72976_f(x2, z2);
                new WorldGenBigMushroom().func_76484_a(this.world, rnd, x2, y2, z2);
            }
            for (i2 = 0; i2 < 1; ++i2) {
                if (rnd.nextInt(4) == 0) {
                    x2 = absX + rnd.nextInt(16) + 8;
                    z2 = absZ + rnd.nextInt(16) + 8;
                    y2 = this.world.func_72976_f(x2, z2);
                    new WorldGenFlowers(Blx.yellow_flower).func_76484_a(this.world, rnd, x2, y2, z2);
                }
                if (rnd.nextInt(8) != 0) continue;
                x2 = absX + rnd.nextInt(16) + 8;
                z2 = absZ + rnd.nextInt(16) + 8;
                y2 = rnd.nextInt(256);
                new WorldGenFlowers(Blx.red_flower).func_76484_a(this.world, rnd, x2, y2, z2);
            }
        } else if (sphere.biome == BiomeGenBase.field_76768_g || sphere.biome == BiomeGenBase.field_76774_n) {
            for (int zo = 0; zo < 16; ++zo) {
                for (int xo = 0; xo < 16; ++xo) {
                    int midY = chunk.getChunkBoundSurfaceLevel(xo, zo);
                    x = xo + absX;
                    int z5 = zo + absZ;
                    int y6 = midY + 1;
                    int distanceSquared = sphere.getMainDistance(x, midY, z5);
                    if (distanceSquared > sphere.scaledSphereRadius || !this.world.func_72884_u(x, y6, z5)) continue;
                    this.world.func_147449_b(x, y6, z5, Blx.snow);
                }
            }
        }
        SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)sphere.biome, (int)(absX + 8), (int)(absZ + 8), (int)16, (int)16, (Random)rnd);
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType enumcreaturetype, int i, int j, int k) {
        BiomeGenBase biomegenbase = this.world.func_72807_a(i, k);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(enumcreaturetype);
    }

    public ChunkPosition findClosestStructure(World world1, String s, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int var1, int var2) {
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    private static class ChunkCacheKey {
        public final int x;
        public final int z;
        public final World world;

        public ChunkCacheKey(World world, int x, int z) {
            this.world = world;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkCacheKey)) {
                return false;
            }
            ChunkCacheKey other = (ChunkCacheKey)obj;
            return this.x == other.x && this.z == other.z && this.world == other.world;
        }

        public int hashCode() {
            int worldHash = this.world == null ? 0 : this.world.hashCode();
            return (this.x & 0xFFFF | (this.z & 0xFFFF) << 16) ^ worldHash ^ 0x1303EB55;
        }
    }
}

