/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod;

import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import newBiospheresMod.Configuration.ModConfig;
import newBiospheresMod.Helpers.AvgCalc;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Utils;

public class BiosphereWorldProvider
extends WorldProviderSurface {
    private ModConfig config;
    private static final double searchGridSize = 2.5;
    private static final double searchGridAngles = 12.0;
    private static final double toRadians = 0.5235987755982988;
    private static final AvgCalc avg = new AvgCalc();
    private static long lastPrintedAt = Long.MIN_VALUE;

    public ChunkCoordinates getRandomizedSpawnPoint() {
        ChunkCoordinates coords = super.getSpawnPoint();
        this.FixSpawnLocation(coords);
        return coords;
    }

    public ChunkCoordinates getSpawnPoint() {
        ChunkCoordinates coords = super.getSpawnPoint();
        this.FixSpawnLocation(coords);
        return coords;
    }

    private boolean ValidSpawnLocation(ChunkCoordinates coords) {
        if (coords == null) {
            return true;
        }
        World world = this.field_76579_a;
        if (world == null) {
            return true;
        }
        int x = coords.field_71574_a;
        int z = coords.field_71573_c;
        for (int y = 0; y < 256; ++y) {
            Block block = world.func_147439_a(x, y, z);
            if (block == Blx.air || block.isAir((IBlockAccess)world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public void FixSpawnLocation(ChunkCoordinates coords) {
        ChunkCoordinates orgCoords = Utils.GetCoords(coords);
        double angle = 0.0;
        double power = 1.0;
        while (!this.ValidSpawnLocation(coords)) {
            if ((angle += 1.0) >= 12.0) {
                angle -= 12.0;
                power += 1.0;
            }
            if (power >= 50.0) {
                coords.field_71574_a = orgCoords.field_71574_a;
                coords.field_71573_c = orgCoords.field_71573_c;
                break;
            }
            double x = Math.cos(angle * 0.5235987755982988) * (power * 2.5);
            double z = Math.sin(angle * 0.5235987755982988) * (power * 2.5);
            coords.field_71574_a = orgCoords.field_71574_a + (int)Math.round(x);
            coords.field_71573_c = orgCoords.field_71573_c + (int)Math.round(z);
        }
    }
}

