/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod;

import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import newBiospheresMod.BiosphereChunkManager;
import newBiospheresMod.BiosphereChunkProvider;
import newBiospheresMod.Configuration.CustomWorldData;
import newBiospheresMod.Configuration.ModConfig;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;

public class BiosphereWorldType
extends WorldType {
    private static final LruCacheList<World> BiosphereWorlds = new LruCacheList<World>(3, new IKeyProvider<World>(){

        @Override
        public Object provideKey(World item) {
            return item;
        }
    });
    public static final String IsBiosphereWorldKey = "IsBiosphereWorld";

    public static boolean IsBiosphereWorld(World world) {
        if (world != null) {
            if (BiosphereWorlds.Contains(world)) {
                return true;
            }
            CustomWorldData data = CustomWorldData.FromWorld(world);
            if (data != null && data.getBool(IsBiosphereWorldKey)) {
                BiosphereWorldType.EnsureWorldIsTracked(world);
                return true;
            }
        }
        return false;
    }

    public BiosphereWorldType(String s) {
        super(s);
    }

    public WorldChunkManager getChunkManager(World world) {
        BiomeGenBase.field_76778_j.field_76752_A = BiomeGenBase.field_76778_j.field_76753_B = Blx.netherrack;
        BiomeGenBase.field_76779_k.field_76752_A = BiomeGenBase.field_76779_k.field_76753_B = Blx.end_stone;
        Blx.water.func_149713_g(0);
        Blx.flowing_water.func_149713_g(0);
        Blx.lava.func_149713_g(0);
        Blx.flowing_lava.func_149713_g(0);
        BiosphereWorlds.Push(world);
        return new BiosphereChunkManager(world);
    }

    public IChunkProvider getChunkGenerator(World world, String params) {
        BiosphereWorlds.Push(world);
        return BiosphereChunkProvider.get(world);
    }

    public boolean hasVoidParticles(boolean flag) {
        return false;
    }

    public int getSeaLevel(World world) {
        BiosphereWorlds.Push(world);
        return ModConfig.get(world).getSeaLevel() + 1;
    }

    public double voidFadeMagnitude() {
        return 1.0;
    }

    private static void EnsureWorldIsTracked(World world) {
        if (world != null) {
            BiosphereWorlds.Push(world);
            CustomWorldData data = CustomWorldData.FromWorld(world);
            if (data != null) {
                data.put(IsBiosphereWorldKey, true);
            }
            ModConfig.get(world).update();
        }
    }
}

