/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Configuration;

import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Utils;

public class CustomWorldData
extends WorldSavedData {
    public final String ContainerName;
    private final Map<String, String> Data = new ConcurrentHashMapV8();
    private boolean isNew = true;
    private boolean makeNotNewTriggered = false;

    public boolean getIsNew() {
        return this.isNew;
    }

    public void MakeNotNew() {
        this.makeNotNewTriggered = true;
    }

    public Set<String> Keys() {
        return this.Data.keySet();
    }

    public boolean ContainsKey(String keyName) {
        return this.Data.containsKey(keyName);
    }

    public void put(String keyName, String value) {
        String prevValue = this.Data.put(keyName, value);
        if (prevValue == null ? value != null : !prevValue.equals(value)) {
            this.func_76185_a();
        }
    }

    public String get(String keyName) {
        if (this.ContainsKey(keyName)) {
            return this.Data.get(keyName);
        }
        return null;
    }

    public String RemoveKey(String keyName) {
        String returnValue = this.Data.remove(keyName);
        if (returnValue != null) {
            this.func_76185_a();
        }
        return returnValue;
    }

    public CustomWorldData(String containerName) {
        super(containerName);
        this.ContainerName = containerName;
    }

    public static CustomWorldData FromWorld(World world) {
        return CustomWorldData.FromWorld(world, "New Biospheres Mod".toLowerCase().replace(" ", ""));
    }

    public static CustomWorldData FromWorld(World world, String containerName) {
        MapStorage storage = world.field_72988_C;
        CustomWorldData result = (CustomWorldData)storage.func_75742_a(CustomWorldData.class, containerName);
        if (result == null) {
            result = new CustomWorldData(containerName);
            storage.func_75745_a(containerName, (WorldSavedData)result);
        } else {
            result.MakeNotNew();
        }
        return result;
    }

    private static List<String> GetNbtTagKeys(NBTTagCompound nbtTag) {
        ArrayList<String> keys = new ArrayList<String>();
        if (nbtTag != null) {
            for (Object _key : nbtTag.func_150296_c()) {
                String key = null;
                if (_key != null) {
                    key = _key instanceof String ? (String)_key : _key.toString();
                }
                if (key == null) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public void func_76184_a(NBTTagCompound nbtTag) {
        this.Data.clear();
        if (nbtTag != null) {
            for (String key : CustomWorldData.GetNbtTagKeys(nbtTag)) {
                this.put(key, nbtTag.func_74779_i(key));
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbtTag) {
        if (nbtTag != null) {
            for (String key : CustomWorldData.GetNbtTagKeys(nbtTag)) {
                nbtTag.func_82580_o(key);
            }
            for (String key : this.Keys()) {
                nbtTag.func_74778_a(key, this.Data.get(key));
            }
            if (this.makeNotNewTriggered) {
                this.isNew = false;
                this.makeNotNewTriggered = false;
            }
        }
    }

    public void put(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public void put(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void put(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void put(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void put(String key, Block value) {
        this.put(key, Utils.GetNameOrIdForBlock(value));
    }

    public boolean getBool(String key) {
        return this.getBool(key, false);
    }

    public boolean getBool(String key, boolean defaultValue) {
        if (this.ContainsKey(key)) {
            try {
                return Boolean.parseBoolean(this.get(key));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        if (this.ContainsKey(key)) {
            try {
                return Integer.parseInt(this.get(key));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        if (this.ContainsKey(key)) {
            try {
                return Double.parseDouble(this.get(key));
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        if (this.ContainsKey(key)) {
            try {
                return Float.parseFloat(this.get(key));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Block getBlock(String key) {
        return this.getBlock(key, Blx.air);
    }

    public Block getBlock(String key, Block defaultValue) {
        if (this.ContainsKey(key)) {
            try {
                return Utils.ParseBlock(this.get(key), defaultValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

