/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import newBiospheresMod.BiomeEntry;
import newBiospheresMod.BiosphereWorldType;
import newBiospheresMod.BlockEntry;
import newBiospheresMod.Configuration.CustomWorldData;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;
import newBiospheresMod.Helpers.Predicate;
import newBiospheresMod.Helpers.Utils;

public class ModConfig {
    private static LruCacheList<ModConfig> modConfigs = new LruCacheList<ModConfig>(10, new IKeyProvider<ModConfig>(){

        @Override
        public Object provideKey(ModConfig item) {
            if (item == null) {
                return null;
            }
            return item.World;
        }
    });
    private static Configuration cfgFile = null;
    public final World World;
    public final List<BiomeEntry> AllBiomes;
    private static final int BLOCK_COUNT = 20;
    public final List<BlockEntry> OreOrbBlocks = new ArrayList<BlockEntry>();
    public final List<BlockEntry> StairwayBlocks = new ArrayList<BlockEntry>();
    public static final int DOMETYPE_COUNT = 4;
    public static final int DOMETYPE_BLOCK_COUNT = 4;
    public static final List<BlockEntry>[] DomeBlocks = new ArrayList[4];
    private static final boolean defaultNoiseEnabled = true;
    private boolean noiseEnabled = true;
    private static final float minScale = 0.2f;
    private static final float maxScale = 10.0f;
    private static final float defaultScale = 1.0f;
    private float scale = 1.0f;
    private static final Block defaultOrbBlock = Blx.glass;
    private Block orbBlock = defaultOrbBlock;
    private static final Block defaultBridgeSupportBlock = Blx.planks;
    private Block bridgeSupportBlock = defaultBridgeSupportBlock;
    private static final Block defaultBridgeRailBlock = Blx.fence;
    private Block bridgeRailBlock = defaultBridgeRailBlock;
    private static final Block defaultOutsideFillerBlock = Blx.air;
    private Block outsideFillerBlock = defaultOutsideFillerBlock;
    private static final boolean defaultTallGrassEnabled = true;
    private boolean tallGrassEnabled = true;
    private static final int minGridSize = 5;
    private static final int maxGridSize = 25;
    private static final int defaultGridSize = 9;
    private int gridSize = 9;
    private static final int minBridgeWidth = 1;
    private static final int maxBridgeWidth = 15;
    private static final int defaultBridgeWidth = 2;
    private int bridgeWidth = 2;
    private static final double sphereRadiusMinimumValue = 15.0;
    private static final double sphereRadiusMaximumValue = 80.0;
    private static final double defaultMinSphereRadius = 20.0;
    private double minSphereRadius = 20.0;
    private static final double defaultMaxSphereRadius = 50.0;
    private double maxSphereRadius = 50.0;
    private static final double minOrbRadius = 1.0;
    private static final double maxOrbRadius = 25.0;
    private static final double defaultOrbRadius = 7.0;
    private double orbRadius = 7.0;
    private static final double lakeRatioMinimumValue = 0.1;
    private static final double lakeRatioMaximumValue = 0.75;
    private static final double defaultMinLakeRatio = 0.3;
    private double minLakeRatio = 0.3;
    private static final double defaultMaxLakeRatio = 0.6;
    private double maxLakeRatio = 0.6;
    private static final int seaLevelMinimumValue = 15;
    private static final int seaLevelMaximumValue = 111;
    private static final int defaultSeaLevel = 63;
    private int seaLevel = 63;
    private int scaledGridSize = 0;
    private int scaledOrbRadius = 0;
    private static List<MigrationAction> migrations = null;

    public static ModConfig get(final World world) {
        return modConfigs.FindOrAdd(world, new Creator<ModConfig>(){

            @Override
            public ModConfig create() {
                return new ModConfig(world);
            }
        });
    }

    public static Configuration getConfigFile() {
        return cfgFile;
    }

    public static void setConfigFile(Configuration value) {
        cfgFile = value;
        if (cfgFile != null) {
            cfgFile.setCategoryComment("general", "New Biospheres Mod 0.85: Note, these settings only affect new Worlds; previously created Worlds will persist with their existing settings.");
        }
    }

    public static void updateFile() {
        ModConfig.setConfigFile(ModConfig.getConfigFile());
        ModConfig.get(null).update();
    }

    public boolean isNoiseEnabled() {
        return this.noiseEnabled;
    }

    public void setNoiseEnabled(boolean noiseEnabled) {
        this.noiseEnabled = noiseEnabled;
    }

    private static Property getNoiseEnabledProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Noise Enabled", true, "Controls whether a noise generator is used to generate terrain heights or if the World should be flat.");
    }

    private BooleanWorldProperty getNoiseEnabledWorldProperty() {
        return new BooleanWorldProperty(ModConfig.getNoiseEnabledProperty(), this.isNoiseEnabled(), true);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float value) {
        if (value < 0.2f) {
            value = 0.2f;
        } else if (value > 10.0f) {
            value = 10.0f;
        }
        this.scale = value;
        this.scaledGridSize = 0;
        this.scaledOrbRadius = 0;
    }

    private static Property getScaleProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Scale", 1.0, "The scale of the world to generate.", (double)0.2f, 10.0);
    }

    private FloatWorldProperty getScaleWorldProperty() {
        return new FloatWorldProperty(ModConfig.getScaleProperty(), Float.valueOf(this.getScale()), Float.valueOf(1.0f));
    }

    public Block getOrbBlock() {
        return this.orbBlock;
    }

    public void setOrbBlock(Block value) {
        if (value == null) {
            value = defaultOrbBlock;
        }
        this.orbBlock = value;
    }

    private static Property getOrbBlockProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("oreorbs", "Ore Orb Shell Block", Utils.GetNameOrIdForBlock(defaultOrbBlock), "The Block to use for the shell of the generated Ore Orbs.");
    }

    private BlockWorldProperty getOrbBlockWorldProperty() {
        return new BlockWorldProperty(ModConfig.getOrbBlockProperty(), this.getOrbBlock(), defaultOrbBlock);
    }

    public Block getBridgeSupportBlock() {
        return this.bridgeSupportBlock;
    }

    public void setBridgeSupportBlock(Block value) {
        if (value == null) {
            value = defaultBridgeSupportBlock;
        }
        this.bridgeSupportBlock = value;
    }

    private static Property getBridgeSupportBlockProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Bridge Support Block", Utils.GetNameOrIdForBlock(defaultBridgeSupportBlock), "The Block to use for bridges between bio-domes and stairways to ore-orbs.");
    }

    private BlockWorldProperty getBridgeSupportBlockWorldProperty() {
        return new BlockWorldProperty(ModConfig.getBridgeSupportBlockProperty(), this.getBridgeSupportBlock(), defaultBridgeSupportBlock);
    }

    public Block getBridgeRailBlock() {
        return this.bridgeRailBlock;
    }

    public void setBridgeRailBlock(Block value) {
        if (value == null) {
            value = defaultBridgeRailBlock;
        }
        this.bridgeRailBlock = value;
    }

    private static Property getBridgeRailBlockProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Bridge Rail Block", Utils.GetNameOrIdForBlock(defaultBridgeRailBlock), "The Block to use for the rails on the bridges between bio-domes.");
    }

    private BlockWorldProperty getBridgeRailBlockWorldProperty() {
        return new BlockWorldProperty(ModConfig.getBridgeRailBlockProperty(), this.getBridgeRailBlock(), defaultBridgeRailBlock);
    }

    public Block getOutsideFillerBlock() {
        return this.outsideFillerBlock;
    }

    public void setOutsideFillerBlock(Block value) {
        if (value == null) {
            value = defaultOutsideFillerBlock;
        }
        this.outsideFillerBlock = value;
    }

    private static Property getOutsideFillerBlockProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Outside Filler Block", Utils.GetNameOrIdForBlock(defaultOutsideFillerBlock), "The block used to fill the area outside of the domes [air, water, and lava are good choices].");
    }

    private BlockWorldProperty getOutsideFillerBlockWorldProperty() {
        return new BlockWorldProperty(ModConfig.getOutsideFillerBlockProperty(), this.getOutsideFillerBlock(), defaultOutsideFillerBlock);
    }

    public boolean isTallGrassEnabled() {
        return this.tallGrassEnabled;
    }

    public void setTallGrassEnabled(boolean tallGrass) {
        this.tallGrassEnabled = tallGrass;
    }

    private static Property getTallGrassEnabledProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("biospheres", "Tall Grass Enabled", true, "Controls whether tall grass is generated or not.");
    }

    private BooleanWorldProperty getTallGrassEnabledWorldProperty() {
        return new BooleanWorldProperty(ModConfig.getTallGrassEnabledProperty(), this.isTallGrassEnabled(), true);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int value) {
        if (value < 5) {
            value = 5;
        } else if (value > 25) {
            value = 25;
        }
        this.gridSize = value;
        this.scaledGridSize = 0;
    }

    private static Property getGridSizeProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Grid Size", 9, "The size of the grid (for one sphere and orb) in chunks (pre-scaled)[a 'chunk' is 16 blocks square].", 5, 25);
    }

    private IntegerWorldProperty getGridSizeWorldProperty() {
        return new IntegerWorldProperty(ModConfig.getGridSizeProperty(), this.getGridSize(), 9);
    }

    public int getBridgeWidth() {
        return this.bridgeWidth;
    }

    public void setBridgeWidth(int value) {
        if (value < 1) {
            value = 1;
        } else if (value > 15) {
            value = 15;
        }
        this.bridgeWidth = value;
    }

    private static Property getBridgeWidthProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Bridge Width", 2, "Bridge Width: the width of the bridge [from the center to the edge].", 1, 15);
    }

    private IntegerWorldProperty getBridgeWidthWorldProperty() {
        return new IntegerWorldProperty(ModConfig.getBridgeWidthProperty(), this.getBridgeWidth(), 2);
    }

    public double getMinSphereRadius() {
        return this.minSphereRadius;
    }

    public void setMinSphereRadius(double value) {
        if (value < 15.0) {
            value = 15.0;
        } else if (value > 80.0) {
            value = 80.0;
        }
        this.minSphereRadius = value;
    }

    private static Property getMinSphereRadiusProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("biospheres", "Sphere Radius (Minimum)", 20.0, "The minimum (pre-scaled) sphere radius to generate.", 15.0, 80.0);
    }

    private DoubleWorldProperty getMinSphereRadiusWorldProperty() {
        return new DoubleWorldProperty(ModConfig.getMinSphereRadiusProperty(), this.getMinSphereRadius(), 20.0);
    }

    public double getMaxSphereRadius() {
        return this.maxSphereRadius;
    }

    public void setMaxSphereRadius(double value) {
        if (value < 15.0) {
            value = 15.0;
        } else if (value > 80.0) {
            value = 80.0;
        }
        this.maxSphereRadius = value;
    }

    private static Property getMaxSphereRadiusProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("biospheres", "Sphere Radius (Maximum)", 50.0, "The maximum (pre-scaled) sphere radius to generate.", 15.0, 80.0);
    }

    private DoubleWorldProperty getMaxSphereRadiusWorldProperty() {
        return new DoubleWorldProperty(ModConfig.getMaxSphereRadiusProperty(), this.getMaxSphereRadius(), 50.0);
    }

    public double getOrbRadius() {
        return this.orbRadius;
    }

    public void setOrbRadius(double value) {
        if (value < 1.0) {
            value = 1.0;
        } else if (value > 25.0) {
            value = 25.0;
        }
        this.orbRadius = value;
        this.scaledOrbRadius = 0;
    }

    private static Property getOrbRadiusProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("oreorbs", "Ore Orb Radius", 7.0, "The radius (pre-scaled) of the ore orbs to generate.", 1.0, 25.0);
    }

    private DoubleWorldProperty getOrbRadiusWorldProperty() {
        return new DoubleWorldProperty(ModConfig.getOrbRadiusProperty(), this.getOrbRadius(), 7.0);
    }

    public double getMinLakeRatio() {
        return this.minLakeRatio;
    }

    public void setMinLakeRatio(double value) {
        if (value < 0.1) {
            value = 0.1;
        } else if (value > 0.75) {
            value = 0.75;
        }
        this.minLakeRatio = value;
    }

    private static Property getMinLakeRatioProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("biospheres", "Lake Ratio (Minimum)", 0.3, "The minimum ratio of lake size to sphere size.", 0.1, 0.75);
    }

    private DoubleWorldProperty getMinLakeRatioWorldProperty() {
        return new DoubleWorldProperty(ModConfig.getMinLakeRatioProperty(), this.getMinLakeRatio(), 0.3);
    }

    public double getMaxLakeRatio() {
        return this.maxLakeRatio;
    }

    public void setMaxLakeRatio(double value) {
        if (value < 0.1) {
            value = 0.1;
        } else if (value > 0.75) {
            value = 0.75;
        }
        this.maxLakeRatio = value;
    }

    private static Property getMaxLakeRatioProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("biospheres", "Lake Ratio (Maximum)", 0.6, "The maximum ratio of lake size to sphere size.", 0.1, 0.75);
    }

    private DoubleWorldProperty getMaxLakeRatioWorldProperty() {
        return new DoubleWorldProperty(ModConfig.getMaxLakeRatioProperty(), this.getMaxLakeRatio(), 0.6);
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int value) {
        if (value < 15) {
            value = 15;
        } else if (value > 111) {
            value = 111;
        }
        this.seaLevel = value;
    }

    private static Property getSeaLevelProperty() {
        if (cfgFile == null) {
            return null;
        }
        return cfgFile.get("general", "Sea Level", 63, "Sea Level (the default vertical center of the Biospheres).", 15, 111);
    }

    private IntegerWorldProperty getSeaLevelWorldProperty() {
        return new IntegerWorldProperty(ModConfig.getSeaLevelProperty(), this.getSeaLevel(), 63);
    }

    public int getScaledGridSize() {
        if (this.scaledGridSize == 0) {
            this.scaledGridSize = (int)((float)this.gridSize * this.scale);
        }
        return this.scaledGridSize;
    }

    public int getScaledOrbRadius() {
        if (this.scaledOrbRadius == 0) {
            this.scaledOrbRadius = (int)((float)this.orbRadius * this.scale);
        }
        return this.scaledOrbRadius;
    }

    public boolean doesNeedProtectionGlass() {
        return this.getOutsideFillerBlock() != Blx.air;
    }

    private String GetCategoryName(Property input) {
        return ModConfig.GetCategoryName(input, cfgFile);
    }

    private static String GetCategoryName(Property input, Configuration cfgFile) {
        String fallback = null;
        String propName = input.getName();
        for (String catName : cfgFile.getCategoryNames()) {
            ConfigCategory cat = cfgFile.getCategory(catName);
            if (cat == null || !cat.containsKey(propName)) continue;
            if (fallback == null) {
                fallback = catName;
            }
            if (cat.get(propName) != input) continue;
            return catName;
        }
        return fallback;
    }

    private String GetOldWorldProperty(Property input) {
        return ModConfig.GetOldWorldProperty(input.getName());
    }

    private static String GetOldWorldProperty(String propName) {
        return "New Biospheres Mod." + propName;
    }

    private String GetNewWorldProperty(Property input) {
        return ModConfig.GetNewWorldProperty(input, cfgFile);
    }

    private static String GetNewWorldProperty(Property input, Configuration cfgFile) {
        return ModConfig.GetNewWorldProperty(ModConfig.GetCategoryName(input, cfgFile), input.getName());
    }

    private static String GetNewWorldProperty(String category, String propName) {
        String result = category + "." + propName;
        result = result.toLowerCase().replace(" ", "");
        return result;
    }

    private synchronized void InitMigrations() {
        if (migrations == null) {
            migrations = new ArrayList<MigrationAction>();
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Dome Block"));
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Sphere Radius (Minimum)"));
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Sphere Radius (Maximum)"));
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Lake Ratio (Minimum)"));
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Lake Ratio (Maximum)"));
            migrations.add(new PropertyMovedMigration("general", "biospheres", "Tall Grass Enabled"));
            migrations.add(new PropertyMovedMigration("general", "oreorbs", "Ore Orb Radius"));
            migrations.add(new PropertyRenamedMigration("biospheres", "Dome Block", "Dome Type #0 - Block #0"));
        }
    }

    private void PerformFileMigrations() {
        this.InitMigrations();
        if (cfgFile != null) {
            for (MigrationAction mige : migrations) {
                mige.PerformConfigMigration(cfgFile);
            }
            if (cfgFile.hasChanged()) {
                cfgFile.save();
            }
        }
    }

    private static void MigrateWorldProperty(GameRules rules, CustomWorldData data, String category, String propertyName) {
        String oldName;
        if (rules != null && data != null && rules.func_82765_e(oldName = ModConfig.GetOldWorldProperty(propertyName))) {
            String value = rules.func_82767_a(oldName);
            data.put(ModConfig.GetNewWorldProperty(category, propertyName), value);
        }
    }

    private static void MigrateWorldProperty(CustomWorldData data, String oldCategory, String newCategory, String oldPropertyName, String newPropertyName) {
        if (data != null) {
            String oldName = ModConfig.GetNewWorldProperty(oldCategory, oldPropertyName);
            String newName = ModConfig.GetNewWorldProperty(newCategory, newPropertyName);
            if (data.ContainsKey(oldName)) {
                String value = data.get(oldName);
                data.RemoveKey(oldName);
                data.put(newName, value);
            }
        }
    }

    private void PerformWorldMigrations() {
        String ruleName;
        this.InitMigrations();
        if (this.World == null) {
            return;
        }
        CustomWorldData data = CustomWorldData.FromWorld(this.World);
        if (data == null) {
            return;
        }
        GameRules rules = Utils.GetGameRules(this.World);
        if (rules != null && rules.func_82766_b(ruleName = "New Biospheres Mod.Is Biosphere World")) {
            data.put("IsBiosphereWorld", true);
        }
        if (rules != null && cfgFile != null) {
            for (String catName : cfgFile.getCategoryNames()) {
                ConfigCategory cat = cfgFile.getCategory(catName);
                for (String propName : cat.getValues().keySet()) {
                    ModConfig.MigrateWorldProperty(rules, data, catName, propName);
                }
            }
        }
        for (MigrationAction mige : migrations) {
            mige.PerformWorldMigration(data, cfgFile);
        }
        data.MakeNotNew();
        data.func_76186_a(true);
    }

    private static Predicate<BiomeEntry> SearchFor(final BiomeGenBase biome) {
        return new Predicate<BiomeEntry>(){

            @Override
            public boolean test(BiomeEntry entry) {
                return entry.biome == biome;
            }
        };
    }

    private static int GetDefaultBiomeWeight(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76767_f) {
            return 50;
        }
        if (biome == BiomeGenBase.field_76768_g) {
            return 40;
        }
        if (biome == BiomeGenBase.field_76780_h) {
            return 40;
        }
        if (biome == BiomeGenBase.field_76778_j) {
            return 10;
        }
        if (biome == BiomeGenBase.field_76789_p) {
            return 5;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return 2;
        }
        return 25;
    }

    private Property GetBiomeEntryProperty(BiomeEntry biomeEntry) {
        if (cfgFile == null) {
            return null;
        }
        if (biomeEntry == null) {
            return null;
        }
        BiomeGenBase biome = biomeEntry.biome;
        if (biome == null) {
            return null;
        }
        return cfgFile.get("biomeweights", biome.field_76791_y, ModConfig.GetDefaultBiomeWeight(biome), "The weighted chance that the \"" + biome.field_76791_y + "\" biome will be generated.", 0, 1000);
    }

    private static BlockEntry GetDefaultOreBlockEntry(int index) {
        if (index == 0) {
            return new BlockEntry(Blx.lapis_ore, 5);
        }
        if (index == 1) {
            return new BlockEntry(Blx.emerald_ore, 5);
        }
        if (index == 2) {
            return new BlockEntry(Blx.diamond_ore, 5);
        }
        if (index == 3) {
            return new BlockEntry(Blx.iron_ore, 10);
        }
        if (index == 4) {
            return new BlockEntry(Blx.gold_ore, 10);
        }
        if (index == 5) {
            return new BlockEntry(Blx.coal_ore, 15);
        }
        if (index == 6) {
            return new BlockEntry(Blx.redstone_ore, 15);
        }
        if (index == 7) {
            return new BlockEntry(Blx.quartz_ore, 10);
        }
        if (index == 8) {
            return new BlockEntry(Blx.gravel, 100);
        }
        if (index == 9) {
            return new BlockEntry(Blx.lava, 15);
        }
        if (index == 10) {
            return new BlockEntry(Blx.stone, 310);
        }
        return new BlockEntry(Blx.air, 0);
    }

    private static BlockEntry GetDefaultStairBlockEntry(int index) {
        if (index == 0) {
            return new BlockEntry(Blx.planks, 50);
        }
        if (index == 1) {
            return new BlockEntry(Blx.air, 50);
        }
        return new BlockEntry(Blx.air, 0);
    }

    private static BlockEntry GetDefaultDomeBlockProperty(int domeTypeIndex, int blockIndex) {
        if (blockIndex == 0 && domeTypeIndex == 0) {
            return new BlockEntry(Blx.glass, 10);
        }
        return new BlockEntry(Blx.air, 0);
    }

    private Property GetDomeBlockProperty(int domeTypeIndex, int blockIndex) {
        if (cfgFile == null) {
            return null;
        }
        BlockEntry be = ModConfig.GetDefaultDomeBlockProperty(domeTypeIndex, blockIndex);
        String domeIdxStr = Integer.toString(domeTypeIndex);
        String blockIdxStr = Integer.toString(blockIndex);
        Property ret = cfgFile.get("biospheres", "Dome Type #" + domeIdxStr + " - Block #" + blockIdxStr, be.toString(), "The chance that a given dome type will produce a given block.  Values have two parts, and are separated by a comma.  The left side of the comma specifies the block name or Id, and the right side of the comma specifies the weighted chance to produce that block as part of a given dome type.");
        return ret;
    }

    private Property GetRandomOreBlockEntryProperty(int index) {
        if (cfgFile == null) {
            return null;
        }
        BlockEntry be = ModConfig.GetDefaultOreBlockEntry(index);
        String idxStr = Integer.toString(index);
        while (idxStr.length() < 2) {
            idxStr = "0" + idxStr;
        }
        return cfgFile.get("oreorbs", "Random Ore #" + idxStr, be.toString(), "The chance that the Ore Orb will produce a given block.  Values have two parts, and are separated by a comma.  The left side of the comma specifies the block name or Id, and the right side of the comma specifies the weighted chance to produce that block inside an Ore Orb.");
    }

    private Property GetRandomStairwayBlockEntryProperty(int index) {
        if (cfgFile == null) {
            return null;
        }
        BlockEntry be = ModConfig.GetDefaultStairBlockEntry(index);
        String idxStr = Integer.toString(index);
        while (idxStr.length() < 2) {
            idxStr = "0" + idxStr;
        }
        return cfgFile.get("oreorbs", "Random Stairway #" + idxStr, be.toString(), "The chance that a given block will be present in an Ore Orb's stairway pattern.  Values have two parts, and are separated by a comma.  The left side of the comma specifies the block name or Id, and the right side of the comma specifies the weighted chance to produce that block as a part of an Ore Orb's stairway.");
    }

    private ModConfig(World world) {
        this.World = world;
        ArrayList<BiomeEntry> entries = new ArrayList<BiomeEntry>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || Utils.Any(Utils.Where(entries, ModConfig.SearchFor(biome)))) continue;
            entries.add(new BiomeEntry(biome, ModConfig.GetDefaultBiomeWeight(biome)));
        }
        this.AllBiomes = Collections.unmodifiableList(entries);
        this.update();
    }

    public void update() {
        this.PerformFileMigrations();
        this.LoadConfigurationFromFile();
        this.SaveConfigurationToFile();
        this.PerformWorldMigrations();
        this.LoadConfigurationFromWorld();
        this.SaveConfigurationToWorld();
    }

    private void LoadConfigurationFromWorld() {
        Property prop;
        BlockEntry value;
        String keyName;
        Property prop2;
        int i;
        if (this.World == null) {
            return;
        }
        if (!BiosphereWorldType.IsBiosphereWorld(this.World)) {
            return;
        }
        CustomWorldData data = CustomWorldData.FromWorld(this.World);
        if (data == null) {
            return;
        }
        this.setNoiseEnabled((Boolean)this.getNoiseEnabledWorldProperty().ReadWorldValue(data));
        this.setScale(((Float)this.getScaleWorldProperty().ReadWorldValue(data)).floatValue());
        this.setOrbBlock((Block)this.getOrbBlockWorldProperty().ReadWorldValue(data));
        this.setBridgeSupportBlock((Block)this.getBridgeSupportBlockWorldProperty().ReadWorldValue(data));
        this.setBridgeRailBlock((Block)this.getBridgeRailBlockWorldProperty().ReadWorldValue(data));
        this.setOutsideFillerBlock((Block)this.getOutsideFillerBlockWorldProperty().ReadWorldValue(data));
        this.setTallGrassEnabled((Boolean)this.getTallGrassEnabledWorldProperty().ReadWorldValue(data));
        this.setGridSize((Integer)this.getGridSizeWorldProperty().ReadWorldValue(data));
        this.setBridgeWidth((Integer)this.getBridgeWidthWorldProperty().ReadWorldValue(data));
        this.setMinSphereRadius((Double)this.getMinSphereRadiusWorldProperty().ReadWorldValue(data));
        this.setMaxSphereRadius((Double)this.getMaxSphereRadiusWorldProperty().ReadWorldValue(data));
        this.setOrbRadius((Double)this.getOrbRadiusWorldProperty().ReadWorldValue(data));
        this.setMinLakeRatio((Double)this.getMinLakeRatioWorldProperty().ReadWorldValue(data));
        this.setMaxLakeRatio((Double)this.getMaxLakeRatioWorldProperty().ReadWorldValue(data));
        this.setSeaLevel((Integer)this.getSeaLevelWorldProperty().ReadWorldValue(data));
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomOreBlockEntryProperty(i);
            if (prop2 == null || !data.ContainsKey(keyName = this.GetNewWorldProperty(prop2))) continue;
            value = BlockEntry.Parse(data.get(keyName));
            if (this.OreOrbBlocks.size() > i) {
                this.OreOrbBlocks.set(i, value);
                continue;
            }
            this.OreOrbBlocks.add(value);
        }
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomStairwayBlockEntryProperty(i);
            if (prop2 == null || !data.ContainsKey(keyName = this.GetNewWorldProperty(prop2))) continue;
            value = BlockEntry.Parse(data.get(keyName));
            if (this.StairwayBlocks.size() > i) {
                this.StairwayBlocks.set(i, value);
                continue;
            }
            this.StairwayBlocks.add(value);
        }
        int biomeCount = 0;
        for (BiomeEntry entry : this.AllBiomes) {
            prop = this.GetBiomeEntryProperty(entry);
            if (prop == null) continue;
            entry.field_76292_a = data.getInt(this.GetNewWorldProperty(prop), entry.field_76292_a);
            biomeCount += entry.field_76292_a;
        }
        if (biomeCount <= 0) {
            this.LoadBiomeWeightsFromFile();
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (DomeBlocks[i2] == null) {
                ModConfig.DomeBlocks[i2] = new ArrayList<BlockEntry>();
            }
            for (int j = 0; j < 4; ++j) {
                String keyName2;
                prop = this.GetDomeBlockProperty(i2, j);
                if (prop == null || !data.ContainsKey(keyName2 = this.GetNewWorldProperty(prop))) continue;
                BlockEntry value2 = BlockEntry.Parse(data.get(keyName2));
                if (DomeBlocks[i2].size() > j) {
                    DomeBlocks[i2].set(j, value2);
                    continue;
                }
                DomeBlocks[i2].add(value2);
            }
        }
    }

    private void SaveConfigurationToWorld() {
        String keyName;
        Property prop;
        String value;
        String keyName2;
        Property prop2;
        int i;
        if (!BiosphereWorldType.IsBiosphereWorld(this.World)) {
            return;
        }
        CustomWorldData data = CustomWorldData.FromWorld(this.World);
        if (data == null) {
            return;
        }
        this.getNoiseEnabledWorldProperty().WriteWorldValue(data);
        this.getScaleWorldProperty().WriteWorldValue(data);
        this.getOrbBlockWorldProperty().WriteWorldValue(data);
        this.getBridgeSupportBlockWorldProperty().WriteWorldValue(data);
        this.getBridgeRailBlockWorldProperty().WriteWorldValue(data);
        this.getOutsideFillerBlockWorldProperty().WriteWorldValue(data);
        this.getTallGrassEnabledWorldProperty().WriteWorldValue(data);
        this.getGridSizeWorldProperty().WriteWorldValue(data);
        this.getBridgeWidthWorldProperty().WriteWorldValue(data);
        this.getMinSphereRadiusWorldProperty().WriteWorldValue(data);
        this.getMaxSphereRadiusWorldProperty().WriteWorldValue(data);
        this.getOrbRadiusWorldProperty().WriteWorldValue(data);
        this.getMinLakeRatioWorldProperty().WriteWorldValue(data);
        this.getMaxLakeRatioWorldProperty().WriteWorldValue(data);
        this.getSeaLevelWorldProperty().WriteWorldValue(data);
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomOreBlockEntryProperty(i);
            if (prop2 == null) continue;
            keyName2 = this.GetNewWorldProperty(prop2);
            value = "air, 0";
            if (this.OreOrbBlocks.size() > i) {
                value = this.OreOrbBlocks.get(i).toString();
            }
            data.put(keyName2, value);
        }
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomStairwayBlockEntryProperty(i);
            if (prop2 == null) continue;
            keyName2 = this.GetNewWorldProperty(prop2);
            value = "air, 0";
            if (this.StairwayBlocks.size() > i) {
                value = this.StairwayBlocks.get(i).toString();
            }
            data.put(keyName2, value);
        }
        for (BiomeEntry entry : this.AllBiomes) {
            prop = this.GetBiomeEntryProperty(entry);
            if (prop == null) continue;
            keyName = this.GetNewWorldProperty(prop);
            data.put(keyName, entry.field_76292_a);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 4; ++j) {
                prop = this.GetDomeBlockProperty(i2, j);
                if (prop == null) continue;
                keyName = this.GetNewWorldProperty(prop);
                String value2 = "air, 0";
                if (DomeBlocks[i2] != null && DomeBlocks[i2].size() > j) {
                    value2 = DomeBlocks[i2].get(j).toString();
                }
                data.put(keyName, value2);
            }
        }
    }

    private void LoadConfigurationFromFile() {
        if (cfgFile == null) {
            return;
        }
        this.setNoiseEnabled(ModConfig.getNoiseEnabledProperty().getBoolean());
        this.setScale((float)ModConfig.getScaleProperty().getDouble());
        this.setOrbBlock(Utils.ParseBlock(ModConfig.getOrbBlockProperty().getString(), defaultOrbBlock));
        this.setBridgeSupportBlock(Utils.ParseBlock(ModConfig.getBridgeSupportBlockProperty().getString(), defaultBridgeSupportBlock));
        this.setBridgeRailBlock(Utils.ParseBlock(ModConfig.getBridgeRailBlockProperty().getString(), defaultBridgeRailBlock));
        this.setOutsideFillerBlock(Utils.ParseBlock(ModConfig.getOutsideFillerBlockProperty().getString(), defaultOutsideFillerBlock));
        this.setTallGrassEnabled(ModConfig.getTallGrassEnabledProperty().getBoolean());
        this.setGridSize(ModConfig.getGridSizeProperty().getInt());
        this.setBridgeWidth(ModConfig.getBridgeWidthProperty().getInt());
        this.setMinSphereRadius(ModConfig.getMinSphereRadiusProperty().getDouble());
        this.setMaxSphereRadius(ModConfig.getMaxSphereRadiusProperty().getDouble());
        this.setOrbRadius(ModConfig.getOrbRadiusProperty().getDouble());
        this.setMinLakeRatio(ModConfig.getMinLakeRatioProperty().getDouble());
        this.setMaxLakeRatio(ModConfig.getMaxLakeRatioProperty().getDouble());
        this.setSeaLevel(ModConfig.getSeaLevelProperty().getInt());
        this.LoadDomeBlocksFromFile();
        this.LoadOreBlocksFromFile();
        this.LoadStairwayBlocksFromFile();
        this.LoadBiomeWeightsFromFile();
        if (cfgFile.hasChanged()) {
            cfgFile.save();
        }
    }

    private void LoadDomeBlocksFromFile() {
        for (int i = 0; i < 4; ++i) {
            if (DomeBlocks[i] == null) {
                ModConfig.DomeBlocks[i] = new ArrayList<BlockEntry>();
            }
            for (int j = 0; j < 4; ++j) {
                Property prop = this.GetDomeBlockProperty(i, j);
                if (prop == null) continue;
                BlockEntry value = BlockEntry.Parse(prop.getString());
                if (DomeBlocks[i].size() > j) {
                    DomeBlocks[i].set(j, value);
                    continue;
                }
                DomeBlocks[i].add(value);
            }
        }
    }

    private void LoadOreBlocksFromFile() {
        for (int i = 0; i < 20; ++i) {
            Property prop = this.GetRandomOreBlockEntryProperty(i);
            if (prop == null) continue;
            BlockEntry value = BlockEntry.Parse(prop.getString());
            if (this.OreOrbBlocks.size() > i) {
                this.OreOrbBlocks.set(i, value);
                continue;
            }
            this.OreOrbBlocks.add(value);
        }
        int oreCount = 0;
        for (BlockEntry block : this.OreOrbBlocks) {
            oreCount += block.field_76292_a;
        }
        if (oreCount <= 0) {
            this.OreOrbBlocks.add(new BlockEntry(Blx.stone, 1));
        }
    }

    private void LoadStairwayBlocksFromFile() {
        for (int i = 0; i < 20; ++i) {
            Property prop = this.GetRandomStairwayBlockEntryProperty(i);
            if (prop == null) continue;
            BlockEntry value = BlockEntry.Parse(prop.getString());
            if (this.StairwayBlocks.size() > i) {
                this.StairwayBlocks.set(i, value);
                continue;
            }
            this.StairwayBlocks.add(value);
        }
        int blockCount = 0;
        for (BlockEntry block : this.StairwayBlocks) {
            blockCount += block.field_76292_a;
        }
        if (blockCount <= 0) {
            this.StairwayBlocks.add(new BlockEntry(Blx.air, 1));
        }
    }

    private void LoadBiomeWeightsFromFile() {
        int count = 0;
        if (cfgFile != null) {
            for (BiomeEntry entry : this.AllBiomes) {
                Property prop = this.GetBiomeEntryProperty(entry);
                if (prop == null) continue;
                int weight = prop.getInt(ModConfig.GetDefaultBiomeWeight(entry.biome));
                if (weight < 0) {
                    weight = 0;
                }
                entry.field_76292_a = weight;
                count += weight;
            }
        }
        if (count <= 0) {
            for (BiomeEntry entry : this.AllBiomes) {
                entry.field_76292_a = ModConfig.GetDefaultBiomeWeight(entry.biome);
            }
        }
    }

    private void SaveConfigurationToFile() {
        Property prop;
        String value;
        Property prop2;
        int i;
        if (cfgFile == null) {
            return;
        }
        ModConfig.getNoiseEnabledProperty().set(this.isNoiseEnabled());
        ModConfig.getScaleProperty().set((double)this.getScale());
        ModConfig.getOrbBlockProperty().set(Utils.GetNameOrIdForBlock(this.getOrbBlock()));
        ModConfig.getBridgeSupportBlockProperty().set(Utils.GetNameOrIdForBlock(this.getBridgeSupportBlock()));
        ModConfig.getBridgeRailBlockProperty().set(Utils.GetNameOrIdForBlock(this.getBridgeRailBlock()));
        ModConfig.getOutsideFillerBlockProperty().set(Utils.GetNameOrIdForBlock(this.getOutsideFillerBlock()));
        ModConfig.getTallGrassEnabledProperty().set(this.isTallGrassEnabled());
        ModConfig.getGridSizeProperty().set(this.getGridSize());
        ModConfig.getBridgeWidthProperty().set(this.getBridgeWidth());
        ModConfig.getMinSphereRadiusProperty().set(this.getMinSphereRadius());
        ModConfig.getMaxSphereRadiusProperty().set(this.getMaxSphereRadius());
        ModConfig.getOrbRadiusProperty().set(this.getOrbRadius());
        ModConfig.getMinLakeRatioProperty().set(this.getMinLakeRatio());
        ModConfig.getMaxLakeRatioProperty().set(this.getMaxLakeRatio());
        ModConfig.getSeaLevelProperty().set(this.getSeaLevel());
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomOreBlockEntryProperty(i);
            if (prop2 == null) continue;
            value = "air, 0";
            if (this.OreOrbBlocks.size() > i) {
                value = this.OreOrbBlocks.get(i).toString();
            }
            prop2.set(value);
        }
        for (i = 0; i < 20; ++i) {
            prop2 = this.GetRandomStairwayBlockEntryProperty(i);
            if (prop2 == null) continue;
            value = "air, 0";
            if (this.StairwayBlocks.size() > i) {
                value = this.StairwayBlocks.get(i).toString();
            }
            prop2.set(value);
        }
        for (BiomeEntry entry : this.AllBiomes) {
            prop = this.GetBiomeEntryProperty(entry);
            if (prop == null) continue;
            prop.set(ModConfig.GetDefaultBiomeWeight(entry.biome));
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 4; ++j) {
                prop = this.GetDomeBlockProperty(i2, j);
                if (prop == null) continue;
                String value2 = "air, 0";
                if (DomeBlocks[i2] != null && DomeBlocks[i2].size() > j) {
                    value2 = DomeBlocks[i2].get(j).toString();
                }
                prop.set(value2);
            }
        }
        if (cfgFile.hasChanged()) {
            cfgFile.save();
        }
    }

    private static class PropertyMovedMigration
    extends MigrationAction {
        public final String OldCategory;
        public final String NewCategory;
        public final String PropertyName;

        public PropertyMovedMigration(String oldCategory, String newCategory, String propertyName) {
            this.OldCategory = oldCategory;
            this.NewCategory = newCategory;
            this.PropertyName = propertyName;
        }

        @Override
        public void PerformConfigMigration(Configuration cfgFile) {
            cfgFile.moveProperty(this.OldCategory, this.PropertyName, this.NewCategory);
        }

        @Override
        public void PerformWorldMigration(CustomWorldData data, Configuration cfgFile) {
            ModConfig.MigrateWorldProperty(data, this.OldCategory, this.NewCategory, this.PropertyName, this.PropertyName);
        }
    }

    private static class PropertyRenamedMigration
    extends MigrationAction {
        public final String Category;
        public final String OldPropertyName;
        public final String NewPropertyName;

        public PropertyRenamedMigration(String category, String oldPropertyName, String newPropertyName) {
            this.Category = category;
            this.OldPropertyName = oldPropertyName;
            this.NewPropertyName = newPropertyName;
        }

        @Override
        public void PerformConfigMigration(Configuration cfgFile) {
            if (cfgFile.hasCategory(this.Category) && cfgFile.hasKey(this.Category, this.OldPropertyName)) {
                cfgFile.renameProperty(this.Category, this.OldPropertyName, this.NewPropertyName);
            }
        }

        @Override
        public void PerformWorldMigration(CustomWorldData data, Configuration cfgFile) {
            ModConfig.MigrateWorldProperty(data, this.Category, this.Category, this.OldPropertyName, this.NewPropertyName);
        }
    }

    private static abstract class MigrationAction {
        private MigrationAction() {
        }

        public abstract void PerformConfigMigration(Configuration var1);

        public abstract void PerformWorldMigration(CustomWorldData var1, Configuration var2);
    }

    private class BlockWorldProperty
    extends WorldProperty<Block> {
        BlockWorldProperty(Property property, Block currentValue, Block defaultValue) {
            super(property, currentValue, defaultValue);
        }

        @Override
        protected Block Convert(String input, CustomWorldData data) throws Throwable {
            return Utils.ParseBlock(input, (Block)this.getFallbackValue(data));
        }

        @Override
        protected String Convert(Block input, CustomWorldData data) {
            return Utils.GetNameOrIdForBlock(input);
        }
    }

    private class DoubleWorldProperty
    extends WorldProperty<Double> {
        DoubleWorldProperty(Property property, Double currentValue, Double defaultValue) {
            super(property, currentValue, defaultValue);
        }

        @Override
        protected Double Convert(String input, CustomWorldData data) throws Throwable {
            return Double.parseDouble(input);
        }

        @Override
        protected String Convert(Double input, CustomWorldData data) {
            return Double.toString(input);
        }
    }

    private class FloatWorldProperty
    extends WorldProperty<Float> {
        FloatWorldProperty(Property property, Float currentValue, Float defaultValue) {
            super(property, currentValue, defaultValue);
        }

        @Override
        protected Float Convert(String input, CustomWorldData data) throws Throwable {
            return Float.valueOf(Float.parseFloat(input));
        }

        @Override
        protected String Convert(Float input, CustomWorldData data) {
            return Float.toString(input.floatValue());
        }
    }

    private class IntegerWorldProperty
    extends WorldProperty<Integer> {
        IntegerWorldProperty(Property property, Integer currentValue, Integer defaultValue) {
            super(property, currentValue, defaultValue);
        }

        @Override
        protected Integer Convert(String input, CustomWorldData data) throws Throwable {
            return Integer.parseInt(input);
        }

        @Override
        protected String Convert(Integer input, CustomWorldData data) {
            return Integer.toString(input);
        }
    }

    private class BooleanWorldProperty
    extends WorldProperty<Boolean> {
        BooleanWorldProperty(Property property, Boolean currentValue, Boolean defaultValue) {
            super(property, currentValue, defaultValue);
        }

        @Override
        protected Boolean Convert(String input, CustomWorldData data) throws Throwable {
            return Boolean.parseBoolean(input);
        }

        @Override
        protected String Convert(Boolean input, CustomWorldData data) {
            return Boolean.toString(input);
        }
    }

    private abstract class WorldProperty<T> {
        public final Property Property;
        public final T DefaultValue;
        public final T CurrentValue;

        protected abstract T Convert(String var1, CustomWorldData var2) throws Throwable;

        protected abstract String Convert(T var1, CustomWorldData var2);

        protected T getFallbackValue(CustomWorldData data) {
            if (data == null) {
                return this.CurrentValue;
            }
            return data.getIsNew() ? this.CurrentValue : this.DefaultValue;
        }

        WorldProperty(Property property, T currentValue, T defaultValue) {
            this.Property = property;
            this.CurrentValue = currentValue;
            this.DefaultValue = defaultValue;
        }

        public T ReadWorldValue(CustomWorldData data) {
            String keyName;
            if (data != null && data.ContainsKey(keyName = ModConfig.this.GetNewWorldProperty(this.Property))) {
                try {
                    return this.Convert(data.get(keyName), data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.getFallbackValue(data);
        }

        public void WriteWorldValue(CustomWorldData data) {
            if (data != null) {
                String keyName = ModConfig.this.GetNewWorldProperty(this.Property);
                data.put(keyName, this.Convert(this.CurrentValue, data));
            }
        }
    }
}

