/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Helpers;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.IKeyProvider;

public class LruCacheList<T> {
    private static final Object nullKeySubstitute = new Object();
    public final int TotalItems;
    public final IKeyProvider<T> KeyProvider;
    private final ConcurrentMap<Object, T> _backingMap;

    public LruCacheList(int totalItems, IKeyProvider<T> keyProvider) {
        this.TotalItems = totalItems;
        this.KeyProvider = keyProvider;
        this._backingMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(totalItems).build();
    }

    public void Push(T item) {
        Object key = this.KeyProvider.provideKey(item);
        if (key == null) {
            key = nullKeySubstitute;
        }
        this._backingMap.put(key, item);
    }

    public boolean Contains(T item) {
        Object key = this.KeyProvider.provideKey(item);
        if (key == null) {
            key = nullKeySubstitute;
        }
        return this._backingMap.containsKey(key);
    }

    public T FindOrAdd(Object key, Creator<T> factory) {
        Object returnValue;
        if (key == null) {
            key = nullKeySubstitute;
        }
        if ((returnValue = this._backingMap.get(key)) == null) {
            try {
                returnValue = factory.create();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (returnValue != null) {
                this._backingMap.put(key, returnValue);
            }
        }
        return (T)returnValue;
    }
}

