/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Helpers;

import net.minecraft.util.ChunkCoordinates;

public class TopDownBoundingBox {
    public final int x1;
    public final int z1;
    public final int x2;
    public final int z2;

    public TopDownBoundingBox(int x1, int z1, int x2, int z2) {
        this.x1 = x1;
        this.z1 = z1;
        this.x2 = x2;
        this.z2 = z2;
    }

    public static TopDownBoundingBox FromChunk(int chunkX, int chunkZ) {
        return new TopDownBoundingBox(chunkX <<= 4, chunkZ <<= 4, chunkX + 15, chunkZ + 15);
    }

    public static TopDownBoundingBox FromCircle(int cx, int cz, int r) {
        return new TopDownBoundingBox(cx - r, cz - r, cx + r, cz + r);
    }

    public static TopDownBoundingBox FromArray(Iterable<ChunkCoordinates> coords) {
        if (coords != null) {
            boolean first = true;
            int maxZ = 0;
            int maxX = 0;
            int minZ = 0;
            int minX = 0;
            for (ChunkCoordinates coord : coords) {
                if (coord == null) continue;
                if (first) {
                    minX = maxX = coord.field_71574_a;
                    minZ = maxZ = coord.field_71573_c;
                    first = false;
                    continue;
                }
                if (coord.field_71574_a < minX) {
                    minX = coord.field_71574_a;
                }
                if (coord.field_71574_a > maxX) {
                    maxX = coord.field_71574_a;
                }
                if (coord.field_71573_c < minZ) {
                    minZ = coord.field_71573_c;
                }
                if (coord.field_71573_c <= maxZ) continue;
                maxZ = coord.field_71573_c;
            }
            if (!first) {
                return new TopDownBoundingBox(minX, minZ, maxX, maxZ);
            }
        }
        return null;
    }

    public boolean CollidesWith(TopDownBoundingBox box) {
        if (box == this) {
            return true;
        }
        if (box == null) {
            return false;
        }
        if (this.x2 < box.x1) {
            return false;
        }
        if (this.z2 < box.z1) {
            return false;
        }
        if (this.x1 > box.x2) {
            return false;
        }
        return this.z1 <= box.z2;
    }

    public boolean CollidesWith(int x, int z) {
        if (x < this.x1) {
            return false;
        }
        if (z < this.z1) {
            return false;
        }
        if (x > this.x2) {
            return false;
        }
        return z <= this.z2;
    }
}

