/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Helpers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Func;
import newBiospheresMod.Helpers.Func2;
import newBiospheresMod.Helpers.Predicate;

public class Utils {
    public static Block ParseBlock(String blockNameOrId) {
        return Utils.ParseBlock(blockNameOrId, Blx.air);
    }

    public static Block ParseBlock(String blockNameOrId, Block fallbackValue) {
        Block returnValue = null;
        try {
            int id = Integer.parseInt(blockNameOrId);
            returnValue = Block.func_149729_e((int)id);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            if (returnValue == null) {
                returnValue = Block.func_149684_b((String)blockNameOrId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (returnValue == null) {
            returnValue = fallbackValue;
        }
        return returnValue;
    }

    public static String GetNameOrIdForBlock(Block block) {
        if (block == null) {
            return "air";
        }
        String ret = null;
        try {
            ret = Block.field_149771_c.func_148750_c((Object)block);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null || ret.length() < 1) {
            ret = Integer.toString(Block.func_149682_b((Block)block));
        }
        if (ret != null && ret.startsWith("minecraft:")) {
            ret = ret.substring(10);
        }
        return ret;
    }

    public static String GetName(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        if (obj instanceof Block) {
            return Utils.GetNameOrIdForBlock((Block)obj);
        }
        String name = obj.getClass().getSimpleName();
        if (name == null || name.length() < 1) {
            name = obj.getClass().getName();
        }
        return name;
    }

    public static boolean IsPlayer(Entity e) {
        if (e == null) {
            return false;
        }
        return e instanceof EntityPlayer;
    }

    public static GameRules GetGameRules(World world) {
        WorldInfo info;
        if (world != null && (info = world.func_72912_H()) != null) {
            return info.func_82574_x();
        }
        return null;
    }

    public static ChunkCoordinates GetCoords(ChunkCoordinates copyMe) {
        if (copyMe == null) {
            return Utils.GetCoords(0, 0, 0);
        }
        return Utils.GetCoords(copyMe.field_71574_a, copyMe.field_71572_b, copyMe.field_71573_c);
    }

    public static ChunkCoordinates GetCoords(Entity e) {
        if (e == null) {
            return Utils.GetCoords(0, 0, 0);
        }
        return Utils.GetCoords(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public static ChunkCoordinates GetCoords(double x, double y, double z) {
        return Utils.GetCoords((int)Math.round(x), (int)Math.round(y), (int)Math.round(z));
    }

    public static ChunkCoordinates GetCoords(int x, int y, int z) {
        ChunkCoordinates coords = new ChunkCoordinates();
        coords.field_71574_a = x;
        coords.field_71572_b = y;
        coords.field_71573_c = z;
        return coords;
    }

    public static boolean FuzzyEquals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        a = a.trim();
        b = b.trim();
        return a.equalsIgnoreCase(b);
    }

    public static <T extends Enum<T>> T ParseEnum(Class<T> _class, String input) {
        return Utils.ParseEnum(_class, input, null);
    }

    public static <T extends Enum<T>> T ParseEnum(Class<T> _class, String input, T fallbackValue) {
        if (input != null && input.length() > 0) {
            for (Field f : _class.getDeclaredFields()) {
                try {
                    if (f.isEnumConstant() && Utils.FuzzyEquals(f.getName(), input)) {
                        return (T)((Enum)f.get(null));
                    }
                }
                catch (Throwable ignoreMe) {
                    // empty catch block
                }
            }
        }
        return fallbackValue;
    }

    public static int RndBetween(Random rnd, int low, int high) {
        double range = high - low;
        range *= rnd.nextDouble();
        range += (double)low;
        if ((range = (double)Math.round(range)) < (double)low) {
            range = low;
        }
        if (range > (double)high) {
            range = high;
        }
        return (int)range;
    }

    public static void DoLine(int x0, int y0, int x1, int y1, Func2<Integer, Integer, Boolean> func) {
        if (func != null) {
            int dx = Math.abs(x1 - x0);
            int dy = Math.abs(y1 - y0);
            int sx = x0 < x1 ? 1 : -1;
            int sy = y0 < y1 ? 1 : -1;
            int err = dx - dy;
            while (true) {
                try {
                    if (!func.func(x0, y0).booleanValue()) {
                    }
                }
                catch (Throwable ignore) {}
                break;
                if (x0 == x1 && y0 == y1) break;
                int e2 = 2 * err;
                if (e2 > -dy) {
                    err -= dy;
                    x0 += sx;
                }
                if (e2 >= dx) continue;
                err += dx;
                y0 += sy;
            }
        }
    }

    public static <T> Iterable<T> Where(Iterable<T> input, final Predicate<T> predicate) {
        if (predicate == null && input != null) {
            return input;
        }
        if (input == null) {
            return new ArrayList();
        }
        final Iterator<T> inner = input.iterator();
        if (inner == null) {
            return new ArrayList();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private boolean hasItem = false;
                    private T _next = null;

                    private T GetNext() {
                        while (!this.hasItem && inner.hasNext()) {
                            Object item = inner.next();
                            if (!predicate.test(item)) continue;
                            this._next = item;
                            this.hasItem = true;
                        }
                        if (!this.hasItem) {
                            this._next = null;
                            return null;
                        }
                        return this._next;
                    }

                    @Override
                    public boolean hasNext() {
                        this.GetNext();
                        return this.hasItem;
                    }

                    @Override
                    public T next() {
                        Object next = this.GetNext();
                        this.hasItem = false;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }
        };
    }

    public static <T> boolean Any(Iterable<T> input) {
        Iterator<T> i$;
        if (input != null && (i$ = input.iterator()).hasNext()) {
            T obj = i$.next();
            return true;
        }
        return false;
    }

    public static double Min(double[] input) {
        if (input == null || input.length < 1) {
            return 0.0;
        }
        double output = input[0];
        for (int i = 1; i < input.length; ++i) {
            if (!(input[i] < output)) continue;
            output = input[i];
        }
        return output;
    }

    public static double Max(double[] input) {
        if (input == null || input.length < 1) {
            return 0.0;
        }
        double output = input[0];
        for (int i = 1; i < input.length; ++i) {
            if (!(input[i] > output)) continue;
            output = input[i];
        }
        return output;
    }

    private static <T> String __ConvertArrayToString(T[] args, Func<T, String> converter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (args != null && converter != null) {
            for (T item : args) {
                try {
                    String value = first ? "" : ", ";
                    value = value + converter.func(item);
                    sb.append(value);
                    first = false;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    private static <T> List<T> __ConvertStringToList(String input, Func<String, T> converter) {
        ArrayList<T> output = new ArrayList<T>();
        if (input != null && input.length() > 0 && converter != null) {
            String[] results;
            for (String result : results = input.split("\\s*,\\s*")) {
                try {
                    if (result == null) continue;
                    output.add(converter.func(result));
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return output;
    }

    public static String ConvertIntegersToString(Integer ... args) {
        return Utils.__ConvertArrayToString(args, new Func<Integer, String>(){

            @Override
            public String func(Integer input) {
                return Integer.toString(input);
            }
        });
    }

    public static List<Integer> ConvertStringToIntegers(String input) {
        return Utils.__ConvertStringToList(input, new Func<String, Integer>(){

            @Override
            public Integer func(String input) {
                return Integer.parseInt(input);
            }
        });
    }

    public static String ConvertDoublesToString(Double ... args) {
        return Utils.__ConvertArrayToString(args, new Func<Double, String>(){

            @Override
            public String func(Double input) {
                return Double.toString(input);
            }
        });
    }

    public static List<Double> ConvertStringToDoubles(String input) {
        return Utils.__ConvertStringToList(input, new Func<String, Double>(){

            @Override
            public Double func(String input) {
                return Double.parseDouble(input);
            }
        });
    }

    public static int GetDistance(ChunkCoordinates coords1, ChunkCoordinates coords2) {
        if (coords2 == null) {
            coords2 = new ChunkCoordinates();
        }
        return Utils.GetDistance(coords1, coords2.field_71574_a, coords2.field_71572_b, coords2.field_71573_c);
    }

    public static int GetDistance(ChunkCoordinates coords, int x, int y, int z) {
        if (coords == null) {
            coords = new ChunkCoordinates();
        }
        return Utils.GetDistance(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, x, y, z);
    }

    public static int GetDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return (int)Math.round(Utils.GetDistance((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static double GetDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1));
    }
}

