/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Models;

import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;
import newBiospheresMod.Helpers.Utils;

public class NoiseChunk {
    private static LruCacheList<NoiseChunk> noiseChunks = new LruCacheList<NoiseChunk>(25, new IKeyProvider<NoiseChunk>(){

        @Override
        public Object provideKey(NoiseChunk item) {
            if (item == null) {
                return null;
            }
            return new CacheKey(item.world, item.chunkX, item.chunkZ);
        }
    });
    public final int chunkX;
    public final int chunkZ;
    public final World world;
    private final double[] noise;
    public final double minNoise;
    public final double maxNoise;
    private final double scale;
    private static final double noiseScale = 0.0078125;
    private final int seaLevel;
    public final NoiseGeneratorOctaves noiseGenerator;

    public static NoiseChunk get(final World world, final int chunkX, final int chunkZ, final NoiseGeneratorOctaves noiseGen, final double scale, final int seaLevel) {
        CacheKey key = new CacheKey(world, chunkX, chunkZ);
        return noiseChunks.FindOrAdd(key, new Creator<NoiseChunk>(){

            @Override
            public NoiseChunk create() {
                return new NoiseChunk(world, chunkX, chunkZ, noiseGen, scale, seaLevel);
            }
        });
    }

    private NoiseChunk(World world, int chunkX, int chunkZ, NoiseGeneratorOctaves noiseGen, double scale, int seaLevel) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.scale = scale;
        this.noiseGenerator = noiseGen;
        this.noise = noiseGen.func_76304_a(null, chunkX << 4, 256, chunkZ << 4, 16, 1, 16, 0.0078125, 1.0, 0.0078125);
        this.minNoise = Utils.Min(this.noise);
        this.maxNoise = Utils.Max(this.noise);
        this.seaLevel = seaLevel;
    }

    public int getChunkBoundSurfaceLevel(int boundX, int boundZ) {
        return this.getChunkBoundSurfaceLevel(boundX, boundZ, this.seaLevel);
    }

    public int getChunkBoundSurfaceLevel(int boundX, int boundZ, int baseLevel) {
        if (boundX < 0 || boundX >= 16) {
            throw new IndexOutOfBoundsException("boundX");
        }
        if (boundZ < 0 || boundZ >= 16) {
            throw new IndexOutOfBoundsException("boundZ");
        }
        double ret = baseLevel;
        return (int)Math.round(ret += this.noise[boundZ + (boundX << 4)] * 8.0 * this.scale);
    }

    public int getRawSurfaceLevel(int rawX, int rawZ) {
        return this.getRawSurfaceLevel(rawX, rawZ, this.seaLevel);
    }

    public int getRawSurfaceLevel(int rawX, int rawZ, int baseLevel) {
        int chunkX = (int)Math.floor((double)rawX / 16.0);
        int chunkZ = (int)Math.floor((double)rawZ / 16.0);
        rawX -= chunkX << 4;
        rawZ -= chunkZ << 4;
        if (this.chunkX == chunkX && this.chunkZ == chunkZ) {
            return this.getChunkBoundSurfaceLevel(rawX, rawZ, baseLevel);
        }
        return NoiseChunk.get(this.world, chunkX, chunkZ, this.noiseGenerator, this.scale, this.seaLevel).getChunkBoundSurfaceLevel(rawX, rawZ);
    }

    public NoiseChunk GetChunkAt(int rawX, int rawZ) {
        int chunkX = (int)Math.floor((double)rawX / 16.0);
        int chunkZ = (int)Math.floor((double)rawZ / 16.0);
        if (this.chunkX == chunkX && this.chunkZ == chunkZ) {
            return this;
        }
        return NoiseChunk.get(this.world, chunkX, chunkZ, this.noiseGenerator, this.scale, this.seaLevel);
    }

    private static class CacheKey {
        public final int x;
        public final int z;
        public final World world;

        public CacheKey(World world, int x, int z) {
            this.world = world;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.x == other.x && this.z == other.z && this.world == other.world;
        }

        public int hashCode() {
            int worldHash = this.world == null ? 0 : this.world.hashCode();
            return (this.x & 0xFFFF | (this.z & 0xFFFF) << 16) ^ worldHash ^ 0x38911794;
        }
    }
}

